package cn.ps1.aolai.utils;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContext implements ApplicationContextAware {

	private static ApplicationContext applicationContext = null;
	private static SpringContext myself = null;

	public synchronized static SpringContext init() {
		if (myself == null) {
			myself = new SpringContext();
		}
		return myself;
	}

	@Override
	public void setApplicationContext(ApplicationContext ctx)
			throws BeansException {
		if (applicationContext == null) {
			applicationContext = ctx;
		}
	}

	// 获取applicationContext上下文
	public static ApplicationContext getApplicationContext() {
		return applicationContext;
	}

	// 通过name获取 Bean.
	public synchronized static Object getBean(String beanName) {
		return applicationContext.getBean(beanName);
	}

	// 通过class获取Bean.
	public synchronized static <T> T getBean(Class<T> clazz) {
		return applicationContext.getBean(clazz);
	}

	// 通过name,以及Clazz返回指定的Bean
	public synchronized static <T> T getBean(String name, Class<T> clazz) {
		return applicationContext.getBean(name, clazz);
	}

}
