package cn.ps1.aolai.utils;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.ThirdService;
import cn.ps1.aolai.service.UtilsService;

/**
 * 通用controller接口拦截器
 * 
 * @author Aolai
 * @version 1.0
 *
 */
@Component
public class Interceptor implements HandlerInterceptor {

	@Autowired
	private RedisService redisSvc;
	@Autowired
	private ThirdService thirdSvc;
	@Autowired
	private UtilsService utilsSvc;

	/**
	 * 所有web请求，经过拦截器统一处理
	 */
	@Override
	public boolean preHandle(HttpServletRequest req, HttpServletResponse rsp,
			Object handler) throws Exception {
		// 首先要进行token验证
		Map<String, String> cookies = utilsSvc.getCookies(req);
		if (!redisSvc.checkToken(cookies)) {
			// && !thirdSvc.thirdLogin(req, rsp, cookies)) {

			// 验证 token无效后，再验证携带的 k参数（相当于appId）
			if (thirdSvc.isSecretKey(req))
				return true;
			
			// 验证 k参数无效后，返回失败！
			return thirdSvc.invlidToken(rsp); // 无效token

		} else if (!thirdSvc.authAccess(req, rsp, cookies)) {
			// 先解码处理，再进行鉴权控制
			// rsp.setStatus(403);
			return false; // 鉴权失败
		}
		return true;
	}

	@Override
	public void postHandle(HttpServletRequest req, HttpServletResponse rsp,
			Object handler, ModelAndView modelAndView) throws Exception {
	}

	@Override
	public void afterCompletion(HttpServletRequest req,
			HttpServletResponse rsp, Object handler, Exception ex)
			throws Exception {
	}

}
