package cn.ps1.aolai.utils;

import java.nio.charset.Charset;

/**
 * 全局静态变量
 * 
 * @author Aolai
 *
 */

public class Const {

	/**
	 * 用以标记当前应用缓存的一些信息
	 * 
	 * token：UUID 验证码：vcode+mobile 按天计数器：yyyyMMdd
	 */

	// 字符集转换
	public static final String UTF8 = "UTF-8";
	public static final Charset CHARSET = Charset.forName(UTF8);
	/** 约定为 jsonstr字符串 */
	public static final String JSON_STR = "jsonstr";

	public static final String MON = "yyyyMM";
	public static final String DAY = "yyyyMMdd";
	public static final String SDF = "yyyy-MM-dd"; // SimpleDateFormat
	public static final String DTF = "yyyy-MM-dd HH:mm:ss"; // DateTimeFormat

	/** 授权(Auth)的 AppId应用 */
	public static final String RDS_APPID = "a."; // 授权应用或IP地址等
	/** 缓存的 Token信息 */
	public static final String RDS_TOKEN = "t."; // 缓存的 Token信息
	/** 拒绝接受(deny)的IP地址 */
	public static final String RDS_DENY = "d."; // 阻止IP访问（验证码防黑客）
	/** 登录失败(loss)次数 */
	public static final String RDS_LOSS = "l."; // 登录失败次数（防暴力破解）
	/** 元数据(meta) */
	public static final String RDS_META = "m."; // 元数据表结构（频繁调用）
	/** 用户信息(userInfo) */
	public static final String RDS_USER = "u."; // 用户
	/** 数据库(dataBase) */
	public static final String RDS_BASE = "b."; // 账套
	/** 组织(organize) */
	public static final String RDS_ORGN = "o."; // 组织
	/** 公司(company) */
	public static final String RDS_COMP = "c."; // 公司
	/** 标记(flag) */
	public static final String RDS_FLAG = "f."; // 标记=1
	/** 通行证(certKey) */
	public static final String RDS_CERT = "k."; // certKey
	/** 验证码(verification code) */
	public static final String RDS_CODE = "v."; // vcode
	/** IP地址(ipAddress) */
	public static final String RDS_ADDR = "i."; // ipAddr
	/** 角色权限控制(role) */
	public static final String RDS_ROLE = "r."; // ROLE权限

	public static final int TEN_DD = 864000; // 有效期：10天=864000秒
	public static final int TWO_DD = 172800; // 有效期：48小时=172800秒
	/** 缓存1天 */
	public static final int ONE_DD = 86400; // 有效期：24小时=86400秒
	/** 缓存10小时 */
	public static final int TEN_HH = 36000; // 有效期：10小时=3600秒
	public static final int TWO_HH = 7200; // 有效期：2小时=7200秒
	public static final int ONE_HH = 3600; // 有效期：1小时=3600秒
	public static final int TEN_MM = 600; // 有效期：10分钟=600秒
	public static final int TWO_MM = 120; // 有效期：2分钟=120秒
	public static final int ONE_MM = 60; // 有效期：1分钟=60秒
	/** 默认2分钟超时 */
	public static final int TIMEOUT = 120000; // 120秒（2分钟）
	
	/** 有效的 SQL表达式 */
	public static final String[] SQL_EXPR = { "=", ">", "<", ">=", "<=", "<>",
			"!=", "!", "REGEXP", "RLIKE", "NOT", "IS", "AND", "OR", "(",
			")", "NULL", "LIKE", "||", "&&", "BETWEEN", "IN" }; // "XOR"

}
