package cn.ps1.aolai.utils;

import java.util.ResourceBundle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 全局通用的配置参数类（config.properties）
 * 
 * @author Aolai
 * @since 1.7 $Date: 2017.6.17
 * @version 1.0
 */

public class ConfUtil {

	private static Logger LOG = LoggerFactory.getLogger(ConfUtil.class);

	/** 应用的配置文件：config.properties */
	private static ResourceBundle CONF = ResourceBundle.getBundle("config");
	/** 前台传递的参数：config.properties */
	private static ResourceBundle PARAM = ResourceBundle.getBundle("params");
	/** 需要校验的参数：config.properties */
	private static ResourceBundle VALID = ResourceBundle.getBundle("valid");
	/** 默认2分钟超时，可以通过配置文件设置 */
	private static int TIMEOUT = 0;

	/**
	 * 获取配置参数
	 */
	public static String getConf(String key) {
		try {
			if (key != null && CONF != null)
				return CONF.getString(key);
		} catch (Exception e) {
			LOG.warn("-> getConf..." + e.getMessage());
			// e.printStackTrace();
		}
		return "";
	}

	public static String getParam(String key) {
		try {
			if (key != null && PARAM != null)
				return PARAM.getString(key);
		} catch (Exception e) {
			LOG.warn("-> getParam..." + e.getMessage());
			// e.printStackTrace();
		}
		return "";
	}

	public static String getValid(String key) {
		try {
			if (key != null && VALID != null)
				return VALID.getString(key);
		} catch (Exception e) {
			LOG.warn("-> getValid..." + e.getMessage());
			// e.printStackTrace();
		}
		return "";
	}

	public static int getTimeOut() {
		if (TIMEOUT == 0) {
			try {
				String str = getConf("http.timeout");
				TIMEOUT = Integer.valueOf(str);
			} catch (Exception e) { // NumberFormatException
				TIMEOUT = Const.TIMEOUT;
				LOG.warn("-> getTimeOut..." + e.getMessage());
				// e.printStackTrace();
			}
		}
		return TIMEOUT;
	}

}
