package cn.ps1.aolai.service;

import java.io.PrintWriter;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.Digest;

import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 第三方对接（微信相关的登录认证）服务
 * 
 * @author Aolai
 * @since 2020.6.17
 * @version 1.0
 * 
 */

@Service
public class ThirdService {

	private static Logger LOG = LoggerFactory.getLogger(ThirdService.class);
	private static String AppKey = null;
	private static String Md5Key = null;

	@Autowired
	private AolaiService aolaiSvc;
	@Autowired
	private HttpService httpSvc;
	@Autowired
	private RedisService redisSvc;
	@Autowired
	private UtilsService utilsSvc;

	private boolean checkAppKey(Object k) {
		if (Md5Key == null) {
			AppKey = utilsSvc.getConf("app.key");
			Md5Key = DigestUtils.md5Hex(AppKey);
		}
		return AppKey.equals(k) || Md5Key.equals(k);
	}

	/**
	 * 支持第三方（如微信）快速授权登录
	 * 
	 * @return
	 */
	public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp,
			Map<String, String> cookies) {
		// 微信自动登录
		if (cookies.containsKey("userId") && cookies.containsKey("bindId")) {
			/*Map<String, String> map = wxLogin(req, rsp, cookies);
			if (map != null) {
				// 生成Token，返回前端并写到Cookie中
				map = utilsSvc.newToken(req, rsp, map.get("binduid"));
				redisSvc.setToken(map);
				return true;
			}*/
		}
		return false;
	}

	/**
	 * 未携带token时，需要验证携带的appid或k码
	 */
	public boolean isSecretKey(HttpServletRequest req) {
		String jsonStr = req.getParameter(Const.JSON_STR); // json对象、或加密串
		Object k = req.getParameter("k");
		if (k == null) {
			return false;
		} else if (checkAppKey(k)) { // www.ps1.cn
			// 可直接处理非jsonstr格式的参数
			if (jsonStr == null)
				return true;
			// 返回未加密的jsonstr参数（平台接口调用：www.ps1.cn）
			return setAttr(req, utilsSvc.json2Map(jsonStr), k);
		}
		// 根据certKey（如cSzrVXHKEOAywILdug）校验ticket（appId）
		String ticket = redisSvc.get(Const.RDS_CERT + k);
		if (ticket == null)
			return false; // 缓存ticket不存在

		// 根据k参数、及携带的ticket证书解密
		jsonStr = Digest.decrypt(jsonStr, ticket + k);
		Map<String, Object> map = utilsSvc.json2Map(jsonStr);

		// 第一次校验ticket='BNQTJMFP'
		if (!ticket.equals(map.get("ticket"))) // 校验携带的证书
			return false;
		
		// 第二次校验certKey
		String certKey = redisSvc.get(Const.RDS_APPID + ticket);
		if (certKey != null && k.equals(certKey))
			return setAttr(req, map, certKey); // 成功
		
		return false; // 失败
	}
	
	private boolean setAttr(HttpServletRequest req, Object obj,
			Object certStr) {
		req.setAttribute("json", obj);
		req.setAttribute("certId", certStr);
		return true;
	}

	/**
	 * 对用户授权的功能进行鉴权，如果是其他非法登录，拒绝访问
	 */
	public boolean authAccess(HttpServletRequest req, HttpServletResponse rsp,
			Map<String, String> cookies) throws Exception {
		// 如果前端对userId编码处理过，这里需要解码
		String cert = cookies.get("certId");
		String userId = Digest.decrypt(cookies.get("userId"), cert);
		// 根据用户duty权限鉴权
		
		Map<String, String> user = redisSvc.getUserInfo(userId);
		if (user == null) {
			redisSvc.clearToken(cookies);
			return invlidToken(rsp); // redis缓存失效
		}
		
		// 根据APP编码、岗位，验证（服务请求的地址）接口的访问权限：{M:"D01"}
		Map<String, Object> tmp = utilsSvc.json2Map(user.get("userDuty"));
		// 每个应用、每个账套、访问权限功能列表
		final String appKey = utilsSvc.getConf("app.code");
		if (!tmp.containsKey(appKey)) // 应用编码：A\M\D
			return invlidParams(rsp); // 鉴权失败
		
		String uri = utilsSvc.getRequestURI(req); // 如：wsTest1
		String args = utilsSvc.getValid(uri);
		
		LOG.info("-> authAccess..." + uri + tmp.toString());
		
		/** 获取请求参数，并解码处理 */
		tmp = utilsSvc.decryptParams(req, userId, cert);
		
		if (args.length() > 0 && !utilsSvc.availParams(tmp, args.split(";")))
			return invlidParams(rsp);

		// TODO: 这里可以根据需求进一步优化处理
		//map = redisSvc.hmget(Const.RDS_ROLE + map.get(app));
		// if (map == null || map.containsKey(uri)) {
		// return false;
		// }
		
		return true;
	}

	/**
	 * 验证无效的token
	 */
	private boolean invalidResult(HttpServletResponse rsp, String status) throws Exception {
		rsp.setContentType("application/json;charset=UTF-8");
		rsp.setCharacterEncoding("UTF-8");
		PrintWriter out = rsp.getWriter();
		out.write(utilsSvc.obj2Str(utilsSvc.result(status))); // "3"
		out.flush();
		out.close();
		return false;
	}
	
	/**
	 * 验证无效的token
	 */
	public boolean invlidToken(HttpServletResponse rsp) throws Exception {
		return invalidResult(rsp, "3");
	}
	
	/**
	 * 验证无效的参数
	 */
	public boolean invlidParams(HttpServletResponse rsp) throws Exception {
		return invalidResult(rsp, "2");
	}

}
