package cn.ps1.aolai.utils;

import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import cn.ps1.aolai.service.TimerService;
import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.SpringContext;

/**
 * 全局定时任务
 * 
 * @author Fulin
 */
public class TaskListener implements ServletContextListener {

	// 定时器01
	private Timer t01 = new Timer();

	// 定时服务
	private TimerService timerSvc;

	/**
	 * 正式启动定时任务（间隔10分钟一次）
	 */
	public void contextInitialized(ServletContextEvent sce) {
		int interval = Const.TEN_MM * 1000;
		t01.schedule(new Timer01Task(), 30000, interval); // 延时30秒开启
	}

	/**
	 * 定时任务t01主程序入口：同步数据
	 */
	class Timer01Task extends TimerTask {
		@Override
		public void run() { // 启动时间6:00 以后
			int hour = Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
			if (hour < 1 || hour >= Const.TASK_START) {

				// 每天定时执行的任务
				if (timerSvc == null)
					timerSvc = SpringContext.getBean(TimerService.class);
				timerSvc.taskStart(hour);

			}
		}
	}

	/**
	 * 关闭任务
	 */
	public void contextDestroyed(ServletContextEvent sce) {
		t01.cancel();
	}

}
