package cn.ps1.aolai.utils;

import java.util.Map;
import java.util.ResourceBundle;

import org.apache.log4j.Logger;

import cn.ps1.aolai.service.UtilsService;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

public class SendSms {
	
	private static Logger LOG = Logger.getLogger(SendSms.class);
	static final ResourceBundle CONF = ResourceBundle.getBundle("smsconf");
	final String template = CONF.getString("sms.templateCode");
	final String smsSign = CONF.getString("sms.Sign");

	UtilsService utilsServ;

	/**
	 * 发送短信
	 */
	public boolean sendSms(String mobile, String vcode) {
		String info = "{\"code\":\"" + vcode + "\"}";
		return sendSms(mobile, info, template);
	}
	public boolean sendSms(String mobile, String info, String tmpl) {
		return aliSms(mobile, info, tmpl);
	}
	
	public boolean sendSms(String mobile, Map<String, String> map, String tmpl) {
		/*Map<String, String> map = new HashMap<String, String>();
		map.put("code", vcode);
		return sms.sendSms(mobile, obj2Json(map));*/
		return aliSms(mobile, utilsServ.obj2Json(map), tmpl);
	}
	
	/**
	 * 通过阿里云平台发送短信
	 * @throws ClientException 
	 */
	public SendSms () {
		// 构造函数
	}
	
	// 初始化ascClient需要的几个参数
	// 短信API产品名称（短信产品名固定，无需修改）
	final String product = "Dysmsapi";
	// 短信API产品域名（接口地址固定，无需修改）
	final String domain = "dysmsapi.aliyuncs.com";
	/**
	 * 替换成你的AK，如：
	 * LTAIfviY7JjzYGZR,
	 * weBeAgEx2Pd2g8E9PRObqgGjUeVAbY
	 */
	// 你的accessKeyId,参考本文档步骤2
	final String accessKeyId = "LTAIBePgBvOsjWfi";
	// 你的accessKeySecret，参考本文档步骤2
	final String accessKeySecret = "AFT1lR0HCvjHTvnJciqTosSwv3IB2j";
	
	private boolean aliSms(String mobile, String info, String tmpl) {
		// 设置超时时间-可自行调整
		System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
		System.setProperty("sun.net.client.defaultReadTimeout", "10000");
		// 初始化ascClient，暂时不支持多region（请勿修改）
		IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou",
				accessKeyId, accessKeySecret);
		try {
			DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product,
					domain);
			IAcsClient acsClient = new DefaultAcsClient(profile);
			// 组装请求对象
			SendSmsRequest request = new SendSmsRequest();
			// 使用post提交
			request.setMethod(MethodType.POST);
			// 必填:待发送手机号。支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码；
			// 批量调用相对于单条调用及时性稍有延迟，验证码类型的短信推荐使用单条调用的方式；
			// 发送国际/港澳台消息时，接收号码格式为00+国际区号+号码，如“0085200000000”
			request.setPhoneNumbers(mobile);
			// 必填:短信签名-可在短信控制台中找到
			request.setSignName(smsSign);
			// 必填:短信模板-可在短信控制台中找到
			request.setTemplateCode(tmpl);
			// 可选:模板中的变量替换JSON串，如模板内容为"亲爱的${name}，您的验证码为${code}"时，
			// 此处的值为
			// 友情提示:如果JSON中需要带换行符，请参照标准的JSON协议对换行符的要求，
			// 比如短信内容中包含\r\n的情况在JSON中需要表示成\\r\\n，否则会导致JSON在服务端解析失败
			// 官方的暂时注释
			request.setTemplateParam(info);

			// 可选-上行短信扩展码(扩展码字段控制在7位或以下，无特殊需求用户请忽略此字段)
			// request.setSmsUpExtendCode("90997");
			// 可选:outId为提供给业务方扩展字段，最终在短信回执消息中将此值带回给调用者
			request.setOutId("yourOutId");
			// 请求失败这里会抛ClientException异常
			SendSmsResponse response = acsClient.getAcsResponse(request);
			LOG.info("-> 阿里云短信状态：" + response.getCode());
			
			String status = response.getCode();
			if (status != null && "OK".equals(status))
				return true;
		} catch (ClientException e) { 
			LOG.error("-> aliSms..." + e.toString());
		}
		return false;
	}
	
}
