package cn.ps1.aolai.utils;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import cn.ps1.aolai.service.RedisService;
import cn.ps1.aolai.service.ThirdService;
import cn.ps1.aolai.service.UtilsService;

/**
 * 通用controller接口拦截器
 * 
 * @author Fulin
 * @version 1.0
 *
 */
@Component
public class Interceptor implements HandlerInterceptor {

	/* 日志Logger实例 */
	private static Logger LOG = Logger.getLogger(Interceptor.class);

	@Autowired
	private RedisService redisSvc;
	@Autowired
	private UtilsService utilsSvc;
	@Autowired
	private ThirdService thirdSvc;

	/**
	 * 所有web请求，经过拦截器统一处理
	 */
	@Override
	public boolean preHandle(HttpServletRequest req, HttpServletResponse rsp,
			Object handler) throws Exception {
		// 首先要进行token验证，验证无效后终止响应
		Map<String, String> cookies = utilsSvc.getCookies(req);
		if (!redisSvc.checkToken(cookies)
				|| !thirdSvc.thirdLogin(req, rsp, cookies)) {

			// 开放接口无token，需要验证携带appid或k参数需特殊处理
			if (thirdSvc.isSecretKey(req))
				return true;

			return thirdSvc.invalidToken(rsp); // 无效token

		} else if (!authAccess(req, cookies)) {
			// 后台鉴权控制
			rsp.setStatus(403);
			return false;
		}
		return true;
	}

	/**
	 * 对用户授权的功能进行鉴权，如果是其他非法登录，拒绝访问
	 */
	public boolean authAccess(HttpServletRequest req,
			Map<String, String> cookies) {
		String userid = cookies.get("userid");
		String certid = cookies.get("certid");

		// 如果前端对userid编码处理过，这里需要解码
		userid = Digest.decrypt(userid, Digest.certStr(certid));

		// 根据用户duty权限鉴权
		Map<String, String> map = redisSvc.hmget(Const.RDS_USER + userid);
		map = utilsSvc.json2Map(map.get("userduty")); // {M:"D01"}

		// 本应用的APP编码
		final String appKey = utilsSvc.getConf("app.code"); // 应用编码：A\M\D

		// 根据APP编码及岗位，验证（服务请求的地址）接口的访问权限
		if (map.containsKey(appKey)) {
			// TODO: 这里可以根据需求进一步优化处理
			// String uri = getRequestURI(req); // 如：/ws/test1
			// map = redisSvc.hmget(app + map.get(app)); // 访问功能列表
			// if (map == null || map.containsKey(uri)) {
			// return false;
			// }
			// 传递参数
			req.setAttribute("userid", userid);
			req.setAttribute("certid", certid);
			return true;
		}
		return false;
	}

	/**
	 * 获取请求参数
	 */
	public String getRequestURI(HttpServletRequest req) {
		LOG.debug("-> HttpRequest..." + req.getHeader("Referer"));

		// String path = req.getContextPath(); // path=“/xxxx”
		String uri = req.getRequestURI(); // uri=“/xxxx/ws/test1”
		LOG.debug("-> HttpRequest..." + uri);

		// uri = uri.substring(path.length()); // uri=“/ws/test1”
		uri = uri.substring(uri.lastIndexOf('/') + 1); // uri=“test1”

		return uri;
	}

	@Override
	public void postHandle(HttpServletRequest req, HttpServletResponse rsp,
			Object handler, ModelAndView modelAndView) throws Exception {
	}

	@Override
	public void afterCompletion(HttpServletRequest req,
			HttpServletResponse rsp, Object handler, Exception ex)
			throws Exception {
	}

}
