package cn.ps1.aolai.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 每天定时执行的任务
 */
@Service
public class TimerService {

	final static String table = "Y_TASK";
	final static String base = "badan";

	static Logger LOG = Logger.getLogger(TimerService.class);
	static int step = 2000;

	private boolean isReady = true;
	private boolean running = false;

	@Autowired
	AolaiService aolaiSvc;
	@Autowired
	UtilsService utilsSvc;

	/**
	 * 定时执行的任务
	 */
	public void taskStart(int hour) {
		// 每天22点执行任务
		int in = 22;
		if (hour != in) {
			isReady = true;
		} else if (hour == in && isReady) {
			taskProcess();
		}
	}

	/**
	 * 随时执行的任务
	 */
	public void taskStart() {
		if (!running) {
			taskProcess();
			running = false;
		}
	}

	/**
	 * 状态为“2”的任务
	 */
	public void taskProcess() {
		// TODO：
		System.out.println("-> finsh...\n");
	}

}
