package cn.ps1.aolai.service;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.Digest;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 第三方对接（微信相关的登录认证）服务
 * 
 * @author Aolai
 * @since 2020.6.17
 * @version 1.0
 * 
 */

@Service
public class ThirdService {

	final static String[] table = { "BIND", "OPEN" };

	static Logger LOG = Logger.getLogger(ThirdService.class);

	static String AppKey = null;
	static String Md5Key = null;
	
	// 微信端accessToken 标志（阳光村务）
	static String accToken = "ygcwAcc";

	@Autowired
	private AolaiService aolaiSvc;
	@Autowired
	private HttpService httpSvc;
	@Autowired
	private RedisService redisSvc;
	@Autowired
	private UtilsService utilsSvc;

	private boolean checkKey(String k) {
		if (Md5Key == null) {
			AppKey = utilsSvc.getConf("app.key");
			Md5Key = DigestUtils.md5Hex(AppKey);
		}
		return k.equals(AppKey) || k.equals(Md5Key);
	}

	/**
	 * 支持第三方（如微信）快速授权登录
	 * 
	 * @return
	 */
	public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp,
			Map<String, String> cookies) {
		// 微信自动登录
		if (cookies.containsKey("userid") && cookies.containsKey("bindid")) {
			/*Map<String, String> map = wxLogin(req, rsp, cookies);
			if (map != null) {
				// 生成Token，返回前端并写到Cookie中
				map = utilsSvc.newToken(req, rsp, map.get("binduid"));
				redisSvc.setToken(map);
				return true;
			}*/
		}
		return false;
	}

	/**
	 * 校验密钥k码
	 */
	public boolean isSecretKey(HttpServletRequest req) {
		String k = req.getParameter("k");
		if (k != null) {
			if (checkKey(k)){
				// 本平台的接口调用
				String jsonStr =req.getParameter("jsonstr");
				if (jsonStr == null)
					return false;
				// 先解码
				Map<String, String> map = utilsSvc.json2Map(jsonStr);
				// 二次校验
				if (map.isEmpty())
					return false;

				req.setAttribute("json",map );

				return true;
			}

			// 第三方应用跨平台的接口调用，根据certKey获取ticket（或appid）
			String ticket = redisSvc.get(Const.RDS_CERT + k);
			// 校验ticket是否有效
			if (ticket != null) {
				String jsonStr = req.getParameter("content");
				if (jsonStr == null)
					return false;
				// 先解码
				jsonStr = Digest.decrypt(jsonStr, ticket + k);
				Map<String, String> map = utilsSvc.json2Map(jsonStr);
				// 二次校验
				if (map.isEmpty() || !ticket.equals(map.get("ticket")))
					return false;
				// 三次校验
				String certKey = redisSvc.get(Const.RDS_APPID + ticket);
				if (certKey != null && k.equals(certKey)) {
					req.setAttribute("json", map);
					req.setAttribute("cert", ticket + k);
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 验证无效的token
	 */
	public boolean invalidToken(HttpServletResponse rsp) throws Exception {
		rsp.setCharacterEncoding("UTF-8");
		rsp.setContentType("application/json;charset=UTF-8");
		PrintWriter out = rsp.getWriter();
		out.write(utilsSvc.obj2Json(utilsSvc.result("3")));
		out.flush();
		out.close();
		return false;
	}

	/**
	 * 手机与微信公众号绑定（或解绑）
	 */
	/*public Object wxBind(HttpServletRequest req, HttpServletResponse rsp) {
		Map<String, String> parms = utilsSvc.certParms(req);
		LOG.debug("-> wxBind...");
		String[] keys = { "bindid" };
		if (!utilsSvc.availParms(parms, keys))
			return utilsSvc.result("2");
		// 绑定的用户
		parms.put("binduid", String.valueOf(req.getAttribute("userid")));
		if (!parms.containsKey("bindstate"))
			parms.put("bindstate", "1");

		// if ("1".equals(parms.get("status"))) {
		// utilsSvc.setCookies(req, rsp, parms);
		// } else {
		// utilsSvc.clearCookies(req, rsp);
		// }

		// 绑定后返回成功与否
		return aolaiSvc.addRecord(table[0], parms, true);
	}*/

	/**
	 * 微信自动登录，传入参数：code、openid（只有1个有值）
	 */
	/*public Object wxLogin(HttpServletRequest req, HttpServletResponse rsp) {
		LOG.debug("-> wxLogin...");

		Map<String, String> parms = utilsSvc.jsonParms(req);
		// bindid为空，从前台cookie中获取bindid
		if (!parms.containsKey("bindid")) {
			// 获取绑定userid
			String openid = utilsSvc.getCookie(req, "bindid");
			if (openid == null)
				return utilsSvc.result("2");

			// parms = getOpenid(parms);
			// if (!parms.containsKey("bindid"))
			// return utilsSvc.result("2");

			parms.put("bindid", openid);
		}
		// 只能登陆绑定的用户
		parms.put("bindstate", "1");
		parms = wxLogin(req, rsp, parms);
		if (parms == null) {
			return utilsSvc.result(false);
		}
		return utilsSvc.success(parms);
	}*/

	/**
	 * 只能登陆绑定的用户
	 */
	/*public Map<String, String> wxLogin(HttpServletRequest req,
			HttpServletResponse rsp, Map<String, String> parms) {

		// 根据bindid获取绑定的用户
		String app = parms.get("app");
		String wxapp = parms.get("wxapp");
		String code = parms.get("code");
		parms.put("bindstate", "1");
		parms = aolaiSvc.findOne(table[0], parms, "binduid");
		if (parms.containsKey("status"))
			return null;

		parms.put("app", app);
		parms.put("wxapp", wxapp);
		parms.put("code", code);
		// getOpenIdByWechat(parms);
		// 返回
		return parms;
	}*/

	/**
	 * 获取微信的Openid
	 */
	/*public Object wxOpenid(HttpServletRequest req) {
		Map<String, String> parms = utilsSvc.jsonParms(req);
		LOG.info("-> Call wxOpenid...");
		String[] keys = { "code", "wxapp" };
		if (!utilsSvc.availParms(parms, keys))
			return utilsSvc.result("2");
		// ygxcGzh：阳光乡村公众号，ygxcXcx：阳光乡村小程序
		String type = parms.get("wxapp");
		if (type != null) {
			// 公众号类型
			if (type.endsWith("Gzh")) {
				return utilsSvc.success(getOpenid(parms));
			} else if (type.endsWith("xcx")) { // 小程序类型
				return utilsSvc.success(getUnionid(parms));
			}
		}
		return utilsSvc.result("2");
	}*/

	/**
	 * 获取公众号openid 051TcP0w3pgjjV2WYw3w3NVxa61TcP0m
	 */
	/*private Map<String, Object> getOpenid(Map<String, String> parms) {
		Map<String, String> map = new HashMap<>();
		Map<String, Object> tmp = new HashMap<>();

		String url, tag = parms.get("wxapp");
		Map<String, String> conf = aolaiSvc.getConf(null, tag);
		map.put("appid", conf.get(tag + ".appid")); // 微信程序唯一标识
		map.put("secret", conf.get(tag + ".secret")); // 密钥

		// 获取微信公众号证AccessToken
		map.put("grant_type", "client_credential");
		url = conf.get("wx.tokenUrl");
		tmp = utilsSvc.json2Map(httpSvc.urlConnect(url, map));
		String token = String.valueOf(tmp.get("access_token"));
		redisSvc.set(accToken, token, Const.ONE_HH);
		// 调用公众号接口，请求openid
		map.put("code", parms.get("code"));
		map.put("grant_type", "authorization_code");
		url = conf.get("wx.oauthUrl");
		tmp = utilsSvc.json2Map(httpSvc.urlConnect(url, map));
		String openid = String.valueOf(tmp.get("openid"));

		// 获取union用户信息
		map.clear();
		map.put("access_token", token);
		map.put("openid", openid);
		map.put("lang", "zh_CN");
		url = conf.get("wx.unionUrl");
		tmp = utilsSvc.json2Map(httpSvc.urlConnect(url, map));

		// APP未绑定公众平台时，返回openid
		if (!tmp.containsKey("unionid"))
			tmp.put("unionid", tmp.get("openid"));

		//
		Map<String, String> bindMap = new HashMap<>();
		bindMap.put("bindid", tmp.get("unionid") + "");
		bindMap.put("bindstate", "1");
		Map<String, String> addMap = aolaiSvc.findOne(table[0], bindMap,
				"binduid");
		LOG.info("获取绑定关系" + addMap);
		try {
			if (addMap.get("binduid") != null
					&& !"".equals(addMap.get("binduid"))) {
				addMap.put("wxapp", parms.get("wxapp"));
				addMap.put("openid", openid);
				aolaiSvc.addRecord(table[1], addMap, true);
			}
		} catch (Exception e) {
			LOG.error("绑定微信出现异常", e);
		}

		LOG.info("-> getOpenid..." + tmp);
		return tmp;
	}*/

	private Map<String, Object> getUnionid(Map<String, String> parms) {
		Map<String, String> map = new HashMap<>();
		Map<String, Object> tmp = new HashMap<>();

		String url, tag = parms.get("wxapp");
		final Map<String, String> conf = aolaiSvc.getConf(null, tag);

		map.put("appid", conf.get(tag + ".appid")); // 微信程序唯一标识
		map.put("secret", conf.get(tag + ".secret")); // 密钥

		// 获取微信公众号AccessToken
		map.put("code", parms.get("code"));
		map.put("grant_type", "authorization_code");
		url = conf.get("wx.dataUrl");
		tmp = utilsSvc.json2Map(httpSvc.urlConnect(url, map));
		String data = parms.get("data");
		String iv = parms.get("iv");

		// 对小程序encryptedData进行解密
		String key = String.valueOf(tmp.get("session_key"));
		tmp = decryptData(data, key, iv);

		// APP未绑定公众平台时，返回openid
		if (!tmp.containsKey("unionid"))
			tmp.put("unionid", tmp.get("openid"));

		LOG.info("-> getUnionid..." + tmp);
		return tmp;
	}

	/**
	 * 小程序解密用户信息
	 */
	private Map<String, Object> decryptData(String data, String key, String iv) {
		LOG.info("-> decryptData..." + data + ", key=" + key + ", iv=" + iv);

		// 被加密的数据
		byte[] dataByte = Digest.decrypt(data.toCharArray());
		// 加密秘钥
		byte[] keyByte = Digest.decrypt(key.toCharArray());
		// 偏移量
		byte[] ivByte = Digest.decrypt(iv.toCharArray());

		// 如果密钥不足16位，那么就补足. 这个if 中的内容很重要
		int bit = 16, len = keyByte.length;
		if (len % bit != 0) {
			byte[] tmp = new byte[(len / bit + 1) * bit];
			Arrays.fill(tmp, (byte) 0);
			System.arraycopy(keyByte, 0, tmp, 0, len);
			keyByte = tmp;
		}
		// 初始化
		String str = AES_Decrypt(dataByte, keyByte, ivByte);
		return utilsSvc.json2Map(str);
	}

	/**
	 * AES解密：密文 密钥 偏移量
	 */
	public static String AES_Decrypt(byte[] dataByte, byte[] keyByte,
			byte[] ivByte) {
		try {
			Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
			SecretKeySpec sks = new SecretKeySpec(keyByte, "AES");
			// 使用CBC模式，需要一个向量iv，可增加加密算法的强度
			IvParameterSpec iv = new IvParameterSpec(ivByte);
			cipher.init(Cipher.DECRYPT_MODE, sks, iv);
			// 解密
			dataByte = cipher.doFinal(dataByte);
			return new String(dataByte, "utf-8");
		} catch (Exception e) {
			LOG.info("-> AES_Decrypt" + e.getMessage());
			return null;
		}
	}

	/*
	 * 获取微信端openid 传入 code appid userid
	 */
	/*public void getOpenIdByWechat(Map<String, String> params) {
		try {
			Map<String, String> sMap = aolaiSvc.findOne(table[1], params,
					"binduid");
			if (sMap.isEmpty() || sMap.get("binduid") == null) {
				// TODO insert
				Map<String, String> map = new HashMap<>();
				String url, tag = params.get("wxapp") + "";
				Map<String, String> conf = aolaiSvc.getConf(null, tag);
				map.put("appid", conf.get(tag + ".appid")); // 微信程序唯一标识
				map.put("secret", conf.get(tag + ".secret")); // 密钥
				map.put("grant_type", "authorization_code");
				map.put("code", params.get("code"));
				// 获取微信公众号证AccessToken
				url = conf.get("wx.oauthUrl");
				Map<String, Object> tmp = utilsSvc.json2Map(httpSvc.urlConnect(
						url, map));
				// 绑定后返回成功与否
				if (null != tmp.get("openid")) {
					aolaiSvc.addRecord(table[0], params, true);
				}
			}
		} catch (Exception e) {
			LOG.error("绑定微信出现异常", e);
		}
	}*/
}
