package cn.ps1.aolai.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * Aolai基础框架相关业务
 * 
 * @author Aolai
 * @version 1.0 $Date: 2019/7/6
 * @since 1.7
 */
@Repository
public interface AolaiDao {

	/**
	 * 创建表（不推荐）
	 * @param map
	 */
	public void create(Map<String, String> map);

	/**
	 * 删除表（不推荐）
	 * @param map 描述
	 */
	public void drop(Map<String, String> map);

	/**
	 * 修改表（不推荐）
	 * @param map
	 */
	public void modify(Map<String, String> map);

	/**
	 * 组合条件检索表中的数据（不推荐）
	 * 
	 * @param sql
	 * @return
	 */
	public List<Map<String, String>> query(@Param("sql") String sql);

	/**
	 * 往表中插入一条数据
	 * 
	 * @param map
	 * @param data
	 * @return
	 */
	public int addOne(@Param("map") Map<String, String> map,
			@Param("data") Map<String, Object> data);

	/**
	 * 批量往表中插入数据
	 * 
	 * @param map
	 * @param data
	 * @param list
	 * @return
	 */
	public int batchAdd(@Param("map") Map<String, String> map,
			@Param("data") Map<String, Object> data,
			@Param("list") List<Map<String, Object>> list);

	/**
	 * 查出表中的一条记录，限定了只返回一条记录
	 * 
	 * @param map
	 * @param cond
	 * @return
	 */
	public Map<String, String> findOne(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 批量查出表中的数据
	 * 
	 * @param map
	 * @param cond
	 * @return
	 */
	public List<Map<String, String>> findList(
			@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 更新表中的数据
	 */
	public int update(@Param("map") Map<String, String> map,
			@Param("values") Map<String, Object> values,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 删除表中的数据
	 * 
	 * @param map
	 * @param cond
	 * @return
	 */
	public int delete(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 判断表中是否有数据
	 * 
	 * @param map
	 * @param cond
	 * @return
	 */
	public int exists(@Param("map") Map<String, String> map,
			@Param("cond") Map<String, Object> cond);

	/**
	 * 获取用户的菜单操作角色权限
	 * @param map
	 * @return
	 */
	public List<Map<String, String>> getMenuRole(Map<String, String> map);

	/**
	 * 获取页面的功能操作权限
	 * @param map
	 * @return
	 */
	public List<Map<String, String>> getActionRole(Map<String, String> map);

}
