package cn.ps1.aolai.service;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.Digest;

import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 第三方对接（微信相关的登录认证）服务
 * 
 * @author Aolai
 * @since 2020.6.17
 * @version 1.0
 * 
 */

@Service
public class ThirdService {

	private static Logger LOG = LoggerFactory.getLogger(ThirdService.class);
	private static String AppKey = null;
	private static String Md5Key = null;

	@Autowired
	private AolaiService aolaiSvc;
	@Autowired
	private HttpService httpSvc;
	@Autowired
	private RedisService redisSvc;
	@Autowired
	private UtilsService utilsSvc;

	private boolean checkAppKey(Object k) {
		if (Md5Key == null) {
			AppKey = utilsSvc.getConf("app.key");
			Md5Key = DigestUtils.md5Hex(AppKey);
		}
		return AppKey.equals(k) || Md5Key.equals(k);
	}

	/**
	 * 支持第三方（如微信）快速授权登录
	 * 
	 * @return
	 */
	public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp,
			Map<String, String> cookies) {
		// 微信自动登录
		if (cookies.containsKey("userId") && cookies.containsKey("bindId")) {
			/*Map<String, String> map = wxLogin(req, rsp, cookies);
			if (map != null) {
				// 生成Token，返回前端并写到Cookie中
				map = utilsSvc.newToken(req, rsp, map.get("binduid"));
				redisSvc.setToken(map);
				return true;
			}*/
		}
		return true;
	}

	/**
	 * 未携带token时，需要验证携带的appid或k码
	 */
	public boolean isSecretKey(HttpServletRequest req) {
		Map<String, Object> map = new HashMap<>();
		String jsonStr = req.getParameter(Const.JSON_STR); // json对象或加密串
		Object k = req.getParameter("k");
		if (checkAppKey(k)) { // www.ps1.cn
			if (jsonStr == null) // 如果不是jsonstr格式，可直接处理
				return true;
			// 本平台的接口调用，如：www.ps1.cn
			return setAttr(req, utilsSvc.json2Map(jsonStr), k);
		}
		if (k == null) { // 校验json对象中携带的k参数
			map = utilsSvc.json2Map(jsonStr);
			k = map.get("k");
			if (checkAppKey(k)) // 如果携带了k参数为www.ps1.cn
				return setAttr(req, map, k);
			// 进一步校验json对象中携带的k参数，
			if (k == null || redisSvc.get(Const.RDS_CERT + k) == null)
				return false;
			return setAttr(req, map, k);
		}
		// 多数情况携带了k参数，并根据certKey（如cSzrVXHKEOAywILdug）校验ticket（appId）
		String ticket = redisSvc.get(Const.RDS_CERT + k);
		if (ticket == null)
			return false; // ticket不存在
		String cert = ticket + k;
		jsonStr = Digest.decrypt(jsonStr, cert);
		map = utilsSvc.json2Map(jsonStr);
		
		// 第一次校验ticket='BNQTJMFP'
		if (!ticket.equals(map.get("ticket")))
			return false;
		// 第二次校验certKey
		String certKey = redisSvc.get(Const.RDS_APPID + ticket);
		if (certKey != null && k.equals(certKey))
			return setAttr(req, map, certKey);
		return false;
	}
	
	private boolean setAttr(HttpServletRequest req, Object obj,
			Object certStr) {
		req.setAttribute("json", obj);
		req.setAttribute("certId", certStr);
		return true;
	}

	/**
	 * 对用户授权的功能进行鉴权，如果是其他非法登录，拒绝访问
	 */
	public boolean authAccess(HttpServletRequest req, HttpServletResponse rsp,
			Map<String, String> cookies) throws Exception {
		// 如果前端对userId编码处理过，这里需要解码
		String cert = cookies.get("certId");
		String userId = Digest.decrypt(cookies.get("userId"), cert);
		// 根据用户duty权限鉴权
		Map<String, String> map = redisSvc.hmget(Const.RDS_USER + userId);
		if (map == null || !map.containsKey("userDuty"))
			return false;
		// 每个应用、每个账套、访问权限功能列表
		final String appKey = utilsSvc.getConf("app.code"); // 应用编码：A\M\D
		// 根据APP编码、岗位，验证（服务请求的地址）接口的访问权限
		Map<String, Object> tmp = utilsSvc.json2Map(map.get("userDuty")); // {M:"D01"}
		if (tmp == null || !tmp.containsKey(appKey)) 
			return false;
		
		String uri = utilsSvc.getRequestURI(req); // 如：wsTest1
		String args = utilsSvc.getValid(uri);
		LOG.info("-> authAccess..." + uri + tmp.toString());
		
		/** 解码处理 */
		tmp = utilsSvc.decryptParams(req, userId, cert);
		
		if (args.length() > 0 && !utilsSvc.availParams(tmp, args.split(";")))
			return invalidResult(rsp, "2");

		// TODO: 这里可以根据需求进一步优化处理
		//map = redisSvc.hmget(Const.RDS_ROLE + map.get(app));
		// if (map == null || map.containsKey(uri)) {
		// return false;
		// }
		
		return true;
	}

	/**
	 * 验证无效的token
	 */
	public boolean invalidResult(HttpServletResponse rsp, String status) throws Exception {
		rsp.setContentType("application/json;charset=UTF-8");
		rsp.setCharacterEncoding("UTF-8");
		PrintWriter out = rsp.getWriter();
		out.write(utilsSvc.obj2Str(utilsSvc.result(status))); // "3"
		out.flush();
		out.close();
		return false;
	}

}
