package cn.ps1.aolai.utils;

import java.nio.charset.Charset;

/**
 * 全局静态变量
 * 
 * @author Aolai
 *
 */

public class Const {

	/**
	 * 用以标记当前应用缓存的一些信息
	 * 
	 * token：UUID 验证码：vcode+mobile 按天计数器：yyyyMMdd
	 */

	// 字符集转换
	public static final String UTF8 = "UTF-8";
	public static final Charset CHARSET = Charset.forName(UTF8);
	public static final String JSON_STR = "jsonstr";

	public static final String MON = "yyyyMM";
	public static final String DAY = "yyyyMMdd";
	public static final String SDF = "yyyy-MM-dd"; // SimpleDateFormat
	public static final String DTF = "yyyy-MM-dd HH:mm:ss"; // DateTimeFormat

	public static final String RDS_APPID = "a."; // 授权应用或IP地址等
	public static final String RDS_TOKEN = "t."; // 缓存Token信息

	public static final String RDS_DENY = "d."; // 阻止IP访问（验证码防黑客）
	public static final String RDS_LOSS = "l."; // 登录失败次数（防暴力破解）
	public static final String RDS_META = "m."; // 元数据表结构（频繁调用）
	public static final String RDS_USER = "u."; // 用户
	public static final String RDS_BASE = "b."; // 账套
	public static final String RDS_ORGN = "o."; // 组织
	public static final String RDS_COMP = "c."; // 公司
	public static final String RDS_FLAG = "f."; // 标志=1
	public static final String RDS_CERT = "k."; // certKey
	public static final String RDS_CODE = "v."; // vcode

	public static final int TEN_DD = 864000; // 有效期：10天=864000秒
	public static final int TWO_DD = 172800; // 有效期：48小时=172800秒
	public static final int ONE_DD = 86400; // 有效期：24小时=86400秒
	public static final int TEN_HH = 36000; // 有效期：10小时=3600秒
	public static final int TWO_HH = 7200; // 有效期：2小时=7200秒
	public static final int ONE_HH = 3600; // 有效期：1小时=3600秒
	public static final int TEN_MM = 600; // 有效期：10分钟=600秒
	public static final int TWO_MM = 120; // 有效期：2分钟=120秒
	public static final int ONE_MM = 60; // 有效期：1分钟=60秒

	public static final int TIMEOUT = 120000; // 120秒（2分钟）

}
