package cn.ps1.aolai.service;

import java.io.PrintWriter;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.Digest;

import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 第三方对接（微信相关的登录认证）服务
 * 
 * @author Aolai
 * @since 2020.6.17
 * @version 1.0
 * 
 */

@Service
public class ThirdService {

	static Logger LOG = LoggerFactory.getLogger(ThirdService.class);

	static String AppKey = null;
	static String Md5Key = null;

	@Autowired
	private AolaiService aolaiSvc;
	@Autowired
	private HttpService httpSvc;
	@Autowired
	private RedisService redisSvc;
	@Autowired
	private UtilsService utilsSvc;

	private boolean checkKey(String k) {
		if (Md5Key == null) {
			AppKey = utilsSvc.getConf("app.key");
			Md5Key = DigestUtils.md5Hex(AppKey);
		}
		return k.equals(AppKey) || k.equals(Md5Key);
	}

	/**
	 * 支持第三方（如微信）快速授权登录
	 * 
	 * @return
	 */
	public boolean thirdLogin(HttpServletRequest req, HttpServletResponse rsp,
			Map<String, String> cookies) {
		// 微信自动登录
		if (cookies.containsKey("userid") && cookies.containsKey("bindid")) {
			/*Map<String, String> map = wxLogin(req, rsp, cookies);
			if (map != null) {
				// 生成Token，返回前端并写到Cookie中
				map = utilsSvc.newToken(req, rsp, map.get("binduid"));
				redisSvc.setToken(map);
				return true;
			}*/
		}
		return false;
	}

	/**
	 * 对用户授权的功能进行鉴权，如果是其他非法登录，拒绝访问
	 */
	public boolean authAccess(HttpServletRequest req,
			Map<String, String> cookies) {
		String userid = cookies.get("userid");
		String certid = cookies.get("certid");

		// 如果前端对userid编码处理过，这里需要解码
		userid = Digest.decrypt(userid, Digest.certStr(certid));

		// 根据用户duty权限鉴权
		Map<String, String> map = redisSvc.hmget(Const.RDS_USER + userid);
		map = utilsSvc.json2Map(map.get("userduty")); // {M:"D01"}

		// 本应用的APP编码
		final String appKey = utilsSvc.getConf("app.code"); // 应用编码：A\M\D

		// 根据APP编码及岗位，验证（服务请求的地址）接口的访问权限
		if (map.containsKey(appKey)) {
			// TODO: 这里可以根据需求进一步优化处理
			// String uri = getRequestURI(req); // 如：/ws/test1
			// map = redisSvc.hmget(app + map.get(app)); // 访问功能列表
			// if (map == null || map.containsKey(uri)) {
			// return false;
			// }
			// 传递参数
			req.setAttribute("userid", userid);
			req.setAttribute("certid", certid);
			return true;
		}
		return false;
	}

	/**
	 * 校验密钥k码
	 */
	public boolean isSecretKey(HttpServletRequest req) {
		String k = req.getParameter("k");
		if (k != null) {
			if (checkKey(k)) // 本平台的接口调用
				return true;

			// 第三方应用跨平台的接口调用，根据certKey获取ticket（或appid）
			String ticket = redisSvc.get(Const.RDS_CERT + k);
			// 校验ticket是否有效
			if (ticket != null) {
				String jsonStr = req.getParameter(Const.JSON_STR);
				if (jsonStr == null)
					return false;
				// 先解码
				jsonStr = Digest.decrypt(jsonStr, ticket + k);
				Map<String, String> map = utilsSvc.json2Map(jsonStr);
				// 二次校验
				if (map.isEmpty() || !ticket.equals(map.get("ticket")))
					return false;
				// 三次校验
				String certKey = redisSvc.get(Const.RDS_APPID + ticket);
				if (certKey != null && k.equals(certKey)) {
					req.setAttribute("json", map);
					req.setAttribute("cert", ticket + k);
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 验证无效的token
	 */
	public boolean invalidToken(HttpServletResponse rsp) throws Exception {
		rsp.setCharacterEncoding("UTF-8");
		rsp.setContentType("application/json;charset=UTF-8");
		PrintWriter out = rsp.getWriter();
		out.write(utilsSvc.obj2Json(utilsSvc.result("3")));
		out.flush();
		out.close();
		return false;
	}

}
