package cn.ps1.aolai.service;

import java.util.ResourceBundle;

import org.springframework.stereotype.Service;

/**
 * 全局通用的配置参数类（config.properties）
 * 
 * @author Aolai
 * @since 2017年6月17日
 * @verdion 1.0
 */

@Service
public class ConfService {

	final static ResourceBundle CONF = ResourceBundle.getBundle("config");
	final static ResourceBundle PARAM = ResourceBundle.getBundle("params");
	private static int TIMEOUT = 0;

	/**
	 * 获取配置参数
	 */
	public String getConf(String key) {
		try {
			return key == null ? "" : CONF.getString(key);
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getParam(String key) {
		try {
			return key == null ? "" : PARAM.getString(key);
		} catch (Exception e) {
			return "";
		}
	}
	
	public int timeOut() {
		if (TIMEOUT == 0)
			TIMEOUT = Integer.valueOf(getConf("http.timeout"));
		return TIMEOUT;
	}
	
}
