/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.utils;

import cn.ps1.xcell.utils.StyleUtil;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class XlsxFont {
    boolean bold = false;
    boolean italic = false;
    byte underline = 0;
    boolean strikeout = false;
    String fontName = "\u7b49\u7ebf";
    short[] fontARGB;
    short fontSize = (short)13;
    short height = 0;
    int charset = 0;

    public XlsxFont(XSSFFont font) {
        this.initXlsxFont(font);
    }

    private void initXlsxFont(XSSFFont font) {
        this.bold = font.getBold();
        this.italic = font.getItalic();
        this.underline = font.getUnderline();
        this.strikeout = font.getStrikeout();
        this.fontName = font.getFontName();
        this.fontARGB = StyleUtil.getARGB(font.getXSSFColor());
        this.fontSize = font.getFontHeightInPoints();
        this.height = font.getFontHeight();
        this.charset = font.getCharSet();
    }

    public int getStyle() {
        int style = 0;
        if (this.bold) {
            style = 1;
        }
        if (this.italic) {
            style |= 2;
        }
        if (this.underline > 0) {
            style |= 4;
        }
        if (this.strikeout) {
            style |= 8;
        }
        return style;
    }

    public String getName() {
        return this.fontName;
    }

    public short[] getFontARGB() {
        return this.fontARGB;
    }

    public short getFontSize() {
        return this.fontSize;
    }
}

