/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.utils;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.XlsxUtil;
import cn.ps1.xcell.utils.HeaderFooter;
import cn.ps1.xcell.utils.ParseUtil;
import cn.ps1.xcell.utils.StyleUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XcellUtil {
    private static Logger LOG = LoggerFactory.getLogger(XcellUtil.class);
    private static final float CARDINAL = 2.83527f;
    private static final float ROW_HEIGHT = 13.8f;
    private int pageRows = 30;
    private int rowScope = 1;
    protected float marginLeft = 0.0f;
    protected float marginRight = 0.0f;
    protected float marginTop = 0.0f;
    protected float marginBottom = 0.0f;
    private boolean rotating = false;
    private boolean filling = true;
    private boolean padding = true;
    private boolean pageNumber = false;
    private float pageWidth = 210.0f;
    private float pageHeight = 297.0f;
    private int pageSplit = 1;
    private int pageHeader = 1;
    private Map<String, Object> headMap;
    private List<Map<String, String>> record;
    private Map<String, List<Map<String, String>>> recordMap;
    private List<Map<String, List<Map<String, String>>>> recordMapList;
    private XlsxUtil xlsxUtil;
    private ParseUtil parseUtil;
    private String templFile;

    public XcellUtil(String file) {
        this.init(file, null, null);
    }

    public XcellUtil(String file, Map<String, Object> head) {
        this.init(file, head, null);
    }

    public XcellUtil(String file, Map<String, Object> head, List<Map<String, List<Map<String, String>>>> recordMapList) {
        this.init(file, head, recordMapList);
    }

    private void init(String templFile, Map<String, Object> head, List<Map<String, List<Map<String, String>>>> recordMapList) {
        this.templFile = templFile;
        this.headMap = head;
        this.recordMapList = recordMapList;
        this.xlsxUtil = new XlsxUtil(templFile);
        this.parseUtil = new ParseUtil();
    }

    public void fillExcelSheet() {
        for (int i = 0; i < this.recordMapList.size(); ++i) {
            Map<String, List<Map<String, String>>> recordMap = this.recordMapList.get(i);
            this.recordMap = recordMap;
            if (this.recordMap.containsKey("rows")) {
                this.record = recordMap.get("rows");
            }
            this.fillExcelSheet(i, this.record.size());
        }
    }

    public void fillExcelSheet(int pageNo, int records) {
        int rows = this.xlsxUtil.getMaxRowNum();
        for (int i = 0; i <= rows; ++i) {
            int r;
            Row row = this.xlsxUtil.getRow(i);
            if (row == null) continue;
            boolean isDetail = false;
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) continue;
                String val = this.xlsxUtil.getCellValue(cell);
                if (val.indexOf("$") > 0) {
                    if (this.pageHeader == 1) {
                        this.pageHeader = i;
                    }
                    isDetail = true;
                    String rowsKey = val.substring(val.indexOf("$") + 1, val.indexOf("."));
                    if ("".equals(rowsKey)) {
                        rowsKey = "rows";
                    }
                    if (this.recordMap.containsKey(rowsKey)) {
                        this.record = this.recordMap.get(rowsKey);
                        this.parseUtil.setRecord(this.record);
                        break;
                    }
                    this.record = new ArrayList<Map<String, String>>();
                    this.parseUtil.setRecord(this.record);
                    break;
                }
                val = this.putCellValue(val, null);
                cell.setCellValue(val);
            }
            if (!isDetail) continue;
            int firstRow = records * pageNo;
            int lastRow = records * (pageNo + 1);
            if (this.recordMap.keySet().size() > 1) {
                firstRow = this.record.size() * pageNo;
                lastRow = this.record.size() * (pageNo + 1);
            }
            int n = 0;
            for (r = firstRow; r < this.record.size() && r < lastRow; ++r) {
                this.addExcelRow(i + n, this.rowScope, this.record.get(r));
                n += this.rowScope;
            }
            if (this.padding) {
                for (r = this.record.size(); r < lastRow; ++r) {
                    this.addExcelRow(i + n, this.rowScope, null);
                    n += this.rowScope;
                }
            }
            this.xlsxUtil.removeExcelRow(i + n, this.rowScope);
            i += n - this.rowScope;
            rows = this.xlsxUtil.getMaxRowNum();
        }
    }

    public static PdfPCell getCellImage(String value, Font font, int v_align, int h_align) {
        try {
            PdfPCell cell = new PdfPCell();
            cell.setVerticalAlignment(v_align);
            cell.setHorizontalAlignment(h_align);
            Image image = Image.getInstance((URL)new URL(value));
            cell.setImage(image);
            return cell;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addExcelRow(int startRow, int rows, Map<String, String> data) {
        int endRow = this.xlsxUtil.getMaxRowNum() + rows;
        this.xlsxUtil.shiftRows(startRow, endRow, rows);
        for (int i = 0; i < rows; ++i) {
            int curRow = startRow + i;
            int oriRow = curRow + 1 + i;
            this.xlsxUtil.cloneBlankRow(startRow, oriRow);
            if (data == null) continue;
            this.putRowValue(curRow, oriRow, data);
        }
    }

    private void putRowValue(int curRow, int oriRow, Map<String, String> data) {
        Row insertRow = this.xlsxUtil.getRow(curRow);
        Row originRow = this.xlsxUtil.getRow(oriRow);
        for (int col = 0; col < originRow.getLastCellNum(); ++col) {
            String val;
            Cell cellInsert = insertRow.createCell(col);
            Cell cellSource = originRow.getCell(col);
            if (cellSource == null) continue;
            CellStyle cellStyle = cellSource.getCellStyle();
            if (cellStyle != null) {
                cellInsert.setCellStyle(cellStyle);
            }
            val = (val = this.xlsxUtil.getCellValue(cellSource)).indexOf("$") > 0 ? (data.isEmpty() ? "" : this.putCellValue(val, data)) : this.putCellValue(val, null);
            cellInsert.setCellValue(val);
        }
    }

    private String putCellValue(String val, Map<String, String> rowMap) {
        StringBuffer sb = new StringBuffer();
        String[] arr = val.split("\\{");
        sb.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            String[] field = arr[i].split("\\}");
            String[] keys = field[0].split("\\.");
            Object obj = null;
            if (rowMap == null) {
                if (this.record == null || this.record.size() == 0) {
                    return sb.toString();
                }
                if (this.headMap.containsKey(keys[0])) {
                    obj = this.headMap.get(keys[0]);
                } else if (this.record.get(0).containsKey(keys[0])) {
                    obj = this.record.get(0).get(keys[0]);
                } else {
                    return sb.toString();
                }
                sb.append(this.parseUtil.parse(obj, keys, 1));
            } else {
                if (rowMap.containsKey(keys[1])) {
                    obj = rowMap.get(keys[1]);
                } else if (this.headMap.containsKey(keys[1])) {
                    obj = this.headMap.get(keys[1]);
                } else {
                    return sb.toString();
                }
                sb.append(this.parseUtil.parse(obj, keys, 2));
            }
            if (field.length <= 1) continue;
            sb.append(field[1]);
        }
        return sb.toString();
    }

    public void writeExcel(String file) {
        this.xlsxUtil.writeExcel(file);
    }

    public void writeExcel(OutputStream out) throws IOException {
        this.xlsxUtil.writeExcel(out);
    }

    public void writePdf(OutputStream out) throws DocumentException {
        this.writePdf(out, this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
    }

    public synchronized void writePdf(OutputStream out, float left, float right, float top, float bottom) throws DocumentException {
        Rectangle pageSize = new Rectangle(this.pageWidth, this.pageHeight);
        if (this.rotating) {
            pageSize = pageSize.rotate();
        }
        Document doc = new Document(pageSize, left, right, top, bottom);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        if (this.pageNumber) {
            this.setFooter(writer, pageSize);
        }
        doc.open();
        ArrayList<PdfPTable> pdfTables = new ArrayList<PdfPTable>();
        for (Map<String, List<Map<String, String>>> recordMap : this.recordMapList) {
            this.recordMap = recordMap;
            this.record = this.recordMap.containsKey("rows") ? recordMap.get("rows") : new ArrayList<Map<String, String>>();
            pdfTables.addAll(this.multiPdfTables());
        }
        for (PdfPTable table : pdfTables) {
            doc.add((Element)table);
            doc.newPage();
        }
        doc.close();
        writer.close();
    }

    public PdfPTable onePdfTable(Sheet sheet) throws DocumentException {
        int maxRow = sheet.getPhysicalNumberOfRows() + 1;
        int maxCol = this.xlsxUtil.getMaxColNum(maxRow) + 1;
        LOG.debug("-> rowNum=" + maxRow + ", colNum=" + maxCol);
        PdfPTable pdfTable = new PdfPTable(maxCol);
        pdfTable.setTotalWidth(this.xlsxUtil.getColWidth(maxCol));
        if (this.recordMap.keySet().size() == 1) {
            pdfTable.setHeaderRows(this.pageHeader);
        }
        ArrayList<Integer> regions = new ArrayList<Integer>();
        for (int i = 0; i <= maxRow; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                this.addBlankRow(pdfTable, 13.8f);
                continue;
            }
            float height = row.getHeightInPoints();
            for (int j = 0; j < maxCol; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    pdfTable.addCell(this.newBlankCell(height));
                    continue;
                }
                boolean mergedCell = false;
                for (int n = 0; n < sheet.getNumMergedRegions(); ++n) {
                    CellRangeAddress region = sheet.getMergedRegion(n);
                    if (!region.isInRange(i, j)) continue;
                    mergedCell = true;
                    if (regions.contains(n)) continue;
                    pdfTable.addCell(this.mergedPdfCell(cell, height, region));
                    regions.add(n);
                    LOG.debug("->mergedCell... {" + i + "," + j + "}");
                    break;
                }
                if (mergedCell) continue;
                pdfTable.addCell(this.newNormalCell(cell, height));
            }
        }
        return pdfTable;
    }

    public List<PdfPTable> multiPdfTables() throws DocumentException {
        int pages = 1;
        if (this.pageRows == 0) {
            this.pageRows = 9999;
        } else {
            int rowNum = this.record.size() * this.rowScope;
            pages = rowNum / this.pageRows;
            int n = pages = rowNum % this.pageRows > 0 ? pages + 1 : pages;
            if (pages == 0) {
                pages = 1;
            }
            if (this.filling) {
                rowNum = pages * this.pageRows / this.rowScope;
                for (int i = this.record.size(); i < rowNum; ++i) {
                    this.record.add(new HashMap());
                }
            }
        }
        ArrayList<PdfPTable> tables = new ArrayList<PdfPTable>();
        for (int p = 0; p < pages; ++p) {
            this.headMap.put("pageNo", p + 1);
            this.headMap.put("pageSize", pages);
            int count = this.recordMap.keySet().size();
            String templ = this.templFile;
            if (count % this.pageSplit != 0) {
                templ = templ.replace(".", "-" + count % this.pageSplit + ".");
            }
            this.xlsxUtil = new XlsxUtil(templ);
            this.xlsxUtil.initWorkbook();
            this.fillExcelSheet(p, this.pageRows / this.rowScope);
            PdfPTable pdfTable = this.onePdfTable(this.xlsxUtil.getSheet());
            tables.add(pdfTable);
        }
        return tables;
    }

    private void setFooter(PdfWriter writer, Rectangle pageSize) {
        HeaderFooter headerFooter = new HeaderFooter();
        writer.setBoxSize("art", pageSize);
        writer.setPageEvent((PdfPageEvent)headerFooter);
    }

    private void addBlankRow(PdfPTable pdfTable, float height) {
        PdfPCell pdfCell = this.newBlankCell(height);
        pdfCell.setColspan(pdfTable.getNumberOfColumns());
        pdfTable.addCell(pdfCell);
    }

    private PdfPCell newBlankCell(float height) {
        PdfPCell pdfCell = new PdfPCell();
        pdfCell.setBorder(0);
        pdfCell.setFixedHeight(height);
        return pdfCell;
    }

    private PdfPCell newNormalCell(Cell cell, float height) {
        StyleUtil sUtil = new StyleUtil(this.xlsxUtil.getWorkbook(), cell);
        Font font = sUtil.getPdfFont();
        String s = this.xlsxUtil.getCellValue(cell);
        PdfPCell pdfCell = null;
        if (s != null && s.contains("image:")) {
            pdfCell = new PdfPCell();
            try {
                String url = ConfUtil.appCore() + ConfUtil.getConf((String)"image.url") + s.substring(6);
                Image image = Image.getInstance((URL)new URL(url));
                LOG.info("url:{}" + url);
                pdfCell.setImage(image);
                pdfCell.setFixedHeight(height);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Paragraph paragraph = new Paragraph(s, font);
            pdfCell = new PdfPCell((Phrase)paragraph);
            pdfCell.setMinimumHeight(height);
        }
        pdfCell.setHorizontalAlignment(sUtil.getPdfHAlign());
        pdfCell.setVerticalAlignment(sUtil.getPdfVAlign());
        pdfCell.setBorder(sUtil.getPdfBorder());
        sUtil.setCellRGBA(pdfCell);
        sUtil.setLeftRGBA(pdfCell);
        sUtil.setRightRGBA(pdfCell);
        sUtil.setTopRGBA(pdfCell);
        sUtil.setBottomRGBA(pdfCell);
        return pdfCell;
    }

    private PdfPCell mergedPdfCell(Cell cell, float height, CellRangeAddress range) {
        PdfPCell pdfCell = this.newNormalCell(cell, height);
        int rowSpan = range.getLastRow() - range.getFirstRow() + 1;
        int colSpan = range.getLastColumn() - range.getFirstColumn() + 1;
        pdfCell.setRowspan(rowSpan);
        pdfCell.setColspan(colSpan);
        return pdfCell;
    }

    public void setRecordMapList(List<Map<String, List<Map<String, String>>>> recordMapList) {
        this.recordMapList = recordMapList;
    }

    public void setPageRows(int pageRows, int rowScope) {
        this.pageRows = pageRows / rowScope * rowScope;
        this.rowScope = rowScope;
    }

    public void setHeadMap(Map<String, Object> head) {
        this.headMap = head;
    }

    public void setRecord(List<Map<String, String>> record) {
        this.record = record;
    }

    public void setRotating(boolean rotating) {
        this.rotating = rotating;
    }

    public void setFilling(boolean filling) {
        this.filling = filling;
    }

    public void setPadding(boolean padding) {
        this.padding = padding;
    }

    public void setPageWidth(float pageWidth) {
        this.pageWidth = pageWidth * 2.83527f;
    }

    public void setPageHeight(float pageHeight) {
        this.pageHeight = pageHeight * 2.83527f;
    }

    public void setPageSplit(int pageSplit) {
        this.pageSplit = pageSplit;
    }

    public void setPageNumber(boolean pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSpec(Map<String, String> templMap) {
        this.setPageWidth(Float.parseFloat(templMap.get("templWidth")));
        this.setPageHeight(Float.parseFloat(templMap.get("templHeight")));
        this.setPageSplit(Integer.parseInt(templMap.get("templSplit")));
        this.setRotating("1".equals(templMap.get("templRotate")));
        this.setPadding("1".equals(templMap.get("templPadding")));
        this.setFilling("1".equals(templMap.get("templFilling")));
        this.setPageNumber("1".equals(templMap.get("templPage")));
        this.marginLeft = Float.parseFloat(templMap.get("templLeft"));
        this.marginRight = Float.parseFloat(templMap.get("templRight"));
        this.marginTop = Float.parseFloat(templMap.get("templTop"));
        this.marginBottom = Float.parseFloat(templMap.get("templBottom"));
        short pageRows = Short.parseShort(templMap.get("templRowNum"));
        short rowScope = Short.parseShort(templMap.get("templScope"));
        this.setPageRows(pageRows, rowScope);
    }
}

