/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.utils;

import cn.ps1.xcell.utils.PdfFont;
import cn.ps1.xcell.utils.XlsxFont;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class StyleUtil {
    private XlsxFont xlsxfont;
    short[] cellARGB;
    short[] leftARGB;
    short[] rightARGB;
    short[] topARGB;
    short[] bottomARGB;
    short borderLeft = 0;
    short borderRight = 0;
    short borderTop = 0;
    short borderBottom = 0;
    short hAlign;
    short vAlign;
    boolean isWrap = false;

    public StyleUtil(Workbook workbook, Cell cell) {
        XSSFCell xssfCell = (XSSFCell)cell;
        XSSFCellStyle style = xssfCell.getCellStyle();
        int idx = style.getFontIndex();
        XSSFFont xfont = (XSSFFont)workbook.getFontAt(idx);
        this.xlsxfont = new XlsxFont(xfont);
        this.initXlsxCell(style);
    }

    private void initXlsxCell(XSSFCellStyle cs) {
        this.borderLeft = cs.getBorderLeft().getCode();
        this.borderRight = cs.getBorderRight().getCode();
        this.borderTop = cs.getBorderTop().getCode();
        this.borderBottom = cs.getBorderBottom().getCode();
        XSSFColor xColor = cs.getFillForegroundXSSFColor();
        if (xColor != null) {
            this.cellARGB = StyleUtil.getARGB(xColor);
        }
        if (this.borderLeft > 0) {
            this.leftARGB = StyleUtil.getARGB(cs.getLeftBorderXSSFColor());
        }
        if (this.borderRight > 0) {
            this.rightARGB = StyleUtil.getARGB(cs.getRightBorderXSSFColor());
        }
        if (this.borderTop > 0) {
            this.topARGB = StyleUtil.getARGB(cs.getTopBorderXSSFColor());
        }
        if (this.borderBottom > 0) {
            this.bottomARGB = StyleUtil.getARGB(cs.getBottomBorderXSSFColor());
        }
        this.hAlign = cs.getAlignment().getCode();
        this.vAlign = cs.getVerticalAlignment().getCode();
        this.isWrap = cs.getWrapText();
    }

    public static short[] getARGB(XSSFColor color) {
        if (color == null) {
            return null;
        }
        byte[] argb = color.getARGB();
        if (argb == null) {
            return null;
        }
        short[] aRGB = new short[]{255, 255, 255, 255};
        for (int i = 0; i < argb.length; ++i) {
            aRGB[i] = (short)(argb[i] & 0xFF);
        }
        return aRGB;
    }

    public int getPdfBorder() {
        int border = 0;
        if (this.borderTop > 0) {
            border |= 1;
        }
        if (this.borderBottom > 0) {
            border |= 2;
        }
        if (this.borderLeft > 0) {
            border |= 4;
        }
        if (this.borderRight > 0) {
            border |= 8;
        }
        return border > 0 ? border : -1;
    }

    public int getPdfHAlign() {
        if (this.hAlign < 4) {
            return this.hAlign - 1;
        }
        if (this.hAlign == 5) {
            return 3;
        }
        return -1;
    }

    public int getPdfVAlign() {
        if (this.vAlign < 3) {
            return this.vAlign + 4;
        }
        if (this.vAlign == 3) {
            return 8;
        }
        return 7;
    }

    public Font getPdfFont() {
        return new PdfFont(this.xlsxfont).getFont();
    }

    public void setCellRGBA(PdfPCell pdfCell) {
        if (this.cellARGB != null) {
            pdfCell.setBackgroundColor(PdfFont.getBaseColor(this.cellARGB));
        }
    }

    public void setLeftRGBA(PdfPCell pdfCell) {
        if (this.borderLeft > 0) {
            BaseColor bColor = PdfFont.getBaseColor(this.leftARGB);
            if (bColor != null) {
                pdfCell.setBorderColorLeft(bColor);
            }
            pdfCell.setBorderWidthLeft((float)this.borderLeft);
        }
    }

    public void setRightRGBA(PdfPCell pdfCell) {
        if (this.borderRight > 0) {
            BaseColor bColor = PdfFont.getBaseColor(this.rightARGB);
            if (bColor != null) {
                pdfCell.setBorderColorRight(bColor);
            }
            pdfCell.setBorderWidthRight((float)this.borderRight);
        }
    }

    public void setTopRGBA(PdfPCell pdfCell) {
        if (this.borderTop > 0) {
            BaseColor bColor = PdfFont.getBaseColor(this.topARGB);
            if (bColor != null) {
                pdfCell.setBorderColorTop(bColor);
            }
            pdfCell.setBorderWidthTop((float)this.borderTop);
        }
    }

    public void setBottomRGBA(PdfPCell pdfCell) {
        if (this.borderBottom > 0) {
            BaseColor bColor = PdfFont.getBaseColor(this.bottomARGB);
            if (bColor != null) {
                pdfCell.setBorderColorBottom(bColor);
            }
            pdfCell.setBorderWidthBottom((float)this.borderBottom);
        }
    }
}

