/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.utils;

import cn.ps1.xcell.utils.Config;
import cn.ps1.xcell.utils.XlsxFont;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;
import java.util.HashMap;
import java.util.Map;

public class PdfFont {
    static Font font;
    static Map<String, String> fontMap;

    public PdfFont(XlsxFont xlsxFont) {
        BaseFont baseFont = this.createFont(xlsxFont.getName());
        short size = xlsxFont.getFontSize();
        short[] argb = xlsxFont.getFontARGB();
        font = new Font(baseFont, (float)size, xlsxFont.getStyle());
        font.setColor(PdfFont.getBaseColor(argb));
    }

    public static BaseColor getBaseColor(short[] argb) {
        if (argb == null) {
            return null;
        }
        return new BaseColor((int)argb[1], (int)argb[2], (int)argb[3], (int)argb[0]);
    }

    public Font getFont() {
        return font;
    }

    public BaseFont createFont(String fontName) {
        try {
            String ttfFile = fontMap.get(fontName);
            if (ttfFile != null) {
                return BaseFont.createFont((String)Config.fontPath(ttfFile), (String)"Identity-H", (boolean)false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.createFont();
    }

    public BaseFont createFont() {
        try {
            return BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        fontMap = new HashMap<String, String>();
        fontMap.put("\u7b49\u7ebf", "Deng.ttf");
        fontMap.put("\u4eff\u5b8b", "simfang.ttf");
        fontMap.put("\u9ed1\u4f53", "simhei.ttf");
        fontMap.put("\u6977\u4f53", "simkai.ttf");
        fontMap.put("\u5fae\u8f6f\u96c5\u9ed1", "simhei.ttf");
        fontMap.put("Arial", "arial.ttf");
    }
}

