/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.utils;

import cn.ps1.aolai.service.UtilsService;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ParseUtil {
    private List<Map<String, String>> record;
    private Map<String, String> sumValues = new HashMap<String, String>();
    UtilsService utils = new UtilsService();

    public ParseUtil() {
    }

    public ParseUtil(List<Map<String, String>> record) {
        this.setRecord(record);
    }

    public void setRecord(List<Map<String, String>> record) {
        this.record = record;
    }

    public String parse(Object objVal, String[] keys, int len) {
        String val = String.valueOf(objVal);
        if (keys.length > len) {
            val = this.parseByExpr(val, keys[len]);
        }
        return val;
    }

    public String parseByExpr(String val, String expr) {
        String[] arr = expr.split("\\(");
        String func = arr[0].trim().toUpperCase();
        String args = ")".equals(arr[1]) ? "" : arr[1].split("\\)")[0].trim();
        arr = Pattern.compile("['\"]").matcher(args).replaceAll("").split(",");
        try {
            if ("TODATE".equals(func)) {
                if (val != null && val.length() == 6) {
                    val = val + "01";
                }
                val = arr.length > 1 ? this.toDate(val, arr[0], arr[1]) : this.toDate(val, arr[0]);
            } else if ("TOMONEY".equals(func)) {
                val = this.toMoney(val, arr[0]);
            } else if ("COMMAFMT".equals(func)) {
                double d = Double.parseDouble(val);
                val = arr.length > 1 ? this.commaFmt(d, Integer.parseInt(arr[0]), arr[1]) : this.commaFmt(d, Integer.parseInt(arr[0]));
            } else if ("TOYUAN".equals(func)) {
                val = this.toYuan(val, arr[0]);
            } else if ("TORMB".equals(func)) {
                val = this.toRmb(val);
            } else if ("TOCENT".equals(func)) {
                val = this.toCent(val);
            } else if ("TOSUM".equals(func)) {
                val = this.toSum(val, arr[0]);
            } else if ("IFZERO".equals(func)) {
                val = this.ifZero(val, arr[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    private String toDate(String val, String toPattern) {
        if (toPattern.length() == 0) {
            toPattern = "yyyy-MM-dd";
        }
        return this.utils.timeFormat(val, "yyyyMMdd", toPattern);
    }

    private String toDate(String val, String from, String toPattern) {
        return this.utils.timeFormat(val, from, toPattern);
    }

    private String toMoney(String val, String zero) {
        return this.commaFmt(Double.parseDouble(val), 2, zero);
    }

    private String commaFmt(double val, int bit) {
        return this.commaFmt(val, bit, "");
    }

    private String commaFmt(double val, int bit, String zero) {
        if (val == 0.0) {
            return zero;
        }
        String s = "#,##0";
        if (bit > 0) {
            s = s + ".";
            for (int i = 0; i < bit; ++i) {
                s = s + "0";
            }
        }
        return new DecimalFormat(s).format(val);
    }

    private String toYuan(String val, String zero) {
        double d = Double.parseDouble(val) / 100.0;
        return this.commaFmt(d, 2, zero);
    }

    private String toRmb(String val) {
        return this.utils.toRmb(val);
    }

    private String toCent(String val) {
        return Pattern.compile("[\\,\\.]").matcher(val).replaceAll("");
    }

    private String toSum(String val, String col) {
        double d = 0.0;
        if (!this.sumValues.containsKey(col)) {
            for (int i = 0; i < this.record.size(); ++i) {
                String s = String.valueOf(this.record.get(i).get(col));
                d += Double.parseDouble(s);
            }
        } else {
            return this.sumValues.get(col);
        }
        return String.valueOf(d);
    }

    private String ifZero(String val, String str) {
        return val == null || "0".equals(val) ? str : val;
    }
}

