/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.utils;

import cn.ps1.xcell.utils.Config;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;

public class HeaderFooter
extends PdfPageEventHelper {
    public String header = "";
    public int presentFontSize = 8;
    public Rectangle pageSize = PageSize.A4;
    public PdfTemplate pdfTemplate;
    public BaseFont bf = null;
    public Font fontDetail = null;

    public HeaderFooter() {
    }

    public HeaderFooter(String header, int presentFontSize, Rectangle pageSize) {
        this.header = header;
        this.presentFontSize = presentFontSize;
        this.pageSize = pageSize;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.pdfTemplate = writer.getDirectContent().createTemplate(50.0f, 50.0f);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        this.pageSize = writer.getBoxSize("art");
        try {
            if (this.bf == null) {
                this.bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            if (this.fontDetail == null) {
                this.fontDetail = new Font(this.bf, (float)this.presentFontSize, 0);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)new Phrase(this.header, this.fontDetail), (float)document.left(), (float)(document.top() + 20.0f), (float)0.0f);
        String foot1 = this.setPageFoot(writer.getPageNumber());
        Phrase footer = new Phrase(foot1, this.fontDetail);
        float len = this.bf.getWidthPoint(foot1, (float)this.presentFontSize);
        PdfContentByte cb = writer.getDirectContent();
        float x = (this.pageSize.getRight() - this.pageSize.getLeft()) / 2.0f;
        float y = 8.0f;
        ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)footer, (float)x, (float)y, (float)0.0f);
        cb.addTemplate(this.pdfTemplate, x + len / 2.0f, y);
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.pdfTemplate.beginText();
        this.pdfTemplate.setFontAndSize(this.bf, (float)this.presentFontSize);
        String foot2 = this.setPageFoot(writer.getPageNumber() - 1);
        this.pdfTemplate.showText(foot2);
        this.pdfTemplate.endText();
        this.pdfTemplate.closePath();
    }

    public String setPageFoot(int pageNo) {
        return Config.footer2(pageNo);
    }
}

