/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.utils;

import cn.ps1.aolai.utils.ConfUtil;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private static String MAXSIZE = "maxSize";
    private static String FILETYPE = "fileType";
    private static String FONTPATH = "fontPath";
    private static String FILEPATH = "filePath";
    private static String FOOTER1 = "footer1";
    private static String FOOTER2 = "footer2";
    private static String TEMPL = "templ";
    private static String FILEFREE = "fileFree";
    private static boolean IS_INIT = false;
    private static Map<String, String> GCONF = new HashMap<String, String>();

    private static String get(String key) {
        if (!IS_INIT) {
            String xk = "xcell.";
            String cnf = "";
            for (String k : GCONF.keySet()) {
                cnf = ConfUtil.getConf((String)(xk + k));
                if (cnf.length() == 0) continue;
                GCONF.put(k, cnf);
                IS_INIT = true;
            }
        }
        return GCONF.get(key);
    }

    public static boolean isFileFree() {
        return Config.get(FILEFREE).length() > 0;
    }

    public static String maxSize() {
        return Config.get(MAXSIZE);
    }

    public static String fileType() {
        return Config.get(FILETYPE);
    }

    public static String fontPath(String fileName) {
        return Config.get(FONTPATH) + fileName;
    }

    public static String filePath(String fileName) {
        return Config.get(FILEPATH) + fileName;
    }

    public static String footer2(int pageNo) {
        return Config.get(FOOTER2).replaceAll("\\{ *\\}", String.valueOf(pageNo));
    }

    public static String templ(String fileName) {
        return Config.get(TEMPL) + fileName;
    }

    static {
        GCONF.put(MAXSIZE, "10M");
        GCONF.put(FILETYPE, "");
        GCONF.put(FONTPATH, "");
        GCONF.put(FILEPATH, "");
        GCONF.put(FOOTER1, "\u7b2c {} \u9875 /\u5171");
        GCONF.put(FOOTER2, " {} \u9875");
        GCONF.put(TEMPL, "");
        GCONF.put(FILEFREE, "");
    }
}

