/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.HttpsService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.XlsxUtil;
import cn.ps1.xcell.dao.XcellDao;
import cn.ps1.xcell.service.QuotaService;
import cn.ps1.xcell.utils.Config;
import cn.ps1.xcell.utils.XcellUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class XcellService {
    private static Logger LOG = LoggerFactory.getLogger(XcellService.class);
    private static final String CONT_DISP = "Content-disposition";
    private static final String ROWS = "rows";
    @Autowired
    AolaiService aolai;
    @Autowired
    HttpsService https;
    @Autowired
    UtilsService utils;
    @Autowired
    QuotaService quota;
    @Autowired
    XcellDao xcellDao;

    private Map<String, Object> getParams(HttpServletRequest req) {
        Map map = this.utils.jsonParams(req);
        map.put("alias", this.aolai.setAlias("TEMPL", null));
        map.put("table", "TEMPL");
        return map;
    }

    Map<String, String> getTemplInfo(Map<String, Object> head, HttpServletRequest req) {
        Map user = this.utils.userSelf(req);
        Map<String, String> templ = this.xcellDao.getTemplInfo(head, user);
        if (this.utils.isEmpty(templ)) {
            throw new FailedException();
        }
        return templ;
    }

    public Object doPrintPdf(HttpServletRequest req, HttpServletResponse resp, String type) {
        Map<String, Object> head = this.getParams(req);
        Map<String, String> templ = this.getTemplInfo(head, req);
        Map<String, Object> result = new HashMap<String, Object>();
        if (!head.containsKey("templDown") && !this.utils.isEmpty((Object)templ.get("templHost"))) {
            String url = templ.get("templHost") + head.get("templUri");
            LOG.info("doPrintPdf...{}", (Object)url);
            result = this.https.forward(url, req);
            LOG.info("result={}", result);
        }
        List<Map<String, List<Map<String, String>>>> recordMapList = this.getRecordMapList(result);
        head.put("templName", templ.get("templName"));
        if ("Excel".equals(type)) {
            this.exportExcel(resp, templ, head, recordMapList);
        } else if ("Pdf".equals(type)) {
            this.printPdf(resp, templ, head, recordMapList);
        }
        return null;
    }

    private List<Map<String, List<Map<String, String>>>> getRecordMapList(Map<String, Object> result) {
        ArrayList<Map<String, List<Map<String, String>>>> recordMapList = new ArrayList<Map<String, List<Map<String, String>>>>();
        HashMap<String, List> recodeMap = new HashMap<String, List>();
        Object obj = result.get("info");
        if (!this.utils.isSuccess(result) || obj == null) {
            recodeMap.put(ROWS, new ArrayList());
            recordMapList.add(recodeMap);
            return recordMapList;
        }
        if (obj instanceof Collection) {
            List list = this.utils.obj2List(obj);
            if (list == null || list.size() == 0) {
                recodeMap.put(ROWS, new ArrayList());
                recordMapList.add(recodeMap);
                return recordMapList;
            }
            Map mapOne = (Map)list.get(0);
            Object o = mapOne.get((String)mapOne.keySet().iterator().next() + "");
            if (o instanceof Collection) {
                for (Map map : list) {
                    recodeMap = new HashMap();
                    for (String k : map.keySet()) {
                        if (!(map.get(k) instanceof Collection)) continue;
                        recodeMap.put(k, this.utils.obj2List(map.get(k)));
                    }
                    recordMapList.add(recodeMap);
                }
            } else {
                recodeMap.put(ROWS, this.utils.obj2List(obj));
                recordMapList.add(recodeMap);
            }
        } else if (obj instanceof Map) {
            Map map = this.utils.obj2Map(obj);
            for (String k : map.keySet()) {
                if (!(map.get(k) instanceof Collection)) continue;
                recodeMap.put(k, this.utils.obj2List(map.get(k)));
            }
            recordMapList.add(recodeMap);
        }
        return recordMapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePdf2Resp(XcellUtil excel, String fileName, HttpServletResponse resp) {
        ServletOutputStream out = null;
        try {
            String file = this.pdfFileName(fileName);
            resp.setContentType("application/pdf;charset=UTF-8");
            resp.setHeader(CONT_DISP, "inline;filename=" + file);
            out = resp.getOutputStream();
            excel.writePdf((OutputStream)out);
            out.flush();
            this.utils.close((Closeable)out);
        }
        catch (Exception e) {
            LOG.error("writePdf2Resp...{}", (Object)e.getMessage());
        }
        finally {
            this.utils.close(out);
        }
    }

    private String pdfFileName(String fileName) throws Exception {
        String file = fileName + ".pdf";
        file = new String(file.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePdf2File(XcellUtil excel, String fileName) {
        FileOutputStream out = null;
        try {
            String file = this.pdfFileName(fileName);
            out = new FileOutputStream(file);
            excel.writePdf(out);
            out.flush();
        }
        catch (Exception e) {
            try {
                LOG.error("writePdf2File...{}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                this.utils.close(out);
                throw throwable;
            }
            this.utils.close((Closeable)out);
        }
        this.utils.close((Closeable)out);
    }

    private void printPdf(HttpServletResponse resp, Map<String, String> templ, Map<String, Object> head, List<Map<String, List<Map<String, String>>>> recordMapList) {
        if (!this.utils.isEmpty(head.get("templRotate"))) {
            templ.put("templRotate", String.valueOf(head.get("templRotate")));
        }
        if (!this.utils.isEmpty(head.get("templPage"))) {
            templ.put("templPage", String.valueOf(head.get("templPage")));
        }
        LOG.debug("> doPrintPdf... templ={}", templ);
        LOG.debug("> doPrintPdf... head={}", head);
        String file = Config.templ(templ.get("templFile"));
        XcellUtil excel = new XcellUtil(file, head, recordMapList);
        excel.setPageSpec(templ);
        file = templ.get("templName") + Digest.uuid8();
        this.writePdf2Resp(excel, file, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel(HttpServletResponse resp, Map<String, String> templMap, Map<String, Object> head, List<Map<String, List<Map<String, String>>>> recordMapList) {
        ServletOutputStream out = null;
        try {
            LOG.debug("-> exportExcel... templ={}", templMap);
            LOG.debug("-> exportExcel... head={}", head);
            out = resp.getOutputStream();
            String file = Config.templ(templMap.get("templFile"));
            XcellUtil excel = new XcellUtil(file, head, recordMapList);
            file = templMap.get("templName") + Digest.uuid8() + ".xlsx";
            file = new String(file.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            resp.setContentType("application/vnd.ms-excel");
            resp.setHeader(CONT_DISP, "attachment;filename=" + file);
            excel.fillExcelSheet();
            excel.writeExcel((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            try {
                LOG.error("exportExcel...{}", (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                this.utils.close(out);
                throw throwable;
            }
            this.utils.close((Closeable)out);
        }
        this.utils.close((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> readExcelData(MultipartFile file, int startRow, Map<String, Integer> header) {
        InputStream inp = null;
        try {
            inp = file.getInputStream();
            XlsxUtil xlsx = new XlsxUtil();
            xlsx.initWorkbook(inp);
            List list = xlsx.getDataByRow(startRow, header);
            return list;
        }
        catch (Exception e) {
            LOG.error("readExcelData...{}", (Object)e.getMessage());
        }
        finally {
            this.utils.close((Closeable)inp);
        }
        return new ArrayList<Map<String, String>>();
    }

    public Object doDownLoadPdf(HttpServletRequest req, HttpServletResponse resp, String type) {
        Map<String, Object> head = this.getParams(req);
        Map<String, String> templ = this.getTemplInfo(head, req);
        Map<String, Object> result = new HashMap<String, Object>();
        if (!head.containsKey("templDown")) {
            String url = templ.get("templHost") + head.get("templUri");
            LOG.info("url={}", (Object)url);
            result = this.https.forward(url, req);
        }
        List<Map<String, List<Map<String, String>>>> recordMapList = this.getRecordMapList(result);
        head.put("templName", templ.get("templName"));
        String file = null;
        Map map = new HashMap();
        if ("Pdf".equals(type)) {
            file = this.downLoadPdf(resp, templ, head, recordMapList);
        }
        if (!this.utils.isEmpty(file)) {
            map = this.utils.obj2Map(this.quota.uploadFile(head, XcellService.getMulFileByPath(file)));
        }
        return map;
    }

    private static MultipartFile getMulFileByPath(String picPath) {
        FileItem fileItem = XcellService.createFileItem(picPath);
        return new CommonsMultipartFile(fileItem);
    }

    private static FileItem createFileItem(String filePath) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        String textFieldName = "textField";
        int num = filePath.lastIndexOf(".");
        String extFile = filePath.substring(num);
        FileItem item = factory.createItem(textFieldName, "text/plain", true, "MyFileName" + extFile);
        File newfile = new File(filePath);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(newfile);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            LOG.error("createFileItem...{}", (Object)e.getMessage());
        }
        return item;
    }

    private String downLoadPdf(HttpServletResponse resp, Map<String, String> templ, Map<String, Object> head, List<Map<String, List<Map<String, String>>>> recordMapList) {
        if (!this.utils.isEmpty(head.get("templRotate"))) {
            templ.put("templRotate", String.valueOf(head.get("templRotate")));
        }
        if (!this.utils.isEmpty(head.get("templPage"))) {
            templ.put("templPage", String.valueOf(head.get("templPage")));
        }
        LOG.debug("> doPrintPdf... templ={}", templ);
        LOG.debug("> doPrintPdf... head={}", head);
        String file = Config.templ(templ.get("templFile"));
        XcellUtil excel = new XcellUtil(file, head, recordMapList);
        excel.setPageSpec(templ);
        file = ConfUtil.getConf((String)"xcell.tem") + templ.get("templName") + Digest.uuid8();
        this.writePdf2File(excel, file);
        return file;
    }
}

