/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.xcell.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.service.XfileService;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.xcell.utils.Config;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QuotaService {
    private static final String NOT_FILE = "fileNotExist";
    private static final String GET_XFILE = "getXfileInfo";
    private static final String GET_QUOTA = "getQuotaInfo";
    private static final String[] SPACE_KEYS = new String[]{"spaceApp", "spaceComp"};
    @Autowired
    private AolaiService aolai;
    @Autowired
    private UtilsService utils;
    @Autowired
    private XfileService xfile;

    public Map<String, Object> getParams(HttpServletRequest req) {
        Map map = this.utils.jsonParams(req);
        if (this.utils.isEmpty(map)) {
            map.put("xfileId", req.getParameter("xfileId"));
        }
        return map;
    }

    public Object uploadFile(HttpServletRequest req, MultipartFile file) {
        Map<String, Object> params = this.getJsonParams(req);
        if (file == null || file.getSize() == 0L) {
            return this.utils.invalidParams();
        }
        return this.uploadFile(params, file);
    }

    private Map<String, Object> getJsonParams(HttpServletRequest req) {
        Map params = this.utils.jsonParams(req);
        Map user = this.utils.userSelf(req);
        Object userId = user.get("userId");
        Object userComp = user.get("userComp");
        userId = userId == null ? params.get("userId") : userId;
        userComp = userComp == null ? params.get("userComp") : userComp;
        params.put("xfileUser", userId);
        params.put("xfileComp", userComp);
        params.put("xfileDate", this.utils.today("yyyyMMdd"));
        params.put("xfileId", userId + "_" + Digest.uuid8());
        return params;
    }

    public Object uploadFile(Map<String, Object> params, MultipartFile file) {
        String info = this.checkQuota(params, file.getSize());
        if (info != null) {
            return this.utils.failed(info);
        }
        if (!this.checkSuffix(params, file.getOriginalFilename())) {
            return this.utils.invalidParams();
        }
        return this.saveAsFile(params, file, null);
    }

    private Object saveAsFile(Map<String, Object> params, MultipartFile file, String base64) {
        String fileName = this.makeFileName(params);
        String realPath = Config.filePath(this.getFilePath(params));
        File uploadPath = new File(realPath);
        if (uploadPath.exists() || uploadPath.mkdirs()) {
            try {
                Map map = this.aolai.addRecord("XFILE", params);
                if (this.utils.isSuccess(map)) {
                    if (base64 == null) {
                        file.transferTo(new File(realPath + fileName));
                    } else {
                        Digest.imgDecode((String)base64, (String)(realPath + fileName));
                    }
                    this.updateQuotaFree(params);
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("xfileName", fileName);
                    info.put("xfileId", String.valueOf(params.get("xfileId")));
                    return this.utils.success(info);
                }
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
        return this.utils.result(false);
    }

    private String checkQuota(Map<String, Object> params, long fileSize) {
        fileSize = Math.round(fileSize / 1024L);
        params.put("xfileSize", fileSize);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put(SPACE_KEYS[0], params.get("xfileUser"));
        where.put(SPACE_KEYS[1], params.get("xfileComp"));
        Map<String, String> result = this.getQuotaInfo(where);
        if (this.utils.isFailed(result)) {
            if (this.xfile.overSize(fileSize, Config.maxSize())) {
                return "fileTooLarge";
            }
        } else {
            if (this.xfile.overSize(fileSize, result.get("spaceSize"))) {
                return "fileTooLarge";
            }
            if (this.xfile.overSize(fileSize, result.get("spaceQuota"))) {
                return "lowDiskSpace";
            }
        }
        return null;
    }

    private boolean checkSuffix(Map<String, Object> params, String origin) {
        int dot;
        String suffix = null;
        if (!this.utils.isEmpty((Object)origin) && (dot = origin.lastIndexOf(".")) > 0) {
            suffix = origin.substring(dot + 1).toLowerCase();
        }
        String fileType = Config.fileType();
        if (suffix == null || fileType.indexOf(suffix) == -1) {
            return false;
        }
        params.put("xfileOrigin", origin);
        params.put("xfileType", suffix);
        return true;
    }

    private String getFilePath(Map<String, ?> params) {
        String[] keys = new String[]{"xfileApp", "xfileComp", "xfileDate"};
        return this.xfile.getFilePath(params, keys);
    }

    private String makeFileName(Map<String, ?> params) {
        return this.xfile.makeFileName(params.get("xfileId"), params.get("xfileType"));
    }

    public Object upFileCode(HttpServletRequest req) {
        Map<String, Object> params = this.getJsonParams(req);
        return this.upFileCode(params);
    }

    private Object upFileCode(Map<String, Object> params) {
        String base64 = String.valueOf(params.get("xfileCode"));
        String info = this.checkQuota(params, base64.length());
        if (info != null) {
            return this.utils.failed(info);
        }
        String origin = String.valueOf(params.get("xfileName"));
        if (!this.checkSuffix(params, origin) || base64.length() == 0) {
            return this.utils.invalidParams();
        }
        return this.saveAsFile(params, null, base64);
    }

    private void updateQuotaFree(Map<String, Object> params) {
        if (Config.isFileFree()) {
            return;
        }
        Map map = this.getQuotaInfo(params);
        if (this.utils.isFailed(map)) {
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("xfileApp", params.get("spaceApp"));
        where.put("xfileComp", params.get("spaceComp"));
        List<Map<String, String>> list = this.getXfileList(where);
        long freeQuota = Long.parseLong(map.get("spaceQuota"));
        long usedQuota = 0L;
        for (int i = 0; i < list.size(); ++i) {
            usedQuota += Long.parseLong(list.get(i).get("xfileSize"));
        }
        freeQuota = freeQuota > usedQuota ? freeQuota - usedQuota : 0L;
        HashMap<String, Object> field = new HashMap<String, Object>();
        for (String key : SPACE_KEYS) {
            field.put(key, params.get(key));
        }
        field.put("spaceFree", freeQuota);
        map = this.aolai.update("SPACE", field, params);
    }

    public Map<String, String> downFile(Map<String, Object> params, HttpServletResponse resp) {
        String realFile = this.getRealFileById(params);
        String header = "attachment;filename=";
        String contentType = "application/octet-stream";
        boolean isSuccess = this.xfile.write2Resp(realFile, resp, header, contentType);
        return this.utils.result(isSuccess);
    }

    public Map<String, String> previewFile(Map<String, Object> params, HttpServletResponse resp) {
        String realFile = this.getRealFileById(params);
        String header = "inline;filename=";
        String contentType = "application/pdf;charset=UTF-8";
        boolean isSuccess = this.xfile.write2Resp(realFile, resp, header, contentType);
        return this.utils.result(isSuccess);
    }

    private String getRealFileById(Map<String, Object> where) {
        Map<String, String> item = this.getXfileInfo(where);
        if (this.utils.isFailed(item)) {
            throw new FailedException(NOT_FILE);
        }
        String realPath = Config.filePath(this.getFilePath(item));
        String realFile = realPath + this.makeFileName(item);
        if (!new File(realFile).isFile()) {
            throw new FailedException(NOT_FILE);
        }
        return realFile;
    }

    public Object downFileCode(Map<String, Object> params) {
        String realFile = this.getRealFileById(params);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("fileCode", Digest.imgEncode((String)realFile));
        info.put("fileName", this.xfile.getFileName(realFile));
        return this.utils.success(info);
    }

    public Map<String, String> addQuotaInfo(Map<String, Object> data) {
        String[] keys = new String[]{"spaceApp", "spaceComp", "spaceQuota"};
        if (!this.utils.availParams(data, keys)) {
            return this.utils.invalidParams();
        }
        return this.aolai.addRecord("SPACE", data);
    }

    public Map<String, String> delQuota(Map<String, Object> where) {
        if (!this.utils.availParams(where, SPACE_KEYS)) {
            return this.utils.invalidParams();
        }
        return this.aolai.delete("SPACE", where);
    }

    public Map<String, String> setQuotaInfo(Map<String, Object> data) {
        if (!this.utils.availParams(data, SPACE_KEYS)) {
            return this.utils.invalidParams();
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        for (String key : SPACE_KEYS) {
            where.put(key, data.get(key));
        }
        return this.aolai.update("SPACE", data, where);
    }

    public Map<String, String> getQuotaInfo(Map<String, Object> where) {
        if (!this.utils.availParams(where, SPACE_KEYS)) {
            return this.utils.invalidParams();
        }
        return this.aolai.findOne("SPACE", where, GET_QUOTA);
    }

    public List<Map<String, String>> getQuotaList(Map<String, Object> where) {
        String[] keys = new String[]{"spaceApp"};
        if (this.utils.availParams(where, keys)) {
            return this.aolai.findList("SPACE", GET_QUOTA, where);
        }
        return new ArrayList<Map<String, String>>();
    }

    public Map<String, String> delXfile(Map<String, Object> where) {
        String[] keys = new String[]{"xfileId"};
        if (!this.utils.availParams(where, keys)) {
            return this.utils.invalidParams();
        }
        where.put("xfileFlag", "1");
        String realFile = this.getRealFileById(where);
        File file = new File(realFile);
        if (file.exists() && !file.delete()) {
            return this.utils.result(false);
        }
        return this.aolai.delete("XFILE", where);
    }

    public Map<String, String> setXfileInfo(Map<String, Object> data) {
        if (!data.containsKey("xfileId")) {
            return this.utils.invalidParams();
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("xfileId", data.get("xfileId"));
        return this.aolai.update("XFILE", data, where);
    }

    public Map<String, String> getXfileInfo(Map<String, Object> where) {
        String[] keys = new String[]{"xfileId"};
        if (!this.utils.availParams(where, keys)) {
            return this.utils.invalidParams();
        }
        return this.aolai.findOne("XFILE", where, GET_XFILE);
    }

    public List<Map<String, String>> getXfileList(Map<String, Object> where) {
        String[] keys;
        for (String key : keys = new String[]{"xfileComp", "xfileDate", "xfileUser"}) {
            if (!where.containsKey(key)) continue;
            return this.aolai.findList("XFILE", GET_XFILE, where);
        }
        return new ArrayList<Map<String, String>>();
    }

    public Object saveXfileList(Map<String, Object> params) {
        Object args = params.get("xfileList");
        if (args == null) {
            return this.utils.invalidParams();
        }
        List list = this.utils.obj2List(args);
        String[] keys = new String[]{"xfileId", "xfileState"};
        for (Map file : list) {
            if (this.utils.availParams(file, keys)) continue;
            return this.utils.invalidParams();
        }
        this.aolai.batchAdd("XFILE", list, params.get("i18n"), true);
        return this.utils.success();
    }
}

