/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.HttpsService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.SpringContext;
import cn.ps1.soar.service.OrgnService;
import cn.ps1.soar.utils.FlowUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZeroService {
    private static Logger log = LoggerFactory.getLogger(ZeroService.class);
    private static final String SYNCDEPT = "syncDepts";
    private static final String SYNCUSER = "syncUsers";
    private static final String LASTTIME = "lastTime";
    private static final String NOTICETYPE = "noticeTypes";
    private static final String FOLLOWPROC = "followProcess";
    @Autowired
    private AolaiService aolai;
    @Autowired
    private HttpsService https;
    @Autowired
    private UtilsService utils;
    @Autowired
    private OrgnService orgnSvc;
    @Autowired
    private HttpServletRequest req;
    Object zeroMix = null;

    public Map<String, String> addEnumInfo() {
        Map data = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, data, "enumComp");
        return this.addEnumInfo(data);
    }

    Map<String, String> addEnumInfo(Map<String, Object> data) {
        return this.aolai.addRecord(null, "FF_ENUM", data, true);
    }

    public Map<String, String> delEnumInfo() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "enumComp");
        return this.delEnumInfo(where);
    }

    Map<String, String> delEnumInfo(Map<String, Object> where) {
        return this.aolai.delete(null, "FF_ENUM", where);
    }

    public Map<String, String> getEnumType() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "enumComp");
        Map<String, String> result = this.getEnumInfo(where);
        if (result.containsKey("enumVal")) {
            return this.utils.success(result.get("enumVal"));
        }
        return result;
    }

    public List<Map<String, String>> getEnumList() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "enumComp");
        String[] args = new String[]{null, "FF_ENUM", null, "0"};
        return this.aolai.findAll(where, null, args);
    }

    public Object getEnumInfo() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "enumComp");
        return this.utils.result(this.getEnumInfo(where));
    }

    Map<String, String> getEnumInfo(Map<String, Object> where) {
        return this.aolai.findOne(null, "FF_ENUM", where);
    }

    private Object newZeroMix(String name) {
        try {
            if (this.zeroMix == null) {
                this.zeroMix = SpringContext.getBean((String)name);
            }
            return this.zeroMix;
        }
        catch (Exception e) {
            log.error("newZeroMix...{}", (Object)e.getMessage());
            throw new FailedException();
        }
    }

    public boolean notifyAll(String compId, List<Map<String, String>> empList) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("enumComp", compId);
        where.put("enumKey", NOTICETYPE);
        Map<String, String> map = this.getEnumInfo(where);
        if (!map.containsKey("status")) {
            Object obj = this.doInvoke(map.get("enumTag"), map.get("enumVal"), empList);
            return this.utils.isSuccess(this.utils.obj2Map(obj));
        }
        return true;
    }

    public Map<String, String> syncDatas(String table, Map<String, Object> apiCond, Map<String, Object> cond) {
        Object obj;
        List datas;
        Map map = this.getEnumInfo(apiCond);
        if (map.containsKey("status")) {
            throw new FailedException();
        }
        String lastTime = map.get("enumNote");
        if (this.utils.isDatetime(lastTime, "yyyy-MM-dd HH:mm:ss")) {
            cond.put(LASTTIME, lastTime);
        }
        if ((datas = this.utils.obj2List(obj = this.doInvoke(map.get("enumTag"), map.get("enumVal"), cond))).isEmpty()) {
            return this.utils.success();
        }
        ArrayList<Map> items = new ArrayList<Map>();
        for (Map item : datas) {
            if (!item.containsKey(LASTTIME)) {
                throw new FailedException();
            }
            if (((String)item.get(LASTTIME)).compareTo(lastTime) > 0) {
                lastTime = (String)item.get(LASTTIME);
            }
            items.add(this.utils.map2Obj(item));
        }
        map = this.aolai.batchAdd(null, table, items, apiCond.get("i18n"), true);
        if (this.utils.isSuccess(map)) {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("enumNote", lastTime);
            return this.aolai.update(null, "FF_ENUM", fields, apiCond);
        }
        return map;
    }

    public List<Map<String, String>> getSyncDatas(String jsonStr, Object obj) {
        Map args = this.utils.json2Map((Object)jsonStr);
        obj = this.remoteInvoke(args, obj).get("info");
        return this.utils.parse((Map)args.get("parser"), this.utils.obj2List(obj));
    }

    private Object doInvoke(String beanName, String args, Object cond) {
        String[] func = beanName.split(":");
        try {
            this.zeroMix = this.newZeroMix(func[0]);
            Class[] cls = new Class[]{String.class, Object.class};
            Method m = this.zeroMix.getClass().getMethod(func[1], cls);
            return m.invoke(this.zeroMix, args, cond);
        }
        catch (Exception e) {
            log.error("doCall...", (Throwable)e);
            if (!this.utils.isEmpty((Object)e.getMessage())) {
                throw new FailedException(e.getMessage());
            }
            Throwable cause = e.getCause();
            if (cause != null && !this.utils.isEmpty((Object)cause.getMessage())) {
                throw new FailedException(cause.getMessage());
            }
            throw new FailedException();
        }
    }

    private Map<String, Object> remoteInvoke(Map<String, Map<String, String>> args, Object map) {
        Map cond = this.utils.obj2Map(map);
        cond = this.utils.parse(args.get("mapper"), cond);
        log.debug("remoteInvoke...{}", (Object)cond);
        String res = this.https.httpPost(args.get("host"), cond);
        return this.utils.json2Map((Object)res);
    }

    public Map<String, Object> remoteInvoke(String jsonStr, Object map) {
        return this.remoteInvoke(this.utils.json2Map((Object)jsonStr), map);
    }

    public Map<String, Object> remoteInteface(String jsonStr, Object map) {
        return this.remoteInvoke(this.utils.json2Map((Object)jsonStr), map);
    }

    public Map<String, String> syncUsers() {
        Map where = this.utils.jsonParams(this.req);
        String compId = this.utils.setUserComp(this.req, where, "userComp");
        HashMap<String, Object> apiCond = new HashMap<String, Object>();
        apiCond.put("enumComp", compId);
        apiCond.put("enumKey", SYNCUSER);
        return this.syncDatas("FF_EMPLOYEE", apiCond, where);
    }

    public Map<String, String> syncDepts() {
        Map where = this.utils.jsonParams(this.req);
        String compId = this.utils.setUserComp(this.req, where, "deptComp");
        HashMap<String, Object> apiCond = new HashMap<String, Object>();
        apiCond.put("enumComp", compId);
        apiCond.put("enumKey", SYNCDEPT);
        return this.syncDatas(FlowUtil.deptTable(), apiCond, where);
    }

    public Map<String, Object> testBy() {
        Map user = this.utils.userSelf(this.req);
        HashMap cond = new HashMap();
        cond.put("rankComp", user.get("userComp"));
        int id = this.aolai.getMaxCode(null, "FF_RANK", "rankId", cond);
        log.info("------getMaxCode={}", (Object)id);
        List list = this.aolai.findList("FF_RANK", "", cond);
        log.info("------findList...{}", (Object)list);
        return this.utils.success((Object)list);
    }

    boolean followProcess(Map<String, ?> taskInfo) {
        Object obj;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("enumComp", taskInfo.get("taskComp"));
        where.put("enumKey", FOLLOWPROC);
        Map<String, String> map = this.getEnumInfo(where);
        if (!map.containsKey("status") && !this.utils.isSuccess(this.utils.obj2Map(obj = this.doInvoke(map.get("enumTag"), map.get("enumVal"), taskInfo)))) {
            throw new FailedException("followFailed");
        }
        return true;
    }
}

