/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.FailedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskService {
    private static Logger log = LoggerFactory.getLogger(TaskService.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private UtilsService utils;
    @Autowired
    private HttpServletRequest req;
    private static final String PAGE_SIZE = "pageSize";
    private static final String PAGE_NO = "pageNo";
    private static final String TASK_IDS = "taskIds";
    private static final String NODE_TYPES = "nodeTypes";
    private static final String[] WORK_FIELDS = new String[]{"workComment", "workESign", "workEmpId", "workEmpName", "workAgent", "workUid", "workNote"};
    private static final String[] CAN_DELETE = new String[]{"5", "0", "4"};
    private static final String[] WORK_DONE = new String[]{"2", "4", "1"};
    private static final String[] WORK_OP = new String[]{"workUid", "workAgent"};
    private static final String[] TASK_OP = new String[]{"taskUid", "taskSecty"};

    Map<String, Object> initTaskParams() {
        Map<String, Object> params = this.newTaskParams();
        if (!params.containsKey("taskId")) {
            String[] keys;
            Object obj = params.get("taskMode");
            Map mode = this.utils.obj2Map(obj);
            if (!this.utils.availParams(mode, keys = ConfUtil.getValid((String)"taskMode").split(",|;"))) {
                throw new FailedException();
            }
            params.put("taskTitle", mode.get("modeName"));
            params.put("taskMode", this.utils.obj2Str(obj));
        } else {
            params.remove("taskMode");
        }
        return params;
    }

    Map<String, Object> newTaskParams() {
        Map params = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        params.put("empSecty", user.get("userId"));
        params.put("taskComp", user.get("userComp"));
        return params;
    }

    Map<String, String> saveWorkNodes(Map<String, Object> params, List<Map<String, String>> workNodes) {
        if (workNodes.isEmpty()) {
            throw new FailedException("isLostWay");
        }
        ArrayList<Map> workItems = new ArrayList<Map>();
        Object workId = params.get("taskId");
        Object workNo = params.get("workNodeNo");
        Object approver = params.get("workEmpId");
        for (Map<String, String> node : workNodes) {
            node.remove("workUpdate");
            Map theNode = this.utils.map2Obj(node);
            String nodeNo = node.get("workNodeNo");
            if (nodeNo == null) {
                nodeNo = node.get("nodeNo");
                theNode.put("workTaskId", workId);
                theNode.put("workNodeNo", nodeNo);
                theNode.put("workComp", node.get("nodeComp"));
                theNode.put("workIdx", "0");
            }
            String workEmpId = node.get("workEmpId");
            for (String key : WORK_FIELDS) {
                if (nodeNo.equals(workNo) && approver != null && approver.equals(workEmpId)) {
                    if (params.containsKey(key)) {
                        theNode.put(key, params.get(key));
                        continue;
                    }
                    if (node.get(key) != null) continue;
                    theNode.put(key, "");
                    continue;
                }
                if (node.get(key) != null) continue;
                theNode.put(key, "");
            }
            String trace = node.get("workTrace");
            if (trace == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("nodeNo", params.get("workNodeNo"));
                map.put("empId", params.get("workEmpId"));
                theNode.put("workTrace", this.utils.obj2Str(map));
            }
            workItems.add(theNode);
        }
        log.debug("> saveWorkNodes...{}", workItems);
        if (this.utils.isFailed(this.aolai.batchAdd(null, "FF_WORK", workItems, null, true))) {
            throw new FailedException("doFailed");
        }
        return this.utils.success();
    }

    Map<String, String> addNewTask(Map<String, Object> params, Map<String, String> sponsor, String taskState) {
        params.put("taskEmpName", sponsor.get("empName"));
        params.put("taskUid", sponsor.get("empUid"));
        params.put("taskState", taskState);
        Object userId = params.get("empSecty");
        if (userId.equals(sponsor.get("empSecty"))) {
            params.put("taskSecty", userId);
        }
        log.debug("> addNewTask...{}", params);
        return this.aolai.addRecord(null, "FF_TASK", params, true);
    }

    Map<String, String> getTaskInfo(Map<String, Object> where) {
        Map cond = this.utils.sameId(where, "task");
        return this.aolai.findOne(null, "FF_TASK", cond, "getTaskInfo");
    }

    Map<String, String> getReadyTask(Map<String, Object> params) {
        return this.getReadyTask(params, "0");
    }

    Map<String, String> getReadyTask(Map<String, Object> params, String workState) {
        Map where = this.utils.sameId(params, "task");
        where.put("workNodeNo", params.get("workNodeNo"));
        where.put("workState", workState);
        Object uid = params.get("workAgent");
        Object[] values = new Object[]{uid, uid};
        where.put(this.utils.sqlOr(WORK_OP), values);
        Map<String, Map<String, String>> tables = this.workTables(where);
        HashMap<String, String> sort = new HashMap<String, String>();
        sort.put("taskId", "ASC");
        List list = this.aolai.findAll(null, tables, "getTaskList", where, sort);
        if (list.isEmpty()) {
            throw new FailedException("denyAccess");
        }
        Map task = (Map)list.get(0);
        params.put("workEmpId", task.get("workEmpId"));
        params.put("taskFlowNo", task.get("taskFlowNo"));
        return task;
    }

    Map<String, String> setTaskState(Map<String, Object> params) {
        this.batchInformSb(params);
        Map where = this.utils.sameId(params, "task");
        where.put(this.utils.pHolder((Object)"taskState", "<"), "2");
        return this.aolai.update(null, "FF_TASK", params, where);
    }

    private void batchInformSb(Map<String, Object> params) {
        List empList = this.utils.obj2List(params.get("informSb"));
        if (empList.isEmpty()) {
            return;
        }
        ArrayList items = new ArrayList();
        for (Map emp : empList) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("informComp", params.get("taskComp"));
            item.put("informTaskId", params.get("taskId"));
            item.put("informNodeNo", params.get("taskNodeNo"));
            item.put("informEmpId", emp.get("empId"));
            item.put("informEmpUid", emp.get("empUid"));
            items.add(item);
        }
        if (this.utils.isFailed(this.aolai.batchAdd(null, "FF_INFORM", items, params.get("i18n"), true))) {
            throw new FailedException();
        }
        params.put("taskInform", "1");
    }

    boolean jointlyCompleted(Map<String, String> jointlyNode) {
        if (jointlyNode == null) {
            return false;
        }
        Map<String, Object> where = this.workIf(jointlyNode);
        String[] values = new String[]{"0", "1"};
        where.put(this.pHolderIn("workState"), values);
        String nodeNo = jointlyNode.get("nodeNo");
        if ("3".equals(jointlyNode.get("nodeStyle"))) {
            where.put(this.utils.pHolder((Object)"workNodeNo", "like"), nodeNo + "%");
            where.put(this.utils.pHolder((Object)"workNodeNo", "!="), nodeNo);
        } else {
            where.put(this.utils.pHolder((Object)"workNodeNo", "="), nodeNo);
        }
        return !this.aolai.exists(null, "FF_WORK", where);
    }

    <T> Map<String, Object> workIf(Map<String, T> params) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("workComp", params.get("taskComp"));
        where.put("workTaskId", params.get("taskId"));
        return where;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> cancelTask() {
        Map<String, Object> where = this.taskParams();
        Object taskState = where.get("taskState");
        where.put("taskState", "1");
        Object userId = this.req.getAttribute("userId");
        Map<String, Object> cond = this.workIf(where);
        Object[] values = new Object[]{userId, userId};
        cond.put(this.utils.sqlOr(WORK_OP), values);
        cond.put("workState", "0");
        if (this.aolai.exists(null, "FF_TASK", where) || this.aolai.exists(null, "FF_WORK", cond)) {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            taskState = "6".equals(taskState) ? taskState : "5";
            fields.put("taskState", taskState);
            this.aolai.update(null, "FF_TASK", fields, this.utils.sameId(where, "task"));
            fields.put("workState", "5");
            fields.put("workUid", userId);
            Map<String, Object> cond0 = this.workIf(where);
            cond0.put("workState", "0");
            this.aolai.update(null, "FF_WORK", fields, cond0);
            return this.utils.success();
        }
        return this.utils.invalidParams();
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> undoTask() {
        Map<String, Object> params = this.getWorkParams();
        if (params.containsKey("workNodeNo")) {
            return this.undoWork(params);
        }
        this.deleteWorking(params);
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("taskState", "0");
        if (this.utils.isFailed(this.aolai.update(null, "FF_TASK", fields, this.taskParams()))) {
            throw new FailedException();
        }
        return this.utils.success();
    }

    public Map<String, String> undoWork(Map<String, Object> params) {
        Map<String, String> task = this.getReadyTask(params, "2");
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("workState", "0");
        Map<String, Object> cond = this.workIf(params);
        cond.put("workEmpId", params.get("workEmpId"));
        cond.put("workNodeNo", params.get("workNodeNo"));
        cond.put("workState", "2");
        if (this.utils.isFailed(this.aolai.update(null, "FF_WORK", fields, cond))) {
            return this.utils.invalidParams();
        }
        if ("3".equals(task.get("nodeIssue")) && this.getNodeApprovers(params, "0").size() == 1) {
            throw new FailedException("lostChance");
        }
        this.deleteWorking(params);
        return this.utils.success();
    }

    private void deleteWorking(Map<String, Object> params) {
        Map<String, Object> cond = this.workIf(params);
        cond.put(this.utils.pHolder((Object)"workEmpId", "!="), "");
        if (params.containsKey("workEmpId")) {
            cond.put(this.utils.jsonExt("workTrace", (Object)"empId"), params.get("workEmpId"));
        }
        if (params.containsKey("workNodeNo")) {
            cond.put(this.utils.jsonExt("workTrace", (Object)"nodeNo"), params.get("workNodeNo"));
        }
        cond.put("workState", "0");
        if (this.utils.isFailed(this.aolai.delete(null, "FF_WORK", cond))) {
            throw new FailedException("lostChance");
        }
        cond.put(this.utils.pHolder((Object)"workState", "!="), "0");
        cond.remove("workState");
        if (this.aolai.exists(null, "FF_WORK", cond)) {
            throw new FailedException("lostChance");
        }
    }

    Map<String, Object> getWorkParams() {
        Map params = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        params.put("taskComp", user.get("userComp"));
        params.put("workAgent", user.get("userId"));
        return params;
    }

    public Map<String, Object> getTaskList() {
        Map params = this.utils.jsonParams(this.req);
        Map<String, Object> where = this.workTaskCond(params);
        Map<String, Map<String, String>> tables = this.workTaskCond(params, where);
        LinkedHashMap<String, String> order = new LinkedHashMap<String, String>();
        order.put("taskCreate", "DESC");
        log.debug("> getTaskList...{}", tables);
        Map result = this.aolai.queryList(null, tables, "getTaskList", where, order, ConfUtil.limitRows());
        return this.utils.success((Object)result);
    }

    private Map<String, Object> workTaskCond(Map<String, Object> params) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        if (params.containsKey(PAGE_SIZE)) {
            where.put(PAGE_NO, params.get(PAGE_NO));
            where.put(PAGE_SIZE, params.get(PAGE_SIZE));
        }
        if (!this.utils.isEmpty(params.get(TASK_IDS))) {
            where.put(this.pHolderIn("taskId"), params.get(TASK_IDS));
        }
        if (params.containsKey("nodeType")) {
            String nodeType = String.valueOf(params.get("nodeType"));
            where.put(this.pHolderIn("nodeType"), nodeType.split(","));
        } else if (!this.utils.isEmpty(params.get(NODE_TYPES))) {
            where.put(this.pHolderIn("nodeType"), params.get(NODE_TYPES));
        }
        this.putJsonExtParams(params, where);
        return where;
    }

    public Map<String, Object> getInformTasks() {
        return this.getTaskList();
    }

    public Map<String, Object> getInformList() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "informComp");
        HashMap tables = new HashMap();
        tables.put("FF_INFORM", null);
        HashMap<String, String> cond = new HashMap<String, String>();
        cond.put("empComp", "informComp");
        cond.put("empId", "informEmpId");
        tables.put("FF_EMPLOYEE", cond);
        return this.utils.success((Object)this.aolai.findAll(null, tables, "getInformList", where, null));
    }

    private void putJsonExtParams(Map<String, Object> params, Map<String, Object> where) {
        for (Map.Entry<String, Object> e : params.entrySet()) {
            if (!e.getKey().contains("json_extract")) continue;
            where.put(e.getKey(), e.getValue());
        }
    }

    private Map<String, Map<String, String>> workTaskCond(Map<String, Object> params, Map<String, Object> where) {
        Map user = this.utils.userSelf(this.req);
        where.put("taskComp", user.get("userComp"));
        where.put("taskUrgent", params.get("taskUrgent"));
        Object taskState = params.get("taskState");
        Object workState = params.get("workState");
        if (this.utils.isEmpty(taskState) && this.utils.isEmpty(workState)) {
            throw new FailedException();
        }
        String uid = (String)user.get("userId");
        String[] values = new String[]{uid, uid};
        if (this.utils.isEmpty(taskState)) {
            if ("0".equals(workState)) {
                where.put("workState", "0");
                where.put("taskState", "1");
            } else if ("2".equals(workState)) {
                this.setTaskPeriod(params, where, "workUpdate");
                where.put(this.pHolderIn("workState"), WORK_DONE);
            } else if (!this.utils.isEmpty(workState)) {
                this.setTaskPeriod(params, where, "workUpdate");
            } else {
                throw new FailedException();
            }
            where.put("nodeStyle", "0");
            where.put(this.utils.sqlOr(WORK_OP), values);
            return this.workTables(where);
        }
        if ("0".equals(taskState)) {
            where.put(this.utils.pHolder((Object)"workState", "!="), "2");
        } else if ("all".equals(taskState)) {
            this.setTaskPeriod(params, where, "taskCreate");
        } else if (!this.utils.isEmpty(taskState)) {
            where.put("taskState", taskState);
            this.setTaskPeriod(params, where, "taskCreate");
        } else {
            throw new FailedException();
        }
        if ("1".equals(params.get("taskInform"))) {
            where.put("informEmpUid", user.get("userId"));
            return this.informTables(where);
        }
        where.put(this.utils.sqlOr(TASK_OP), values);
        return this.taskTables(where);
    }

    private String pHolderIn(String key) {
        return this.utils.pHolder((Object)key, "in");
    }

    private void setTaskPeriod(Map<String, Object> params, Map<String, Object> where, String time) {
        String startDate = (String)params.get("startDate");
        String endDate = (String)params.get("endDate");
        startDate = !this.utils.isDatetime(startDate, "yyyy-MM-dd") ? this.utils.prevMonth("", 3) + "01" : startDate + " 00:00:00";
        where.put(this.utils.pHolder((Object)time, ">="), startDate);
        if (this.utils.isDatetime(endDate, "yyyy-MM-dd")) {
            where.put(this.utils.pHolder((Object)time, "<="), endDate + " 23:59:59");
        } else if (endDate != null) {
            throw new FailedException();
        }
        log.debug("setTaskPeriod...{}", where);
    }

    private Map<String, Map<String, String>> workTables(Map<String, Object> where) {
        LinkedHashMap<String, Map<String, String>> tables = new LinkedHashMap<String, Map<String, String>>();
        String taskComp = (String)where.get("taskComp");
        tables.put("FF_WORK", null);
        HashMap<String, String> cond1 = new HashMap<String, String>();
        cond1.put("taskComp", taskComp);
        cond1.put("taskId", "workTaskId");
        tables.put("FF_TASK", cond1);
        return this.workJoinNode(taskComp, tables, (String)where.get("nodeStyle"));
    }

    private Map<String, Map<String, String>> informTables(Map<String, Object> where) {
        LinkedHashMap<String, Map<String, String>> tables = new LinkedHashMap<String, Map<String, String>>();
        tables.put("FF_INFORM", null);
        HashMap<String, String> cond = new HashMap<String, String>();
        cond.put("taskComp", "informComp");
        cond.put("taskId", "informTaskId");
        tables.put("FF_TASK", cond);
        String taskComp = (String)where.get("taskComp");
        this.taskJoinWork(taskComp, tables, "informEmpId");
        return this.workJoinNode(taskComp, tables, (String)where.get("nodeStyle"));
    }

    private Map<String, Map<String, String>> taskTables(Map<String, Object> where) {
        LinkedHashMap<String, Map<String, String>> tables = new LinkedHashMap<String, Map<String, String>>();
        tables.put("FF_TASK", null);
        String taskComp = (String)where.get("taskComp");
        this.taskJoinWork(taskComp, tables);
        return this.workJoinNode(taskComp, tables, (String)where.get("nodeStyle"));
    }

    private void taskJoinWork(String workComp, Map<String, Map<String, String>> tables) {
        this.taskJoinWork(workComp, tables, null);
    }

    private void taskJoinWork(String workComp, Map<String, Map<String, String>> tables, String empIdKey) {
        HashMap<String, String> cond1 = new HashMap<String, String>();
        cond1.put("workComp", workComp);
        cond1.put("workNodeNo", "taskNodeNo");
        cond1.put("workTaskId", "taskId");
        cond1.put("workIdx", "0");
        if (empIdKey != null) {
            cond1.put("workEmpId", empIdKey);
        }
        tables.put("FF_WORK", cond1);
    }

    private Map<String, Map<String, String>> workJoinNode(String nodeComp, Map<String, Map<String, String>> tables, String nodeStyle) {
        HashMap<String, String> cond2 = new HashMap<String, String>();
        cond2.put("nodeComp", nodeComp);
        cond2.put("nodeStyle", nodeStyle);
        cond2.put("nodeNo", "workNodeNo");
        cond2.put("nodeFlowNo", "taskFlowNo");
        tables.put("FF_NODE", cond2);
        return tables;
    }

    public Map<String, Object> getTaskInfo() {
        Map<String, Object> where = this.taskParams();
        if (this.aolai.exists(null, "FF_TASK", where)) {
            Map cond = this.utils.sameId(where, "task");
            return this.utils.success((Object)this.aolai.findOne(null, "FF_TASK", cond));
        }
        throw new FailedException();
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> delTask() {
        Map<String, Object> params = this.taskParams();
        Map where = this.utils.sameId(params, "task");
        where.put(this.pHolderIn("taskState"), CAN_DELETE);
        if (!this.aolai.exists(null, "FF_TASK", where)) {
            return this.utils.invalidParams();
        }
        this.aolai.delete(null, "FF_TASK", this.utils.sameId(where, "task"));
        this.aolai.delete(null, "FF_WORK", this.workIf(where));
        return this.utils.success();
    }

    private Map<String, Object> taskParams() {
        Map where = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        where.put("taskComp", user.get("userComp"));
        String uid = (String)user.get("userId");
        String[] values = new String[]{uid, uid};
        where.put(this.utils.sqlOr(TASK_OP), values);
        return where;
    }

    public Map<String, Object> getWorkNodes() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "workComp");
        where.put(this.utils.pHolder((Object)"workEmpId", "!="), "");
        LinkedHashMap<String, String> order = new LinkedHashMap<String, String>();
        order.put("workUpdate", "DESC");
        order.put("workCreate", "DESC");
        String[] args = new String[]{null, "FF_WORK", null, "0"};
        return this.utils.success((Object)this.aolai.findAll(where, order, args));
    }

    List<Map<String, String>> getNodeApprovers(Map<String, Object> params) {
        return this.getNodeApprovers(params, "2");
    }

    List<Map<String, String>> getNodeApprovers(Map<String, Object> params, String workState) {
        Map<String, Object> where = this.workIf(params);
        where.put("workNodeNo", params.get("choseNodeNo"));
        where.put("workState", workState);
        where.put("workIdx", 0);
        return this.aolai.findList("FF_WORK", where);
    }

    public Object saveApprovers() {
        Map params = this.utils.jsonParams(this.req);
        List items = this.utils.obj2List(params.get("items"));
        if (items.isEmpty()) {
            this.utils.invalidParams();
        }
        String[] keys = new String[]{"choseTaskId", "choseNodeNo", "choseEmpId"};
        String compId = this.utils.setUserComp(this.req, params, "choseComp");
        for (Map item : items) {
            if (!this.utils.availParams(item, keys)) {
                this.utils.invalidParams();
            }
            item.put("choseComp", compId);
            item.put("choseState", "1");
        }
        return this.aolai.batchAdd(null, "FF_CHOSE", items, params.get("i18n"), true);
    }

    List<Map<String, String>> choseApprovers(Map<String, String> node) {
        HashMap tables = new HashMap();
        tables.put("FF_CHOSE", null);
        HashMap<String, String> cond0 = new HashMap<String, String>();
        cond0.put("empComp", "choseComp");
        cond0.put("empId", "choseEmpId");
        cond0.put("empUid", node.get("workUid"));
        tables.put("FF_EMPLOYEE", cond0);
        HashMap<String, String> cond = new HashMap<String, String>();
        cond.put("choseComp", node.get("nodeComp"));
        cond.put("choseTaskId", node.get("taskId"));
        cond.put("choseNodeNo", node.get("nodeNo"));
        cond.put("choseState", "1");
        HashMap<String, String> sort = new HashMap<String, String>();
        sort.put("empId", "ASC");
        return this.aolai.findAll(null, tables, "choseApprovers", cond, sort);
    }
}

