/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.HttpsService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.soar.dao.FlowDao;
import cn.ps1.soar.utils.FlowUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgnService {
    private static Logger log = LoggerFactory.getLogger(OrgnService.class);
    private static final String GET_EMPS = "getEmpList";
    @Autowired
    private AolaiService aolai;
    @Autowired
    private HttpsService https;
    @Autowired
    private UtilsService utils;
    @Autowired
    private HttpServletRequest req;
    @Autowired
    private FlowDao flowDao;

    public Map<String, Object> getEmpOfDept() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "orgnComp");
        Map<String, Map<String, String>> tables = this.getOrgnEmpCond(where);
        return this.getEmpList(tables, where, this.empByName());
    }

    private Map<String, String> empByName() {
        LinkedHashMap<String, String> order = new LinkedHashMap<String, String>();
        order.put("empName", "ASC");
        return order;
    }

    public Map<String, Object> getEmpInDept() {
        Map where = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        if (!where.containsKey("orgnEmpId") && !where.containsKey("empId")) {
            Object empUid = where.get("empUid");
            String userId = (String)user.get("userId");
            if (empUid == null || userId.equals(empUid)) {
                where.put("empSecty", userId);
            }
        }
        where.put("orgnComp", user.get("userComp"));
        Map<String, Map<String, String>> tables = this.getOrgnEmpCond(where);
        return this.getEmpList(tables, where, this.sortDept());
    }

    public Map<String, Object> getEmpByJob() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "orgnComp");
        Map<String, Map<String, String>> tables = this.getOrgnEmpCond(where);
        return this.getEmpList(tables, where, this.sortDept());
    }

    private Map<String, String> sortDept() {
        LinkedHashMap<String, String> order = new LinkedHashMap<String, String>();
        order.put("deptId", "DESC");
        order.put("empName", "ASC");
        return order;
    }

    List<Map<String, String>> getEmpBy(Map<String, Object> where) {
        Map<String, Map<String, String>> tables = this.getOrgnEmpCond(where);
        Map<String, String> order = this.sortDept();
        return this.aolai.findAll(null, tables, GET_EMPS, where, order, null);
    }

    public Map<String, String> addOrgn() {
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("orgnComp", user.get("userComp"));
        data.put("orgnOpUid", user.get("userId"));
        data.put("orgnState", "1");
        String jobs = null;
        if (data.containsKey("orgnJobs")) {
            jobs = this.utils.obj2Str(data.get("orgnJobs"));
        }
        data.put("orgnJobs", jobs == null ? "{}" : jobs);
        return this.aolai.addRecord("FF_ORGN", data, true);
    }

    public Map<String, String> delOrgn() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "orgnComp");
        return this.delOrgn(where);
    }

    private Map<String, String> delOrgn(Map<String, Object> where) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("orgnState", "0");
        return this.aolai.update(null, "FF_ORGN", fields, where);
    }

    public Map<String, Object> getDeptList() {
        Map where = this.utils.jsonParams(this.req);
        String userComp = this.utils.setUserComp(this.req, where, "deptComp");
        List<Map<String, String>> items = this.getDeptList(where);
        return this.utils.success(this.deptGroupCount(items, userComp));
    }

    List<Map<String, String>> getDeptList(Map<String, Object> where) {
        Object pid = where.get("deptPid");
        if (!this.utils.isEmpty(pid)) {
            where.put(this.utils.pHolder((Object)"deptId", "LIKE"), pid + "%");
            where.remove("deptPid");
        }
        FlowUtil.likeCond(where, "deptName");
        this.utils.resetState(where, "deptState");
        HashMap<String, String> order = new HashMap<String, String>();
        order.put("deptId", "ASC");
        if (this.utils.isEmpty(where.get("deptState"))) {
            where.put(this.utils.pHolder((Object)"deptState", "!="), "0");
        }
        String[] args = new String[]{null, FlowUtil.deptTable(), "getDivnList", "0"};
        return this.aolai.findAll(where, order, args);
    }

    private List<Map<String, String>> deptGroupCount(List<Map<String, String>> items, Object deptComp) {
        if (!items.isEmpty()) {
            HashMap<String, Object> cond = new HashMap<String, Object>();
            cond.put("empComp", deptComp);
            cond.put("empState", "1");
            String[] keys = new String[]{"empDept"};
            List list = this.aolai.groupCount(null, "FF_EMPLOYEE", keys, cond);
            Map tmp = this.utils.list2Map(list, "empDept", "CNT");
            Iterator<Map<String, String>> iterator = items.iterator();
            while (iterator.hasNext()) {
                Map<String, String> item;
                String cnt = (String)tmp.get((item = iterator.next()).get("deptId"));
                item.put("deptCount", cnt != null ? "0" : cnt);
            }
        }
        return items;
    }

    public Map<String, String> addDept() {
        Map params = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        params.put("deptComp", user.get("userComp"));
        params.put("deptOpUid", user.get("userId"));
        String[] keys = new String[]{"deptId", "deptComp", "deptPid", "deptName"};
        if (this.aolai.exists(FlowUtil.deptTable(), this.utils.sameIf(params, keys))) {
            throw new FailedException("duplicateName");
        }
        String[] parser = new String[]{FlowUtil.deptTable(), "deptComp", "deptId", "deptPid", "deptLeaf", "deptLevel", "deptOpUid"};
        params.put("deptState", "1");
        return this.aolai.addTreeNode(params, parser, FlowUtil.leafW());
    }

    public Map<String, String> setDept() {
        Map data = this.utils.jsonParams(this.req);
        if (data.containsKey("deptState")) {
            this.utils.resetState(data, "deptState");
        }
        Map user = this.utils.userSelf(this.req);
        data.put("deptComp", user.get("userComp"));
        data.put("deptOpUid", user.get("userId"));
        if (data.containsKey("deptName")) {
            String[] keys = new String[]{"deptId", "deptComp", "deptPid", "deptName"};
            if (this.aolai.exists(FlowUtil.deptTable(), this.utils.sameIf(data, keys))) {
                throw new FailedException("duplicateName");
            }
        }
        Map where = this.utils.sameId(data, "dept");
        return this.aolai.update(FlowUtil.deptTable(), data, where);
    }

    public Map<String, String> delDept() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "deptComp");
        HashMap cond = new HashMap();
        cond.put("orgnComp", where.get("deptComp"));
        cond.put("orgnDept", where.get("deptId"));
        if (this.aolai.exists(null, "FF_ORGN", cond)) {
            throw new FailedException("cantRemove");
        }
        HashMap cond1 = new HashMap();
        cond1.put("empComp", where.get("deptComp"));
        cond1.put("empDept", where.get("deptId"));
        if (this.aolai.exists(null, "FF_EMPLOYEE", cond1)) {
            throw new FailedException("cantRemove");
        }
        HashMap cond0 = new HashMap();
        cond0.put("deptComp", where.get("deptComp"));
        cond0.put("deptPid", where.get("deptId"));
        if (this.aolai.exists(null, FlowUtil.deptTable(), cond0)) {
            throw new FailedException("cantRemove");
        }
        return this.aolai.delete(null, FlowUtil.deptTable(), where);
    }

    public Map<String, Object> getEmpList() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "empComp");
        Map<String, Map<String, String>> tables = this.getEmpCond(where);
        return this.getEmpList(tables, where, this.empByName());
    }

    private Map<String, Object> getEmpList(Map<String, Map<String, String>> tables, Map<String, Object> where, Map<String, String> order) {
        Map result = this.aolai.queryList(null, tables, GET_EMPS, where, order, null, ConfUtil.limitRows());
        List<Map<String, String>> list = this.utils.obj2List(result.get("items"));
        list = this.setAgentName(list);
        result.put("items", this.setJobsName(list));
        return this.utils.success((Object)result);
    }

    Map<String, Map<String, String>> getEmpCond(Map<String, Object> where) {
        FlowUtil.likeCond(where, "empName");
        this.utils.resetState(where, "empState");
        HashMap<String, Map<String, String>> tables = new HashMap<String, Map<String, String>>();
        tables.put("FF_EMPLOYEE", null);
        HashMap<String, String> cond1 = new HashMap<String, String>();
        String empComp = (String)where.get("empComp");
        cond1.put("orgnComp", empComp);
        cond1.put("orgnEmpId", "empId");
        cond1.put("orgnDept", "empDept");
        tables.put("FF_ORGN", cond1);
        HashMap<String, String> cond2 = new HashMap<String, String>();
        cond2.put("deptComp", empComp);
        cond2.put("deptId", "empDept");
        tables.put(FlowUtil.deptTable(), cond2);
        return tables;
    }

    Map<String, Map<String, String>> getOrgnEmpCond(Map<String, Object> where) {
        String key;
        HashMap<String, Map<String, String>> tables = new HashMap<String, Map<String, String>>();
        tables.put("FF_ORGN", null);
        HashMap<String, String> cond1 = new HashMap<String, String>();
        if (where.containsKey("empSecty")) {
            String[] keys = new String[]{"empUid", "empSecty"};
            Object uid = where.get("empSecty");
            Object[] values = new Object[]{uid, uid};
            where.put(this.utils.sqlOr(keys), values);
            where.remove("empSecty");
        } else if (where.containsKey("empId")) {
            where.put("orgnEmpId", where.get("empId"));
        }
        boolean isDepart = "0".equals(where.get("empState"));
        String empState = isDepart ? "0" : "1";
        String compId = (String)where.get("orgnComp");
        cond1.put("empComp", compId);
        cond1.put("empId", "orgnEmpId");
        cond1.put("empState", empState);
        tables.put("FF_EMPLOYEE", cond1);
        HashMap<String, String> cond2 = new HashMap<String, String>();
        cond2.put("deptComp", compId);
        cond2.put("deptId", "orgnDept");
        tables.put(FlowUtil.deptTable(), cond2);
        FlowUtil.likeCond(where, "empName");
        where.put("empState", empState);
        if (where.containsKey("include")) {
            key = this.utils.pHolder((Object)"orgnDept", "like");
            where.put(key, where.get("orgnDept") + "%");
            where.remove("orgnDept");
        }
        if (where.containsKey("orgnJob")) {
            key = this.utils.jsonExt("orgnJobs", where.get("orgnJob"));
            where.put(key, "1");
            where.remove("orgnJob");
        }
        return tables;
    }

    List<Map<String, String>> setAgentName(List<Map<String, String>> empList) {
        if (!empList.isEmpty()) {
            String[] keys = new String[]{"empAgent", "empSecty"};
            HashSet<String> set = new HashSet<String>();
            for (Map<String, String> emp : empList) {
                for (String key : keys) {
                    if (this.utils.isEmpty((Object)emp.get(key))) continue;
                    set.add(emp.get(key));
                }
            }
            log.debug("setAgentName...{}", set);
            if (!set.isEmpty()) {
                String compId = empList.get(0).get("empComp");
                Map<String, String> names = this.getEmpsName(compId, set);
                log.debug("getEmpsName...{}", names);
                String[] vals = new String[]{"empAgentName", "empSectyName"};
                for (Map<String, String> emp : empList) {
                    for (int i = 0; i < 2; ++i) {
                        String uid = emp.get(keys[i]);
                        String name = names.containsKey(uid) ? names.get(uid) : "";
                        emp.put(vals[i], name);
                    }
                }
            }
        }
        return empList;
    }

    List<Map<String, String>> setJobsName(List<Map<String, String>> empList) {
        if (empList.isEmpty()) {
            return empList;
        }
        String empComp = empList.get(0).get("empComp");
        Map<String, String> jobNames = this.getJobsName(empComp);
        for (Map<String, String> emp : empList) {
            String jobs = emp.get("orgnJobs");
            if (jobs == null) {
                emp.put("orgnJobNames", "");
                continue;
            }
            Map map = this.utils.json2Map((Object)jobs);
            for (String key : map.keySet()) {
                map.put(key, jobNames.get(key));
            }
            emp.put("orgnJobs", this.utils.obj2Str((Object)map));
            jobs = String.join((CharSequence)",", map.values());
            emp.put("orgnJobNames", jobs);
        }
        return empList;
    }

    private Map<String, String> getJobsName(Object jobComp) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("jobComp", jobComp);
        String[] args = new String[]{null, "FF_JOB", "getJobList", "0"};
        List list = this.aolai.findAll(cond, null, args);
        return this.utils.list2Map(list, "jobNo", "jobName");
    }

    private Map<String, String> getEmpsName(Object empComp, Set<String> set) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("empComp", empComp);
        if (set != null && !set.isEmpty()) {
            ArrayList<String> empSetList = new ArrayList<String>(set);
            cond.put(this.utils.pHolder((Object)"empUid", "in"), empSetList);
        }
        String[] args = new String[]{null, "FF_EMPLOYEE", "getEmpName", "0"};
        List list = this.aolai.findAll(cond, null, args);
        return this.utils.list2Map(list, "empUid", "empName");
    }

    public Map<String, Object> getEmpInfo() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "empComp");
        List<Map<String, String>> empList = this.getEmployee(where);
        if (empList.isEmpty()) {
            throw new FailedException();
        }
        return this.utils.success(empList.get(0));
    }

    List<Map<String, String>> getEmployee(Map<String, Object> where) {
        Map<String, Map<String, String>> tables = this.getEmpCond(where);
        return this.aolai.findAll(null, tables, GET_EMPS, where, null);
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> addEmployee() {
        String mobi;
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("empComp", user.get("userComp"));
        data.put("empOpUid", user.get("userId"));
        if (!data.containsKey("empRank")) {
            data.put("empRank", this.getDefaultRank(data.get("empComp")));
        }
        if (!data.containsKey("empUid")) {
            data.put("empUid", data.get("empMobi"));
        }
        if (!this.utils.isMobile(mobi = (String)data.get("empMobi"))) {
            return this.utils.result("mobileRules");
        }
        this.sameEmpIf(data, "empUid");
        this.sameEmpIf(data, "empIdcard");
        this.sameEmpIf(data, "empMobi");
        if (!this.utils.isEmpty(data.get("empWorkId"))) {
            this.sameEmpIf(data, "empWorkId");
        }
        data.put("empId", Digest.enBase62((long)Long.valueOf(mobi)));
        return this.addEmployee(data);
    }

    private void sameEmpIf(Map<String, Object> data, String field) {
        String[] keys;
        Map cond;
        if (data.containsKey(field) && this.aolai.exists(null, "FF_EMPLOYEE", cond = this.utils.sameIf(data, keys = new String[]{"empId", field, "empComp"}))) {
            log.debug("sameEmpIf...{}", (Object)cond);
            field = String.join((CharSequence)"_", "dataDuplicate", field);
            throw new FailedException(field);
        }
    }

    private Map<String, String> addEmployee(Map<String, Object> data) {
        HashMap<String, Object> orgn = new HashMap<String, Object>();
        orgn.put("orgnComp", data.get("empComp"));
        orgn.put("orgnDept", data.get("empDept"));
        orgn.put("orgnOpUid", data.get("empOpUid"));
        orgn.put("orgnState", "1");
        String jobs = null;
        if (data.containsKey("empJobs")) {
            jobs = this.utils.obj2Str(data.get("empJobs"));
        }
        orgn.put("orgnJobs", jobs == null ? "{}" : jobs);
        orgn.put("orgnEmpId", data.get("empId"));
        try {
            if (this.utils.isSuccess(this.aolai.addRecord(null, "FF_ORGN", orgn, true)) && this.utils.isSuccess(this.aolai.addRecord(null, "FF_EMPLOYEE", data))) {
                return this.utils.success();
            }
            throw new FailedException();
        }
        catch (FailedException e) {
            throw new FailedException(e.getMessage());
        }
        catch (Exception e) {
            log.error("addEmployee...{}", (Object)e.getMessage());
            throw new FailedException("doFailed");
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> setEmployee() {
        Map data = this.utils.jsonParams(this.req);
        if (data.containsKey("empState")) {
            data.remove("empState");
        }
        Map user = this.utils.userSelf(this.req);
        data.put("empComp", user.get("userComp"));
        data.put("empOpUid", user.get("userId"));
        this.sameEmpIf(data, "empUid");
        if (!this.utils.isEmpty(data.get("empIdcard"))) {
            this.sameEmpIf(data, "empIdcard");
        }
        if (!this.utils.isEmpty(data.get("empMobi"))) {
            this.sameEmpIf(data, "empMobi");
        }
        if (!this.utils.isEmpty(data.get("empWorkId"))) {
            this.sameEmpIf(data, "empWorkId");
        }
        if (data.containsKey("empJobs") && data.containsKey("empDept")) {
            HashMap where = new HashMap();
            where.put("orgnComp", data.get("empComp"));
            where.put("orgnEmpId", data.get("empId"));
            where.put("orgnDept", data.get("empDept"));
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("orgnJobs", this.utils.obj2Str(data.get("empJobs")));
            if (this.utils.isFailed(this.aolai.update("FF_ORGN", fields, where))) {
                throw new FailedException();
            }
        }
        if (data.containsKey("empAgent")) {
            HashMap fields = new HashMap();
            fields.put("workAgent", data.get("empAgent"));
            HashMap cond = new HashMap();
            cond.put("workComp", data.get("empComp"));
            cond.put("workEmpId", data.get("empId"));
            cond.put("workState", "0");
            if (this.utils.isFailed(this.aolai.update("FF_WORK", fields, cond))) {
                throw new FailedException();
            }
        }
        return this.aolai.update("FF_EMPLOYEE", data, this.utils.sameId(data, "emp"));
    }

    public Map<String, String> delEmployee() {
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("empComp", user.get("userComp"));
        data.put("empOpUid", user.get("userId"));
        if (!data.containsKey("empState")) {
            data.put("empState", "0");
            data.put("empDelete", this.utils.today("yyyy-MM-dd HH:mm:ss"));
        }
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("orgnComp", data.get("empComp"));
        cond.put("orgnEmpId", data.get("empId"));
        this.delOrgn(cond);
        return this.aolai.update("FF_EMPLOYEE", data, this.utils.sameId(data, "emp"));
    }

    public Map<String, Object> getJobList() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "jobComp");
        FlowUtil.likeCond(where, "jobName");
        String[] args = new String[]{null, "FF_JOB", "getJobList", "0"};
        List list = this.aolai.findAll(where, null, args);
        return this.utils.success(this.jobGroupCount(list, where.get("jobComp")));
    }

    private List<Map<String, String>> jobGroupCount(List<Map<String, String>> list, Object orgnComp) {
        if (!list.isEmpty()) {
            HashMap<String, Object> cond = new HashMap<String, Object>();
            cond.put("orgnComp", orgnComp);
            for (Map<String, String> job : list) {
                cond.put("orgnJob", job.get("jobNo"));
                int cnt = this.flowDao.groupEmpByJob(cond);
                job.put("jobCount", cnt > 0 ? String.valueOf(cnt) : "0");
            }
            log.debug("jobGroupCount...{}", list);
        }
        return list;
    }

    public Map<String, String> addJob() {
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("jobComp", user.get("userComp"));
        String[] keys = new String[]{"jobNo", "jobComp", "jobName"};
        if (this.aolai.exists("FF_JOB", this.utils.sameIf(data, keys))) {
            throw new FailedException("duplicateName");
        }
        data.put("jobOpUid", user.get("userId"));
        return this.addJob(data);
    }

    private Map<String, String> addJob(Map<String, Object> data) {
        int times = 2;
        while (times-- > 0) {
            data.put("jobNo", Digest.uuid8());
            try {
                return this.aolai.addRecord("FF_JOB", data);
            }
            catch (FailedException e) {
                throw new FailedException(e.getMessage());
            }
            catch (Exception e) {
                log.error("addJob...{}", (Object)e.getMessage());
            }
        }
        throw new FailedException("doFailed");
    }

    public Map<String, String> setJob() {
        String[] keys;
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("jobComp", user.get("userComp"));
        if (data.containsKey("jobName") && this.aolai.exists("FF_JOB", this.utils.sameIf(data, keys = new String[]{"jobNo", "jobComp", "jobName"}))) {
            throw new FailedException("duplicateName");
        }
        data.put("jobOpUid", user.get("userId"));
        return this.aolai.update("FF_JOB", data, this.utils.sameNo(data, "job"));
    }

    public Map<String, String> delJob() {
        Map where = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        where.put("jobComp", user.get("userComp"));
        HashMap cond0 = new HashMap();
        cond0.put("orgnComp", where.get("jobComp"));
        cond0.put(this.utils.jsonExt("orgnJobs", where.get("jobNo")), "1");
        HashMap cond1 = new HashMap();
        cond1.put("bizComp", where.get("jobComp"));
        cond1.put(this.utils.jsonExt("bizJobs", where.get("jobNo")), "1");
        HashMap cond2 = new HashMap();
        cond2.put("nodeComp", where.get("jobComp"));
        String val = "%\"nodeJob\": \"" + where.get("jobNo") + "\"%";
        cond2.put(this.utils.pHolder((Object)"nodeRules", "like"), val);
        if (this.aolai.exists("FF_ORGN", cond0) || this.aolai.exists("FF_BIZ", cond1) || this.aolai.exists("FF_NODE", cond2)) {
            throw new FailedException("cantRemove");
        }
        return this.aolai.delete("FF_JOB", where);
    }

    private String getDefaultRank(Object compId) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("rankComp", compId);
        where.put("rankMark", "1");
        Map result = this.aolai.findOne("FF_RANK", where);
        return result.containsKey("status") ? "" : (String)result.get("rankId");
    }

    public Map<String, Object> getRankList() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "rankComp");
        FlowUtil.likeCond(where, "rankName");
        return this.utils.success(this.rankGroupCount(where));
    }

    private List<Map<String, String>> rankGroupCount(Map<String, Object> where) {
        log.debug("getRankList...{}", where);
        String[] args = new String[]{null, "FF_RANK", "getRankList", "0"};
        List items = this.aolai.findAll(where, null, args);
        if (!items.isEmpty()) {
            HashMap<String, Object> cond = new HashMap<String, Object>();
            cond.put("empComp", where.get("rankComp"));
            cond.put("empState", "1");
            String[] keys = new String[]{"empRank"};
            List list = this.aolai.groupCount(null, "FF_EMPLOYEE", keys, cond);
            Map tmp = this.utils.list2Map(list, "empRank", "CNT");
            Iterator iterator = items.iterator();
            while (iterator.hasNext()) {
                Map item;
                String cnt = (String)tmp.get((item = (Map)iterator.next()).get("rankId"));
                item.put("rankCount", cnt == null ? "" : cnt);
            }
        }
        return items;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> addRank() {
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("rankComp", user.get("userComp"));
        String[] keys = new String[]{"rankId", "rankComp", "rankName"};
        if (this.aolai.exists("FF_RANK", this.utils.sameIf(data, keys))) {
            throw new FailedException("duplicateName");
        }
        data.put("rankOpUid", user.get("userId"));
        this.clearDefaultRank(data);
        return this.addRank(data);
    }

    private void clearDefaultRank(Map<String, Object> data) {
        if ("1".equals(data.get("rankMark"))) {
            HashMap<String, Object> cond = new HashMap<String, Object>();
            cond.put("rankComp", data.get("rankComp"));
            cond.put("rankMark", data.get("rankMark"));
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("rankMark", "0");
            this.aolai.update("FF_RANK", fields, cond);
        }
    }

    private Map<String, String> addRank(Map<String, Object> data) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("rankComp", data.get("rankComp"));
        int times = 2;
        while (times-- > 0) {
            int id = this.aolai.getMaxCode(null, "FF_RANK", "rankId", cond);
            data.put("rankId", String.format("%02d", id));
            try {
                return this.aolai.addRecord("FF_RANK", data);
            }
            catch (FailedException e) {
                throw new FailedException(e.getMessage());
            }
            catch (Exception e) {
                log.error("addRank...{}", (Object)e.getMessage());
            }
        }
        throw new FailedException("doFailed");
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> setRank() {
        String[] keys;
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("rankComp", user.get("userComp"));
        if (data.containsKey("rankName") && this.aolai.exists("FF_RANK", this.utils.sameIf(data, keys = new String[]{"rankId", "rankComp", "rankName"}))) {
            throw new FailedException("duplicateName");
        }
        data.put("rankOpUid", user.get("userId"));
        this.clearDefaultRank(data);
        return this.aolai.update("FF_RANK", data, this.utils.sameId(data, "rank"));
    }

    public Map<String, String> delRank() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "rankComp");
        HashMap cond = new HashMap();
        cond.put("empComp", where.get("rankComp"));
        cond.put("empRank", where.get("rankId"));
        if (this.aolai.exists("FF_EMPLOYEE", cond)) {
            throw new FailedException("cantRemove");
        }
        return this.aolai.delete("FF_RANK", where);
    }
}

