/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.soar.service.ZeroService;
import cn.ps1.soar.utils.FlowUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FlowService {
    @Autowired
    private AolaiService aolai;
    @Autowired
    private UtilsService utils;
    @Autowired
    private ZeroService zeroSvc;
    @Autowired
    private HttpServletRequest req;

    public Map<String, Object> getNodeList() {
        Map where = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        where.put("nodeComp", user.get("userComp"));
        return this.utils.success(this.getNodeList(where));
    }

    private List<Map<String, String>> getNodeList(Map<String, Object> where) {
        String[] args = new String[]{null, "FF_NODE", "", "0"};
        List items = this.aolai.findAll(where, null, args);
        if (items.isEmpty()) {
            String nodeComp = (String)where.get("nodeComp");
            String flowNo = (String)where.get("nodeFlowNo");
            where.put("nodeComp", "0");
            where.put("nodeFlowNo", "flowNo00");
            items = this.aolai.findAll(where, null, args);
            for (Map item : items) {
                item.put("nodeComp", nodeComp);
                item.put("nodeFlowNo", flowNo);
            }
        }
        return items;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> saveNodes() {
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("nodeComp", user.get("userComp"));
        Map<String, Object> where = FlowUtil.flowCond(data, "node", "task");
        if (this.aolai.exists(null, "FF_TASK", where)) {
            return this.utils.failed("cantUpdate");
        }
        String[] keys = ConfUtil.getValid((String)"saveNodeInfo").split(",|;");
        List nodes = this.utils.obj2List(data.get("nodeItems"));
        for (Map node : nodes) {
            if (!this.utils.availParams(node, keys) || !this.setNodeTier(node)) {
                return this.utils.invalidParams();
            }
            node.put("nodeComp", data.get("nodeComp"));
            node.put("nodeFlowNo", data.get("nodeFlowNo"));
            node.put("nodeOpUid", user.get("userId"));
            node.put("nodeRules", this.utils.obj2Str(node.get("nodeRules")));
            if (this.utils.isEmpty(node.get("nodeCreate"))) {
                node.put("nodeCreate", this.utils.today("yyyy-MM-dd HH:mm:ss"));
            }
            node.put("nodeUpdate", this.utils.today("yyyy-MM-dd HH:mm:ss"));
        }
        Map<String, Object> cond = FlowUtil.flowCond(data, "node", "node");
        this.aolai.delete(null, "FF_NODE", cond);
        return this.aolai.batchAdd(null, "FF_NODE", nodes, null, false);
    }

    private boolean setNodeTier(Map<String, Object> node) {
        String nodeNo;
        int nodeTier;
        int pTier = 0;
        String pNo = (String)node.get("nodeParent");
        if (pNo.length() > 1) {
            pTier = pNo.length() / 2;
        }
        if ((nodeTier = (nodeNo = (String)node.get("nodeNo")).length() / 2) != pTier + 1) {
            return false;
        }
        node.put("nodeTier", nodeTier);
        return true;
    }

    boolean notifyAll(List<Map<String, String>> nodes) {
        ArrayList<Map<String, String>> empList = new ArrayList<Map<String, String>>();
        for (Map<String, String> node : nodes) {
            if (!"0".equals(node.get("nodeStyle")) || !"0".equals(node.get("workState"))) continue;
            empList.add(node);
        }
        return this.zeroSvc.notifyAll(nodes.get(0).get("nodeComp"), empList);
    }

    boolean followProcess(Map<String, ?> taskInfo) {
        return this.zeroSvc.followProcess(taskInfo);
    }

    String workJoinNode() {
        return "FF_WORK JOIN FF_NODE";
    }

    List<Map<String, String>> getFlowNodes(Map<String, Object> params) {
        Map<String, Object> where = FlowUtil.flowCond(params, "task", "node");
        where.put("taskId", params.get("taskId"));
        Map<String, Map<String, String>> tables = this.nodesCond(params.get("taskId"));
        HashMap<String, String> order = new HashMap<String, String>();
        order.put("nodeNo", "ASC");
        order.put("workState", "DESC");
        return this.aolai.findAll(null, tables, "getFlowNodes", where, order);
    }

    private Map<String, Map<String, String>> nodesCond(Object taskId) {
        LinkedHashMap<String, Map<String, String>> tables = new LinkedHashMap<String, Map<String, String>>();
        tables.put("FF_NODE", null);
        String workTaskId = taskId == null ? "" : String.valueOf(taskId);
        HashMap<String, String> cond1 = new HashMap<String, String>();
        cond1.put("taskComp", "nodeComp");
        cond1.put("taskFlowNo", "nodeFlowNo");
        cond1.put("taskId", workTaskId);
        tables.put("FF_TASK", cond1);
        HashMap<String, String> cond2 = new HashMap<String, String>();
        cond2.put("workComp", "nodeComp");
        cond2.put("workNodeNo", "nodeNo");
        cond2.put("workTaskId", workTaskId);
        cond2.put("workIdx", "0");
        tables.put("FF_WORK", cond2);
        return tables;
    }
}

