/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.soar.dao.FlowDao;
import cn.ps1.soar.engine.FlowEngine;
import cn.ps1.soar.service.BizService;
import cn.ps1.soar.service.FlowService;
import cn.ps1.soar.service.OrgnService;
import cn.ps1.soar.service.TaskService;
import cn.ps1.soar.utils.FlowUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EventEmitter {
    private static Logger log = LoggerFactory.getLogger(EventEmitter.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private UtilsService utils;
    @Autowired
    private BizService bizSvc;
    @Autowired
    private FlowService flowSvc;
    @Autowired
    private OrgnService orgnSvc;
    @Autowired
    private TaskService taskSvc;
    @Autowired
    private FlowDao flowDao;
    @Autowired
    private HttpServletRequest req;
    private FlowEngine flowEngine;

    public Map<String, Object> saveTask() {
        Map<String, Object> params = this.taskSvc.initTaskParams();
        Map<String, String> sponsor = this.getSponsorInfo(params);
        this.setJsonData(params, "taskFormData");
        this.checkReadyTask(params);
        this.taskSvc.addNewTask(params, sponsor, "0");
        return this.utils.success(params.get("taskId"));
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object newWorkTask() {
        Map<String, Object> params = this.taskSvc.initTaskParams();
        Map<String, String> sponsor = this.getSponsorInfo(params);
        if (params.containsKey("taskMode")) {
            this.setJsonData(params, "taskMode");
        }
        Map<String, Object> formData = this.setJsonData(params, "taskFormData");
        formData.put("empInfo", sponsor);
        this.initFlowEngine(params, formData);
        return this.startTask(params, sponsor);
    }

    private Map<String, Object> setJsonData(Map<String, Object> params, String fieldKey) {
        Object obj = params.get(fieldKey);
        if (obj instanceof String) {
            return this.utils.json2Map(obj);
        }
        params.put(fieldKey, this.utils.obj2Str(obj));
        return this.utils.obj2Map(obj);
    }

    private <T> Map<String, String> getSponsorInfo(Map<String, T> params) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        if (!params.containsKey("taskEmpId")) {
            throw new FailedException();
        }
        where.put("orgnEmpId", params.get("taskEmpId"));
        if (params.containsKey("empSecty")) {
            where.put("empSecty", params.get("empSecty"));
        }
        where.put("i18n", params.get("i18n"));
        where.put("orgnComp", params.get("taskComp"));
        where.put("orgnDept", params.get("taskDept"));
        List<Map<String, String>> empList = this.orgnSvc.getEmpBy(where);
        if (empList.isEmpty()) {
            throw new FailedException("denyAccess");
        }
        return empList.get(0);
    }

    private void initFlowEngine(Map<String, Object> params, Map<String, Object> formData) {
        this.flowEngine = new FlowEngine(formData, this.flowSvc.getFlowNodes(params));
        this.flowEngine.setUserLang(params.get("i18n"));
    }

    private Map<String, Object> startTask(Map<String, Object> params, Map<String, String> sponsor) {
        this.flowEngine.findFirstNode();
        Map<String, Object> result = this.getCandidates(params);
        if (result != null) {
            return result;
        }
        if (this.checkReadyTask(params)) {
            this.incrApproveIdx(params);
        }
        List<Map<String, String>> workNodes = this.flowEngine.getWorkNodes();
        this.taskSvc.saveWorkNodes(params, workNodes);
        this.flowEngine.setWaitingNode(params);
        this.taskSvc.addNewTask(params, sponsor, "1");
        this.flowSvc.notifyAll(workNodes);
        if (this.flowEngine.isSucceed()) {
            params.put("taskState", "2");
            this.flowSvc.followProcess(params);
        }
        return this.utils.success(params.get("taskId"));
    }

    private Map<String, Object> getCandidates(Map<String, Object> params) {
        List<Map<String, Object>> candidates = this.flowEngine.getCandidates();
        if (!candidates.isEmpty()) {
            Object selectee = params.get("candidates");
            if (selectee == null) {
                return this.utils.success(candidates);
            }
            if (!this.matchCandidate(candidates, selectee)) {
                throw new FailedException();
            }
        }
        return null;
    }

    private boolean matchCandidate(List<Map<String, Object>> candidates, Object selectee) {
        List nodes = this.utils.obj2List(selectee);
        if (candidates.size() != nodes.size()) {
            return false;
        }
        int approverCount = 0;
        for (Map<String, Object> candidate : candidates) {
            Map node = this.utils.obj2Map(candidate.get("normalNode"));
            List empList = this.utils.obj2List(candidate.get("candidates"));
            String nodeNo = (String)node.get("nodeNo");
            Map params = this.utils.findIn(nodes, "nodeNo", nodeNo);
            if (params == null) continue;
            Map emp = this.utils.findIn(empList, "empId", (String)params.get("empId"));
            if (emp == null) {
                List list = this.utils.obj2List(params.get("approvers"));
                int count = 0;
                for (String empId : list) {
                    emp = this.utils.findIn(empList, "empId", empId);
                    if (emp == null) continue;
                    this.flowEngine.setNodeApprover(node, emp);
                    ++count;
                }
                if (count == 0) {
                    return false;
                }
            } else {
                this.flowEngine.setNodeApprover(node, emp);
            }
            ++approverCount;
        }
        return candidates.size() == approverCount;
    }

    private boolean checkReadyTask(Map<String, Object> params) {
        if (params.get("taskId") == null) {
            params.put("taskId", Digest.uuid8() + params.get("taskEmpId"));
            return false;
        }
        Map<String, String> taskInfo = this.taskSvc.getTaskInfo(params);
        Object userId = params.get("empSecty");
        if (!userId.equals(taskInfo.get("taskUid")) && !userId.equals(taskInfo.get("taskSecty"))) {
            throw new FailedException("", "taskUid");
        }
        String taskState = taskInfo.get("taskState");
        if (!("0".equals(taskState) || "5".equals(taskState) || "4".equals(taskState))) {
            throw new FailedException("", "taskState");
        }
        return true;
    }

    public List<Map<String, String>> getCandidatesBy(Map<String, String> node, Map<String, Object> formData) {
        Map sponsor = this.utils.obj2Map(formData.get("empInfo"));
        return this.getCandidates(node, sponsor);
    }

    private List<Map<String, String>> getCandidates(Map<String, String> node, Map<String, String> sponsor) {
        String deptId = sponsor.get("deptId");
        List rules = this.utils.json2List((Object)node.get("nodeRules"));
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Map rule : rules) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("i18n", this.flowEngine.getUserLang());
            if (rule.containsKey("employee")) {
                String empId = (String)rule.get("employee");
                if (this.utils.findIn(list, "empId", empId) != null) continue;
                where.put("empComp", node.get("nodeComp"));
                where.put("empId", rule.get("employee"));
                list.addAll(this.orgnSvc.getEmployee(where));
                continue;
            }
            where.put("orgnComp", node.get("nodeComp"));
            where.put("orgnJob", rule.get("nodeJob"));
            List<Map<String, String>> empList = this.orgnSvc.getEmpBy(where);
            if (empList.isEmpty()) continue;
            log.debug("approver...{}", empList.get(0));
            Map scope = this.utils.obj2Map(rule.get("nodeScope"));
            for (String key : scope.keySet()) {
                for (Map<String, String> approver : empList) {
                    String dept = approver.get("deptId");
                    if ("all".equals(key) && !deptId.startsWith(dept) || !"all".equals(key) && !this.matchRules(scope, key, approver, deptId)) continue;
                    this.addCandidate(list, approver, rule.get("nodeJob"));
                    log.debug("approver...{}", approver);
                }
            }
        }
        log.debug("Candidates...{}", list);
        return this.orgnSvc.setJobsName(list);
    }

    private boolean matchRules(Map<String, String> scope, String key, Map<String, String> emp, String deptId) {
        String val = String.valueOf(scope.get(key));
        if ("deptLevel".equals(key)) {
            int tier = Integer.parseInt(val);
            return emp.get("deptId").length() / FlowUtil.leafW() == tier;
        }
        if ("deptType".equals(key)) {
            return "0".equals(val) || emp.get(key).equals(val);
        }
        if ("sameDept".equals(key)) {
            return deptId.equals(emp.get("deptId"));
        }
        return scope.containsKey(key) && val.equals(emp.get(key));
    }

    private void addCandidate(List<Map<String, String>> list, Map<String, String> approver, Object job) {
        Map<String, String> jobs = new HashMap<String, String>();
        Map candidate = this.utils.findIn(list, "empId", approver.get("empId"));
        if (candidate == null) {
            list.add(approver);
        } else {
            approver = candidate;
            jobs = this.utils.json2Map(approver.get("orgnJobs"));
        }
        jobs.put((String)job, "1");
        approver.put("orgnJobs", this.utils.obj2Str(jobs));
    }

    public int getActionIdx(Map<String, String> node, Map<String, Object> form) {
        Map rules = this.utils.json2Map((Object)node.get("nodeRules"));
        StringJoiner jt = new StringJoiner(this.utils.quote(rules.get("joint"), " "));
        List event = this.utils.obj2List(rules.get("event"));
        for (String ev : event) {
            String[] arr;
            for (String str : arr = ev.split("\\{ *")) {
                String val;
                String[] key = str.split(" *\\}");
                if (key.length == 1 || !this.isValidExpr(key[1]) || !"".equals(val = this.getFormValue(form, key[0])) && !this.utils.isMatch(val, "\\w+") && !this.utils.isMatch(val, "[%0-9a-zA-Z\\u4e00-\\u9fa5]+")) continue;
                if (this.utils.isNumeric(val)) {
                    jt.add(val + key[1]);
                    continue;
                }
                jt.add(this.utils.quote((Object)val, "'") + key[1]);
            }
        }
        log.debug("> getActionIdx...{}", (Object)event);
        try {
            return this.flowDao.getActionIdx(jt.toString());
        }
        catch (Exception e) {
            log.warn("> getActionIdx...{}", (Object)event);
            return -1;
        }
    }

    private String getFormValue(Object obj, String keyStr) {
        String[] keys;
        for (String key : keys = keyStr.split("\\.")) {
            log.debug("> getFormValue...{}", obj);
            if (obj instanceof Map) {
                Map map = this.utils.obj2Map(obj);
                obj = map.get(key);
                continue;
            }
            obj = null;
        }
        return obj == null ? "" : String.valueOf(obj);
    }

    private boolean isValidExpr(String expr) {
        if (expr.length() > 0) {
            String[] arr;
            for (String str : arr = expr.split(" +")) {
                if (str.length() == 0 || this.utils.findIn(ConfUtil.SQL_EXPR, (Object)str.toLowerCase()) || this.utils.isNumeric(str) || this.utils.isMatch(str, "['%]*\\w+[%']*") || this.utils.isMatch(str, "'[%0-9a-zA-Z\\u4e00-\\u9fa5]+'")) continue;
                log.error("invalid expr...{}", (Object)str);
                return false;
            }
        }
        return true;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object approveNode() {
        Map<String, Object> params = this.taskSvc.getWorkParams();
        Map<String, String> task = this.taskSvc.getReadyTask(params);
        task.put("i18n", (String)params.get("i18n"));
        Map<String, String> sponsor = this.getSponsorInfo(task);
        Map formData = this.utils.json2Map((Object)task.get("taskFormData"));
        formData.put("empInfo", sponsor);
        this.initFlowEngine(params, formData);
        return this.approveNode(params, task);
    }

    private Object approveNode(Map<String, Object> params, Map<String, String> task) {
        this.flowEngine.confirmNode(params);
        Map<String, Object> result = this.getCandidates(params);
        if (result != null) {
            return result;
        }
        List<Map<String, String>> workNodes = this.flowEngine.getWorkNodes();
        this.taskSvc.saveWorkNodes(params, workNodes);
        this.flowEngine.setWaitingNode(params);
        this.taskSvc.setTaskState(params);
        this.skipParallelNodes(params);
        if (this.taskSvc.jointlyCompleted(this.flowEngine.getJointlyNode())) {
            throw new FailedException("isRollback");
        }
        this.flowSvc.notifyAll(workNodes);
        if (this.flowEngine.isSucceed()) {
            task.put("taskState", "2");
            this.flowSvc.followProcess(task);
        }
        return this.utils.success();
    }

    private void skipParallelNodes(Map<String, Object> where) {
        Set<String> skipNodes = this.flowEngine.getSkipNodes();
        if (!skipNodes.isEmpty()) {
            log.debug("> skipParallelNodes...{}", skipNodes);
            Map cond = this.utils.sameId(where, "task");
            cond.put("stateReady", "0");
            cond.put("stateSkip", "3");
            cond.put("skipNodes", skipNodes);
            this.flowDao.skipParallelNodes(this.flowSvc.workJoinNode(), cond);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object rejectNode() {
        Map<String, Object> params = this.taskSvc.getWorkParams();
        Map<String, String> task = this.taskSvc.getReadyTask(params);
        this.handleNode(params, "4");
        return this.rejectNode(params, task);
    }

    private Map<String, String> handleNode(Map<String, Object> params, String workState) {
        this.initFlowEngine(params, null);
        Object workNo = params.get("workNodeNo");
        Object empId = params.get("workEmpId");
        Map<String, String> theNode = null;
        for (Map<String, String> node : this.flowEngine.getFlowNodes()) {
            if (!"0".equals(node.get("workState"))) continue;
            if (empId.equals(node.get("workEmpId")) && node.get("nodeNo").equals(workNo)) {
                this.setAgentEmpty(params, node.get("workUid"));
                this.flowEngine.addWorkNode(node, workState);
                theNode = node;
                continue;
            }
            if (!"4".equals(workState)) continue;
            this.flowEngine.addSkipNode(node.get("nodeParent"));
        }
        if (theNode == null) {
            throw new FailedException("isLostWay");
        }
        return theNode;
    }

    private Object rejectNode(Map<String, Object> params, Map<String, String> task) {
        List<Map<String, String>> workNodes = this.flowEngine.getWorkNodes();
        this.taskSvc.saveWorkNodes(params, workNodes);
        params.put("taskState", "4");
        this.taskSvc.setTaskState(params);
        this.skipParallelNodes(params);
        task.put("taskState", "4");
        this.flowSvc.followProcess(task);
        return this.utils.success();
    }

    public void setAgentEmpty(Map<String, Object> params, String opUid) {
        Object agent = params.get("workAgent");
        if (agent != null && agent.equals(opUid)) {
            params.put("workAgent", "");
        }
    }

    private int incrApproveIdx(Map<String, Object> params) {
        Map<String, Object> where = this.taskSvc.workIf(params);
        where.put("workNodeNo", params.get("choseNodeNo"));
        return this.flowDao.incrApproveIdx("FF_WORK", where);
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object probeNode() {
        Map<String, Object> params = this.taskSvc.getWorkParams();
        this.taskSvc.getReadyTask(params);
        List<Map<String, String>> nodes = this.taskSvc.getNodeApprovers(params);
        if (nodes.isEmpty() || nodes.size() > 1) {
            throw new FailedException();
        }
        this.handleNode(params, "1");
        this.incrApproveIdx(params);
        for (Map<String, String> newNode : nodes) {
            this.setTraceInfo(newNode, "3", params);
            this.flowEngine.addWorkNode(newNode, "0");
        }
        return this.handover(params);
    }

    private void setTraceInfo(Map<String, String> newNode, String opType, Map<String, Object> params) {
        HashMap<String, Object> trace = new HashMap<String, Object>();
        trace.put("nodeNo", params.get("workNodeNo"));
        trace.put("empId", params.get("workEmpId"));
        trace.put("type", opType);
        newNode.put("workTrace", this.utils.obj2Str(trace));
        Object workNote = params.get("workNote");
        if (this.utils.isEmpty(workNote)) {
            workNote = params.get("workComment");
        }
        newNode.put("workNote", (String)workNote);
        newNode.put("workComment", "");
        newNode.put("workESign", "");
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object frontNode() {
        return this.handover("1", "3");
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object behindNode() {
        return this.handover("2", "1");
    }

    @Transactional(rollbackFor={Throwable.class})
    public Object forgoNode() {
        return this.handover("3", "0");
    }

    private Object handover(String workState, String opType) {
        Map<String, Object> params = this.taskSvc.getWorkParams();
        this.taskSvc.getReadyTask(params);
        Map<String, String> theNode = this.handleNode(params, workState);
        this.cloneNodeApprover(theNode, params, opType);
        return this.handover(params);
    }

    private Object handover(Map<String, Object> params) {
        List<Map<String, String>> workNodes = this.flowEngine.getWorkNodes();
        this.taskSvc.saveWorkNodes(params, workNodes);
        this.flowSvc.notifyAll(workNodes);
        return this.utils.success();
    }

    private void cloneNodeApprover(Map<String, String> theNode, Map<String, Object> params, String opType) {
        Object approver = params.get("employee");
        if (approver.equals(params.get("workEmpId"))) {
            throw new FailedException("", "employee");
        }
        Map newNode = this.utils.obj2Map(theNode);
        this.setTraceInfo(newNode, opType, params);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("i18n", this.flowEngine.getUserLang());
        where.put("empComp", newNode.get("nodeComp"));
        where.put("empId", approver);
        List<Map<String, String>> empList = this.orgnSvc.getEmployee(where);
        if (empList.isEmpty()) {
            throw new FailedException();
        }
        this.flowEngine.setNodeApprover(newNode, empList.get(0));
        this.flowEngine.addWorkNode(newNode, "0");
    }

    public Map<String, Object> getBizFlows() {
        Map<String, Object> params = this.bizSvc.getBizParams();
        return this.utils.success(this.getBizFlows(params));
    }

    private Map<String, String> getBizFlows(Map<String, Object> where) {
        where.put("orgnComp", where.get("bizComp"));
        List<Map<String, String>> empList = this.orgnSvc.getEmpBy(where);
        Map params = this.utils.sameNo(where, "biz");
        if (!this.utils.isEmpty(where.get("bizState"))) {
            params.put("bizState", where.get("bizState"));
        }
        return this.bizSvc.getBizFlows(params, empList);
    }

    public Map<String, Object> getBizModes() {
        Map<String, Object> params = this.bizSvc.getBizParams();
        Map<String, String> bizMap = this.getBizFlows(params);
        return this.utils.success(this.bizSvc.getBizModes(bizMap, params));
    }

    public Object flowPreview() {
        Map<String, String> sponsor;
        Map<String, Object> params = this.taskSvc.newTaskParams();
        if (params.containsKey("taskId")) {
            Map<String, String> task = this.taskSvc.getTaskInfo(params);
            params.put("taskFlowNo", task.get("taskFlowNo"));
            sponsor = this.getSponsorInfo(task);
        } else {
            String[] keys = new String[]{"taskFlowNo", "taskEmpId", "taskDept"};
            if (!this.utils.availParams(params, keys)) {
                throw new FailedException();
            }
            sponsor = this.getSponsorInfo(params);
        }
        List<Map<String, String>> nodes = this.flowSvc.getFlowNodes(params);
        this.flowEngine = new FlowEngine(null, null);
        this.flowEngine.setUserLang(params.get("i18n"));
        ArrayList<Map> list = new ArrayList<Map>();
        for (Map<String, String> node : nodes) {
            if (!"0".equals(node.get("nodeStyle"))) continue;
            Map item = this.utils.map2Obj(node);
            List<Map<String, String>> approvers = this.getCandidates(node, sponsor);
            item.put("candidates", this.getApprovers(approvers));
            list.add(item);
        }
        return this.utils.success(list);
    }

    private List<Map<String, String>> getApprovers(List<Map<String, String>> candidates) {
        ArrayList<Map<String, String>> approvers = new ArrayList<Map<String, String>>();
        for (Map<String, String> item : candidates) {
            HashMap<String, String> emp = new HashMap<String, String>();
            emp.put("deptName", item.get("deptName"));
            emp.put("empName", item.get("empName"));
            emp.put("orgnJobNames", item.get("orgnJobNames"));
            emp.put("empId", item.get("empId"));
            emp.put("empUid", item.get("empUid"));
            approvers.add(emp);
        }
        return approvers;
    }

    public List<Map<String, String>> choseApprovers(Map<String, String> node) {
        if (node.get("taskId") != null) {
            return this.taskSvc.choseApprovers(node);
        }
        return new ArrayList<Map<String, String>>();
    }
}

