/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.soar.service.ZeroService;
import cn.ps1.soar.utils.FlowUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CFormService {
    private static Logger log = LoggerFactory.getLogger(CFormService.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private UtilsService utils;
    @Autowired
    private ZeroService zeroSvc;
    @Autowired
    private HttpServletRequest req;

    public Map<String, String> saveCustomForm() {
        List<Map<String, Object>> rows = this.getFormData();
        Map user = this.utils.userSelf(this.req);
        String compId = (String)user.get("userComp");
        String formNo = Digest.uuid8();
        return this.saveCustomForm(compId, formNo, rows);
    }

    private List<Map<String, Object>> getFormData() {
        Map data = this.utils.jsonParams(this.req);
        List rows = this.utils.obj2List(data.get("list"));
        if (rows.isEmpty()) {
            throw new FailedException();
        }
        return rows;
    }

    private Map<String, String> saveCustomForm(String compId, String formNo, List<Map<String, Object>> rows) {
        String[] keys = ConfUtil.getValid((String)"customForm").split(",|;");
        int rowIdx = 0;
        for (Map<String, Object> row : rows) {
            row.put("formNo", formNo);
            if (!this.utils.availParams(row, keys)) {
                throw new FailedException();
            }
            row.put("formComp", compId);
            row.put("formIdx", rowIdx++);
        }
        Map result = this.aolai.batchAdd(null, "FF_FORM", rows, null, false);
        if (this.utils.isSuccess(result)) {
            return this.utils.success(formNo);
        }
        return result;
    }

    private boolean isFormUsed(Object formNo, String compId) {
        HashMap<String, Object> taskWhere = new HashMap<String, Object>();
        taskWhere.put(this.utils.jsonExt("taskMode", (Object)"modeFormNo"), formNo);
        taskWhere.put("taskComp", compId);
        return this.aolai.exists("FF_TASK", taskWhere);
    }

    private String updateForm(List<Map<String, Object>> rows, String compId) {
        Map result;
        String formNo = (String)rows.get(0).get("formNo");
        if (this.isFormUsed(formNo, compId)) {
            HashMap<String, String> cond = new HashMap<String, String>();
            cond.put("modeFormNo", formNo);
            cond.put("modeComp", compId);
            formNo = Digest.uuid8();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("modeFormNo", formNo);
            result = this.aolai.update("FF_MODE", data, cond);
        } else {
            HashMap<String, String> cond = new HashMap<String, String>();
            cond.put("formNo", formNo);
            cond.put("formComp", compId);
            result = this.aolai.delete("FF_FORM", cond);
        }
        if (this.utils.isFailed(result)) {
            throw new FailedException();
        }
        return formNo;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> setCustomForm() {
        List<Map<String, Object>> rows = this.getFormData();
        Map user = this.utils.userSelf(this.req);
        String compId = (String)user.get("userComp");
        String formNo = this.updateForm(rows, compId);
        return this.saveCustomForm(compId, formNo, rows);
    }

    public Map<String, String> delCustomForm() {
        Map params = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        String compId = (String)user.get("userComp");
        String formNo = (String)params.get("formNo");
        Map<String, String> where = new HashMap<String, String>();
        where.put("taskComp", compId);
        where.put(this.utils.jsonExt("taskMode", (Object)"modeFormNo"), formNo);
        if (this.aolai.exists(null, "FF_TASK", where)) {
            return this.utils.failed("cantRemove");
        }
        where = this.utils.sameNo(params, "form");
        return this.aolai.delete(null, "FF_FORM", where);
    }

    public Map<String, Object> getCustomForm() {
        Map params = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, params, "formComp");
        log.debug("-> getCustomForm...{}", (Object)params);
        HashMap<String, String> order = new HashMap<String, String>();
        order.put("formIdx", "ASC");
        String[] args = new String[]{null, "FF_FORM", "getCustomForm", "0"};
        return this.utils.success((Object)this.aolai.findAll(params, order, args));
    }

    public Map<String, Object> getCustomFormList() {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("formState", "1");
        where.put("formIdx", 0);
        HashMap<String, String> order = new HashMap<String, String>();
        order.put("formCreate", "DESC");
        String[] args = new String[]{null, "FF_FORM", "getCustomFormList", "0"};
        return this.utils.success((Object)this.aolai.findAll(where, order, args));
    }

    public Map<String, String> saveFormPart() {
        Map<String, Object> data = this.utils.jsonParams(this.req);
        data = FlowUtil.putParams(data, "addFormPart", "addEnumInfo");
        this.utils.setUserComp(this.req, data, "enumComp");
        return this.zeroSvc.addEnumInfo(data);
    }

    public Object getFormPart() {
        Map<String, Object> where = this.utils.jsonParams(this.req);
        where = FlowUtil.putParams(where, "getFormPart", "getEnumType");
        this.utils.setUserComp(this.req, where, "enumComp");
        Map<String, String> result = this.zeroSvc.getEnumInfo(where);
        if (result.containsKey("status")) {
            return result;
        }
        result = FlowUtil.putParams(result, "addEnumInfo", "addFormPart");
        return this.utils.success(result);
    }

    public Map<String, String> delFormPart() {
        Map<String, Object> where = this.utils.jsonParams(this.req);
        where = FlowUtil.putParams(where, "delFormPart", "delEnumInfo");
        this.utils.setUserComp(this.req, where, "enumComp");
        return this.zeroSvc.delEnumInfo(where);
    }
}

