/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.service;

import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.soar.utils.FlowUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizService {
    private static Logger log = LoggerFactory.getLogger(BizService.class);
    @Autowired
    private AolaiService aolai;
    @Autowired
    private UtilsService utils;
    @Autowired
    private HttpServletRequest req;

    public Object getBizList() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "bizComp");
        return this.utils.success(this.getBizList(where));
    }

    List<Map<String, String>> getBizList(Map<String, Object> where) {
        String[] bizRules;
        for (String key : bizRules = new String[]{"bizScope", "bizJobs"}) {
            Map map = this.utils.obj2Map(where.get(key));
            if (map.isEmpty()) continue;
            where.remove(key);
            Iterator iterator = map.keySet().iterator();
            String fieldKey = (String)iterator.next();
            String[] values = new String[]{"1", (String)map.get(fieldKey)};
            fieldKey = this.utils.jsonExt(key, (Object)fieldKey) + "{})";
            key = "(" + this.utils.jsonExt(key, (Object)"all") + "{} OR";
            where.put(key + fieldKey, values);
        }
        FlowUtil.invertCond(where, "bizState");
        log.debug("getBizList...{}", where);
        LinkedHashMap<String, String> order = new LinkedHashMap<String, String>();
        order.put("bizNo", "ASC");
        order.put("bizLevel", "DESC");
        String[] args = new String[]{null, "FF_BIZ", "", "0"};
        return this.aolai.findAll(where, order, args);
    }

    Map<String, String> getBizFlows(Map<String, Object> params, List<Map<String, String>> empList) {
        HashMap<String, String> bizMap = new HashMap<String, String>();
        List<Map<String, String>> bizList = this.getBizList(params);
        String[] keys = new String[]{"deptType", "deptLevel"};
        for (Map<String, String> biz : bizList) {
            if (bizMap.containsKey(biz.get("bizNo"))) continue;
            Map bizJobs = this.utils.json2Map((Object)biz.get("bizJobs"));
            Map bizScope = this.utils.json2Map((Object)biz.get("bizScope"));
            boolean isScope = false;
            boolean isJob = false;
            if (bizJobs.containsKey("all")) {
                isJob = true;
            }
            for (Map<String, String> emp : empList) {
                if (this.utils.isNil(bizScope.get("deptType"))) {
                    isScope = true;
                } else if (bizScope.get("deptId") != null && emp.get("deptId").startsWith((String)bizScope.get("deptId"))) {
                    isScope = true;
                } else {
                    for (String key : keys) {
                        if (!emp.get(key).equals(bizScope.get(key))) continue;
                        isScope = true;
                        break;
                    }
                }
                if (!isJob) {
                    Map empJobs = this.utils.json2Map((Object)emp.get("orgnJobs"));
                    for (String jobNo : empJobs.keySet()) {
                        if (!bizJobs.containsKey(jobNo)) continue;
                        isJob = true;
                        break;
                    }
                }
                if (!isJob || !isScope) continue;
                bizMap.put(biz.get("bizNo"), biz.get("bizFlowNo"));
            }
        }
        return bizMap;
    }

    public Map<String, String> addBiz() {
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("bizComp", user.get("userComp"));
        Map cond = this.utils.sameNo(data, "biz");
        if (!data.containsKey("bizLevel")) {
            int level = this.aolai.getMaxCode(null, "FF_BIZ", "bizLevel", cond);
            data.put("bizLevel", level);
        }
        cond.put("bizState", "1");
        cond.put("bizLevel", data.get("bizLevel"));
        this.setCheckRuleCond(data, cond);
        if (this.aolai.exists(null, "FF_BIZ", cond)) {
            throw new FailedException("dataDuplicate");
        }
        this.utils.resetState(data, "bizState");
        data.put("bizMark", "1");
        data.put("bizOpUid", user.get("userId"));
        return this.addBizFlowNo(data);
    }

    private Map<String, String> addBizFlowNo(Map<String, Object> data) {
        int times = 2;
        while (times-- > 0) {
            data.put("bizFlowNo", Digest.uuid8());
            try {
                return this.aolai.addRecord(null, "FF_BIZ", data);
            }
            catch (Exception e) {
                log.error("addBizFlowNo...{}", (Object)e.getMessage());
            }
        }
        throw new FailedException("doFailed");
    }

    public Map<String, String> setBiz() {
        Map data = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        data.put("bizComp", user.get("userComp"));
        Map cond = this.utils.sameNo(data, "biz");
        cond.put(this.utils.pHolder((Object)"bizFlowNo", "!="), data.get("bizFlowNo"));
        if ("1".equals(String.valueOf(data.get("bizState")))) {
            cond.put("bizState", "1");
            cond.put("bizLevel", data.get("bizLevel"));
        } else {
            cond.put(this.utils.pHolder((Object)"bizState", "!="), data.get("bizState"));
        }
        boolean mustCheck = this.setCheckRuleCond(data, cond);
        if (mustCheck && this.aolai.exists(null, "FF_BIZ", cond)) {
            throw new FailedException("dataDuplicate");
        }
        cond = this.utils.sameNo(data, "biz");
        cond.put("bizFlowNo", data.get("bizFlowNo"));
        cond.put(this.utils.pHolder((Object)"bizState", "!="), "2");
        this.utils.resetState(data, "bizState");
        data.put("bizOpUid", user.get("userId"));
        return this.aolai.update(null, "FF_BIZ", data, cond);
    }

    private boolean setCheckRuleCond(Map<String, Object> data, Map<String, Object> cond) {
        String[] bizRules;
        boolean mustCheck = false;
        for (String key : bizRules = new String[]{"bizScope", "bizJobs"}) {
            Map map = this.utils.obj2Map(data.get(key));
            if (map.isEmpty()) continue;
            data.put(key, this.utils.obj2Str((Object)map));
            Iterator iterator = map.keySet().iterator();
            String fieldKey = (String)iterator.next();
            String fieldValue = (String)map.get(fieldKey);
            fieldKey = "( " + this.utils.jsonExt(key, (Object)fieldKey) + "{})";
            cond.put(fieldKey, fieldValue);
            mustCheck = true;
        }
        if ("0".equals(data.get("bizState"))) {
            return false;
        }
        return mustCheck;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> delBiz() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "bizComp");
        return this.delBiz(where);
    }

    private Map<String, String> delBiz(Map<String, Object> where) {
        if (this.bizIsStarted(where)) {
            return this.utils.failed("cantRemove");
        }
        Map<String, String> result = this.delFlowNodes(where);
        log.debug("delFlowNodes...{}", result);
        where.put(this.utils.pHolder((Object)"bizState", "!="), "2");
        return this.aolai.delete(null, "FF_BIZ", where);
    }

    private <T> boolean bizIsStarted(Map<String, T> where) {
        Map<String, Object> cond = FlowUtil.flowCond(where, "biz", "task");
        return this.taskIsExist(cond);
    }

    private boolean taskIsExist(Map<String, Object> cond) {
        return this.aolai.exists(null, "FF_TASK", cond);
    }

    private <T> boolean taskIsStarted(Map<String, T> where, String key) {
        HashMap<String, Object> cond = new HashMap<String, Object>();
        cond.put("taskComp", where.get("modeComp"));
        cond.put(this.utils.jsonExt("taskMode", (Object)key), where.get(key));
        return this.taskIsExist(cond);
    }

    private <T> Map<String, String> delFlowNodes(Map<String, T> where) {
        Map<String, Object> cond = FlowUtil.flowCond(where, "biz", "node");
        return this.aolai.delete(null, "FF_NODE", cond);
    }

    public Map<String, Object> getModeList() {
        Map where = this.utils.jsonParams(this.req);
        this.utils.setUserComp(this.req, where, "modeComp");
        List<Map<String, String>> list = this.getModeList(where);
        return this.utils.success(list);
    }

    List<Map<String, String>> getModeList(Map<String, Object> where) {
        FlowUtil.likeCond(where, "modeName");
        FlowUtil.invertCond(where, "modeState");
        String[] args = new String[]{null, "FF_MODE", "getModeList", "0"};
        return this.aolai.findAll(where, null, args);
    }

    public Map<String, String> addMode() {
        Map mode = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        mode.put("modeComp", user.get("userComp"));
        mode.put("modeOpUid", user.get("userId"));
        String[] keys = new String[]{"modeId", "modeComp", "modeName", "modePid"};
        if (this.aolai.exists("FF_MODE", this.utils.sameIf(mode, keys))) {
            throw new FailedException("duplicateName");
        }
        this.utils.resetState(mode, "modeType");
        if (!"0".equals(mode.get("modePid"))) {
            Map<String, String> parent = this.getParentMode(mode);
            for (Map.Entry<String, String> e : parent.entrySet()) {
                if (mode.containsKey(e.getKey())) continue;
                mode.put(e.getKey(), e.getValue());
            }
        }
        mode.put("modeState", "1");
        return this.addMode(mode);
    }

    private Map<String, String> addMode(Map<String, Object> data) {
        int times = 2;
        while (times-- > 0) {
            String modeId = this.newModeId(data);
            data.put("modeTier", modeId.length() / 2);
            data.put("modeId", modeId);
            this.oneTierModeData(data, modeId);
            try {
                return this.aolai.addRecord(null, "FF_MODE", data);
            }
            catch (Exception e) {
                log.error("addMode...{}", (Object)e.getMessage());
            }
        }
        throw new FailedException("doFailed");
    }

    private void oneTierModeData(Map<String, Object> data, String id) {
        if (id.length() == 2) {
            data.put("modeInForm", "0");
            data.put("modeInFlow", "0");
            data.put("modeInTmpl", "0");
            data.put("modeFormNo", "formNo" + id);
            data.put("modeBizNo", "bizNo" + id);
            data.put("modeTmplNo", "tmplNo" + id);
            HashMap<String, Object> bizData = new HashMap<String, Object>();
            bizData.put("bizNo", data.get("modeBizNo"));
            bizData.put("bizComp", data.get("modeComp"));
            bizData.put("bizOpUid", data.get("modeOpUid"));
            bizData.put("bizFlowNo", "flowNo" + id);
            bizData.put("bizScope", "{\"deptType\":\"0\"}");
            bizData.put("bizJobs", "{\"all\":\"1\"}");
            this.aolai.addRecord(null, "FF_BIZ", bizData);
        }
    }

    private Map<String, String> getParentMode(Map<String, Object> mode) {
        Map parent;
        Map<String, Object> cond = FlowUtil.parent("mode", mode);
        if ("0".equals(cond.get("modeId"))) {
            cond.put("modeComp", "0");
        }
        if ((parent = this.aolai.findOne(null, "FF_MODE", cond, "getModeInfo")).containsKey("status") || "1".equals(parent.get("modeType"))) {
            throw new FailedException();
        }
        return parent;
    }

    public Map<String, String> moveMode() {
        Map mode = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        mode.put("modeComp", user.get("userComp"));
        Map cond = this.utils.sameId(mode, "mode");
        Map self = this.aolai.findOne(null, "FF_MODE", cond);
        mode.put("modeName", self.get("modeName"));
        String[] keys = new String[]{null, "modeComp", "modeName", "modePid"};
        if (this.aolai.exists(null, "FF_MODE", this.utils.sameIf(mode, keys))) {
            throw new FailedException("duplicateName");
        }
        Map<String, String> parent = this.getParentMode(mode);
        HashMap fields = new HashMap();
        fields.put("modeOpUid", user.get("userId"));
        fields.put("modeTag", parent.get("modeTag"));
        fields.put("modePid", parent.get("modeId"));
        if ("1".equals(self.get("modeInForm"))) {
            fields.put("modeFormNo", parent.get("modeFormNo"));
        }
        if ("1".equals(self.get("modeInTmpl"))) {
            fields.put("modeTmplNo", parent.get("modeTmplNo"));
        }
        if ("1".equals(self.get("modeInFlow"))) {
            fields.put("modeBizNo", parent.get("modeBizNo"));
        }
        String modeId = this.newModeId(mode);
        fields.put("modeId", modeId);
        fields.put("modeTier", modeId.length() / 2);
        return this.aolai.update(null, "FF_MODE", fields, cond);
    }

    private String newModeId(Map<String, Object> data) {
        Map<String, Object> cond = FlowUtil.brother("mode", data);
        int id = this.aolai.getMaxCode(null, "FF_MODE", "modeId", cond);
        return this.utils.idCode(data.get("modePid"), id, 2);
    }

    @Transactional
    public Map<String, String> delMode() {
        Map<String, Object> cond;
        Map where = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        where.put("modeComp", user.get("userComp"));
        Map<String, String> mode = this.getMode(where);
        if ("2".equals(mode.get("modeState"))) {
            throw new FailedException("cantRemove");
        }
        if (mode.containsKey("status")) {
            throw new FailedException();
        }
        if ("0".equals(mode.get("modeType")) && this.aolai.count(null, "FF_MODE", cond = FlowUtil.family("mode", where)) > 1) {
            throw new FailedException("cantRemove");
        }
        if (this.taskIsStarted(mode, "modeId")) {
            throw new FailedException("cantRemove");
        }
        if (!this.delLostData("modeBizNo", mode)) {
            throw new FailedException("cantRemove");
        }
        this.delLostData("modeFormNo", mode);
        this.delLostData("modeTmplNo", mode);
        return this.aolai.delete(null, "FF_MODE", where);
    }

    public Map<String, String> getMode(Map<String, Object> where) {
        Map cond = this.utils.sameId(where, "mode");
        return this.aolai.findOne(null, "FF_MODE", cond);
    }

    public Map<String, String> setMode() {
        Map params = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        params.put("modeComp", user.get("userComp"));
        String[] keys = new String[]{"modeName", "modeTag", "modeIdx", "modeIcon"};
        HashMap data = new HashMap();
        for (String key : keys) {
            if (!params.containsKey(key)) continue;
            data.put(key, params.get(key));
        }
        if (data.isEmpty()) {
            return this.utils.invalidParams();
        }
        String userId = (String)user.get("userId");
        data.put("modeOpUid", userId);
        if (data.containsKey("modeName") && this.aolai.exists(null, "FF_MODE", this.utils.sameIf(params, keys = new String[]{"modeId", "modePid", "modeComp", "modeName"}))) {
            throw new FailedException("duplicateName");
        }
        if (data.containsKey("modeTag")) {
            Map<String, Object> cond = FlowUtil.family("mode", params);
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("modeOpUid", userId);
            fields.put("modeTag", (String)data.get("modeTag"));
            this.aolai.update(null, "FF_MODE", fields, cond);
        }
        Map where = this.utils.sameId(params, "mode");
        this.aolai.update(null, "FF_MODE", data, where);
        return this.utils.success();
    }

    private void checkCanModifyState(Map<String, Object> params) {
        Map<String, Object> parent = FlowUtil.parent("mode", params);
        String[] values = new String[]{"1", "2"};
        parent.put(this.utils.pHolder((Object)"modeState", "in"), values);
        if (!this.aolai.exists("FF_MODE", parent)) {
            throw new FailedException("cantUpdate");
        }
    }

    public Map<String, String> setModeState() {
        Map result;
        Map params = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        params.put("modeComp", user.get("userComp"));
        String userId = (String)user.get("userId");
        this.utils.resetState(params, "modeState");
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("modeOpUid", userId);
        fields.put("modeState", (String)params.get("modeState"));
        Map where = this.utils.sameId(params, "mode");
        if ("0".equals(params.get("modeState"))) {
            Map<String, Object> cond = FlowUtil.family("mode", params);
            cond.put("modeState", "1");
            result = this.aolai.update(null, "FF_MODE", fields, cond);
        } else {
            this.checkCanModifyState(params);
            where.put("modeState", "0");
            result = this.aolai.update(null, "FF_MODE", fields, where);
        }
        if (this.utils.isSuccess(result)) {
            return this.utils.success();
        }
        return this.utils.invalidParams();
    }

    @Transactional(rollbackFor={Throwable.class})
    public Map<String, String> setInheritMode() {
        Map mode = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        mode.put("modeComp", user.get("userComp"));
        mode.put("modeOpUid", user.get("userId"));
        if (mode.containsKey("modeInForm") && mode.containsKey("modeFormNo")) {
            return this.inheritMode(mode, "modeInForm", "modeFormNo");
        }
        if (mode.containsKey("modeInFlow") && mode.containsKey("modeBizNo")) {
            return this.inheritMode(mode, "modeInFlow", "modeBizNo");
        }
        if (mode.containsKey("modeInTmpl") && mode.containsKey("modeTmplNo")) {
            return this.inheritMode(mode, "modeInTmpl", "modeTmplNo");
        }
        return this.utils.invalidParams();
    }

    private Map<String, String> inheritMode(Map<String, Object> mode, String inKey, String numKey) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("modeOpUid", mode.get("modeOpUid"));
        boolean isInherit = "1".equals(mode.get(inKey));
        if (isInherit) {
            if (!this.delLostData(numKey, mode)) {
                throw new FailedException("cantInherit");
            }
            Map<String, String> parent = this.getParentMode(mode);
            fields.put(numKey, parent.get(numKey));
        } else {
            fields.put(numKey, this.cloneMode(numKey, mode));
        }
        int len = String.valueOf(mode.get("modeId")).length();
        if (len / 2 < 3) {
            Map<String, Object> cond = FlowUtil.child("mode", mode);
            cond.put(inKey, "1");
            this.aolai.update(null, "FF_MODE", fields, cond);
        }
        Map where = this.utils.sameId(mode, "mode");
        where.put(inKey, isInherit ? "0" : "1");
        fields.put(inKey, isInherit ? "1" : "0");
        return this.aolai.update(null, "FF_MODE", fields, where);
    }

    private <T> boolean delLostData(String numKey, Map<String, T> mode) {
        if ("modeBizNo".equals(numKey)) {
            if ("1".equals(mode.get("modeInFlow"))) {
                return true;
            }
            Map<String, Object> where = FlowUtil.modeCond(mode, this.utils.initCap((Object)"biz"), "biz");
            List<Map<String, String>> items = this.getBizList(where);
            for (Map<String, String> biz : items) {
                if (!"1".equals(biz.get("bizMark"))) continue;
                if (this.bizIsStarted(biz)) {
                    return false;
                }
                this.delFlowNodes(biz);
            }
            this.aolai.delete(null, "FF_BIZ", where);
        } else if ("modeTmplNo".equals(numKey) && !this.taskIsStarted(mode, numKey)) {
            if ("1".equals(mode.get("modeInTmpl"))) {
                return true;
            }
            String uTmpl = this.utils.initCap((Object)"tmpl");
            Map<String, Object> where = FlowUtil.modeCond(mode, uTmpl, "tmpl");
            this.aolai.delete(null, "FF_TMPL", where);
        } else if ("modeFormNo".equals(numKey) && !this.taskIsStarted(mode, numKey)) {
            if ("1".equals(mode.get("modeInForm"))) {
                return true;
            }
            String uForm = this.utils.initCap((Object)"form");
            Map<String, Object> where = FlowUtil.modeCond(mode, uForm, "form");
            this.aolai.delete(null, "FF_FORM", where);
        }
        return true;
    }

    private String cloneMode(String numKey, Map<String, Object> mode) {
        if ("modeBizNo".equals(numKey)) {
            String uBiz = this.utils.initCap((Object)"biz");
            return this.cloneData(mode, "FF_BIZ", uBiz, "biz");
        }
        if ("modeFormNo".equals(numKey)) {
            String uForm = this.utils.initCap((Object)"form");
            return this.cloneData(mode, "FF_FORM", uForm, "form");
        }
        if ("modeTmplNo".equals(numKey)) {
            String uTmpl = this.utils.initCap((Object)"tmpl");
            return this.cloneData(mode, "FF_TMPL", uTmpl, "tmpl");
        }
        return Digest.uuid8();
    }

    private String cloneData(Map<String, Object> mode, String table, String src, String key) {
        Map<String, Object> cond = FlowUtil.modeCond(mode, src, key);
        cond.put(this.utils.pHolder((Object)(key + "State"), "!="), "0");
        String[] args = new String[]{null, table, "", "0"};
        List list = this.aolai.findAll(cond, null, args);
        String newItemNo = Digest.uuid8();
        if (!list.isEmpty()) {
            ArrayList<Map> items = new ArrayList<Map>();
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                item.put(key + "No", newItemNo);
                item.put(key + "State", "1");
                if ("biz".equals(key)) {
                    this.putBizItem(item, i);
                }
                item.put(key + "OpUid", (String)mode.get("modeOpUid"));
                items.add(this.utils.map2Obj(item));
            }
            try {
                this.aolai.batchAdd(null, table, items, null, false);
            }
            catch (Exception e) {
                throw new FailedException("doFailed");
            }
        }
        return newItemNo;
    }

    private void putBizItem(Map<String, String> item, int incr) {
        item.put("bizMark", "0");
        item.put("bizFlowNo", Digest.uuid8((int)incr));
    }

    List<Map<String, String>> getBizModes(Map<String, String> bizMap, Map<String, Object> params) {
        ArrayList<Map<String, String>> flowList = new ArrayList<Map<String, String>>();
        if (!bizMap.isEmpty()) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("modeComp", params.get("bizComp"));
            where.put(this.utils.pHolder((Object)"modeState", "!="), "0");
            if (!this.utils.isEmpty(params.get("modeId"))) {
                String key = this.utils.pHolder((Object)"modeId", "LIKE");
                where.put(key, params.get("modeId") + "%");
            }
            if (!this.utils.isEmpty(params.get("modeType"))) {
                where.put("modeType", params.get("modeType"));
            }
            List<Map<String, String>> modeList = this.getModeList(where);
            for (Map<String, String> mode : modeList) {
                String bizNo = mode.get("modeBizNo");
                if (!bizMap.containsKey(bizNo)) continue;
                mode.put("bizFlowNo", bizMap.get(bizNo));
                flowList.add(mode);
            }
        }
        return flowList;
    }

    Map<String, Object> getBizParams() {
        Map params = this.utils.jsonParams(this.req);
        Map user = this.utils.userSelf(this.req);
        params.put("bizComp", user.get("userComp"));
        if (params.containsKey("orgnEmpId")) {
            params.put("empId", params.get("orgnEmpId"));
        } else {
            params.put("empUid", user.get("userId"));
        }
        return params;
    }
}

