/*
 * Decompiled with CFR 0.152.
 */
package cn.ps1.soar.engine;

import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.SpringContext;
import cn.ps1.soar.service.EventEmitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowEngine {
    private List<Map<String, String>> flowNodes = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> workNodes = new ArrayList<Map<String, String>>();
    private List<Map<String, Object>> candidates = new ArrayList<Map<String, Object>>();
    private Map<String, Object> formData = new HashMap<String, Object>();
    private Set<String> skipNodes = new HashSet<String>();
    private Map<String, String> jointlyNode = null;
    private static EventEmitter event = (EventEmitter)SpringContext.getBean((String)"eventEmitter");
    private static UtilsService utils = (UtilsService)SpringContext.getBean((String)"utilsService");
    private boolean isSucceed = false;
    private Object userLang = "ZH";

    public void findFirstNode() {
        if (this.flowNodes.isEmpty()) {
            throw new FailedException("nodeNotExist");
        }
        this.pickWorkNode(this.flowNodes.get(0), "1");
    }

    private void pickWorkNode(Map<String, String> theNode, String pStyle) {
        String style = theNode.get("nodeStyle");
        if ("0".equals(style)) {
            this.pickCandidates(theNode, pStyle);
            return;
        }
        this.addWorkNode(theNode, "1");
        List<Map<String, String>> childs = this.getChildNode(theNode);
        if (childs.isEmpty()) {
            this.isLostWay();
        }
        if ("1".equals(style)) {
            this.pickWorkNode(childs.get(0), style);
        } else if ("2".equals(style)) {
            int actionIdx = event.getActionIdx(theNode, this.formData);
            if (actionIdx == -1 || actionIdx >= childs.size()) {
                this.isLostWay();
            }
            this.pickWorkNode(childs.get(actionIdx), style);
        } else if ("3".equals(style) || "5".equals(style)) {
            for (Map<String, String> child : childs) {
                this.pickWorkNode(child, style);
            }
        }
    }

    private void pickCandidates(Map<String, String> node, String pStyle) {
        List<Map<String, String>> candidateList = event.getCandidatesBy(node, this.formData);
        if (candidateList.size() == 1) {
            this.setNodeApprover(node, candidateList.get(0));
        } else if (candidateList.size() > 1) {
            String issue = node.get("nodeIssue");
            if ("1".equals(issue) || "2".equals(issue)) {
                List<Map<String, String>> list = event.choseApprovers(node);
                if (list.isEmpty()) {
                    HashMap<String, Object> candidate = new HashMap<String, Object>();
                    candidate.put("normalNode", node);
                    candidate.put("candidates", candidateList);
                    candidate.put("parentType", pStyle);
                    this.candidates.add(candidate);
                    return;
                }
                candidateList = list;
            }
            for (Map<String, String> approver : candidateList) {
                HashMap<String, String> sameNode = new HashMap<String, String>(node);
                this.setNodeApprover(sameNode, approver);
            }
        } else {
            this.isLostWay();
        }
    }

    public void setNodeApprover(Map<String, String> node, Map<String, String> emp) {
        String[] keys;
        node.put("workEmpId", emp.get("empId"));
        node.put("workEmpName", emp.get("empName"));
        node.put("workUid", emp.get("empUid"));
        for (String key : keys = new String[]{"Agent", "Mobi", "Mail", "Wechat"}) {
            node.put("work" + key, emp.get("emp" + key));
        }
        this.addWorkNode(node, "0");
    }

    public void confirmNode(Map<String, Object> params) {
        Object workNo = params.get("workNodeNo");
        for (Map<String, String> node : this.flowNodes) {
            if (!node.get("nodeNo").equals(workNo)) continue;
            String workState = node.get("workState");
            if (params.get("workEmpId").equals(node.get("workEmpId"))) {
                if ("0".equals(workState)) {
                    event.setAgentEmpty(params, node.get("workUid"));
                    this.pickNextNode(node);
                    continue;
                }
                if (!"3".equals(workState)) continue;
                throw new FailedException("lostChance");
            }
            if (!"0".equals(workState) || "3".equals(node.get("nodeIssue"))) continue;
            this.addWorkNode(node, "3");
        }
        if (this.workNodes.isEmpty()) {
            throw new FailedException();
        }
    }

    private void pickNextNode(Map<String, String> theNode) {
        this.addWorkNode(theNode, "2");
        Map<String, String> relatedNode = this.getRelatedNode(theNode);
        if (relatedNode != null) {
            this.addWorkNode(relatedNode, "0");
            return;
        }
        if ("3".equals(theNode.get("nodeIssue")) && !this.jointlyApproved(theNode)) {
            this.jointlyNode = theNode;
            return;
        }
        Map<String, String> parent = this.getParentNode(theNode);
        if (parent == null) {
            return;
        }
        String pStyle = parent.get("nodeStyle");
        if ("1".equals(pStyle)) {
            List<Map<String, String>> nodes = this.getChildNode(parent);
            String prevNo = theNode.get("nodeNo");
            for (int i = 0; i < nodes.size() - 1; ++i) {
                String nodeNo = nodes.get(i).get("nodeNo");
                Map<String, String> nextNode = nodes.get(i + 1);
                if (!prevNo.equals(nodeNo) || prevNo.equals(nextNode.get("nodeNo"))) continue;
                this.pickWorkNode(nextNode, pStyle);
                return;
            }
            this.isSucceed = "0".equals(parent.get("nodeParent"));
            if (this.isSucceed) {
                this.addWorkNode(parent, "2");
            } else {
                this.pickNextNode(parent);
            }
        } else if ("2".equals(pStyle)) {
            this.pickNextNode(parent);
        } else if ("3".equals(pStyle)) {
            if (this.jointlyApproved(parent, theNode)) {
                this.pickNextNode(parent);
            } else {
                this.jointlyNode = parent;
            }
        } else if ("5".equals(pStyle) && "1".equals(parent.get("workState"))) {
            this.addSkipNode(parent.get("nodeNo"));
            this.pickNextNode(parent);
        }
    }

    private boolean jointlyApproved(Map<String, String> parent, Map<String, String> theNode) {
        String parentNo = parent.get("nodeNo");
        String nodeNo = theNode.get("nodeNo");
        for (Map<String, String> node : this.flowNodes) {
            String state = node.get("workState");
            if (!node.get("nodeParent").equals(parentNo) || node.get("nodeNo").equals(nodeNo) || !"0".equals(state) && !"1".equals(state)) continue;
            return false;
        }
        return true;
    }

    private boolean jointlyApproved(Map<String, String> theNode) {
        String nodeNo = theNode.get("nodeNo");
        for (Map<String, String> node : this.flowNodes) {
            String state = node.get("workState");
            if (!node.get("nodeNo").equals(nodeNo) || !"0".equals(state) && !"1".equals(state)) continue;
            return false;
        }
        return true;
    }

    private List<Map<String, String>> getChildNode(Map<String, String> parentNode) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String parentNo = parentNode.get("nodeNo");
        for (Map<String, String> node : this.flowNodes) {
            if (!node.get("nodeParent").equals(parentNo)) continue;
            list.add(node);
        }
        return list;
    }

    private Map<String, String> getParentNode(Map<String, String> theNode) {
        return utils.findIn(this.flowNodes, "nodeNo", theNode.get("nodeParent"));
    }

    private Map<String, String> getRelatedNode(Map<String, String> theNode) {
        Map map;
        String trace = theNode.get("workTrace");
        if (trace != null && "3".equals((map = utils.json2Map((Object)trace)).get("type"))) {
            for (Map<String, String> node : this.flowNodes) {
                if (!((String)map.get("nodeNo")).equals(node.get("nodeNo")) || !((String)map.get("empId")).equals(node.get("workEmpId"))) continue;
                return node;
            }
        }
        return null;
    }

    public void addWorkNode(Map<String, String> theNode, String workState) {
        theNode.put("workState", workState);
        this.workNodes.add(theNode);
    }

    public void setWaitingNode(Map<String, Object> params) {
        Map<String, String> theNode = this.workNodes.get(0);
        for (Map<String, String> node : this.workNodes) {
            String state = node.get("workState");
            if (!"0".equals(state) && !"1".equals(state)) continue;
            theNode = node;
        }
        if (this.isSucceed) {
            params.put("taskState", "2");
        }
        params.put("taskNodeNo", theNode.get("nodeNo"));
    }

    public FlowEngine(Map<String, Object> formData, List<Map<String, String>> flowNodes) {
        this.formData = formData;
        this.flowNodes = flowNodes;
    }

    public void isLostWay() {
        throw new FailedException("isLostWay");
    }

    public boolean isSucceed() {
        return this.isSucceed;
    }

    public boolean addSkipNode(String nodeNo) {
        return this.skipNodes.add(nodeNo);
    }

    public Set<String> getSkipNodes() {
        return this.skipNodes;
    }

    public List<Map<String, String>> getFlowNodes() {
        return this.flowNodes;
    }

    public List<Map<String, String>> getWorkNodes() {
        return this.workNodes;
    }

    public List<Map<String, Object>> getCandidates() {
        return this.candidates;
    }

    public Map<String, String> getJointlyNode() {
        return this.jointlyNode;
    }

    public Object getUserLang() {
        return this.userLang;
    }

    public void setUserLang(Object userLang) {
        this.userLang = userLang;
    }
}

