package cn.ps1.soar.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Const;
import cn.ps1.soar.entity.Mode;

/**
 * 系统配置参数常量
 * 
 * @author Aolai
 *
 */
public class FlowUtil {

	private FlowUtil() {
		throw new IllegalStateException("Utility class");
	}

	/**
	 * 流程“死胡同”
	 */
	public static final String IS_LOST_WAY = "isLostWay";
	/**
	 * 后续业务逻辑处理失败
	 */
	public static final String FOLLOW_FAILED = "followFailed";
	/**
	 * 节点不存在
	 */
	public static final String NODE_IS_EMPTY = "nodeNotExist";
	/**
	 * 错过审批或撤销机会
	 */
	public static final String LOST_CHANCE = "lostChance";

	/**
	 * 未知系统错误："doFailed"
	 */
	public static final String DO_FAILED = "doFailed";

	/**
	 * 约定参数名：标准节点："normalNode"
	 */
	public static final String MORM_NODE = "normalNode";
	/**
	 * 返给前台的候选人一览
	 */
	public static final String CANDIDATES = "candidates";
	/**
	 * 前台提交的单一审批人："employee"
	 */
	public static final String EMPLOYEE = "employee"; // "approver";
	/**
	 * 前台提交的多个审批人："approvers"
	 */
	public static final String APPROVERS = "approvers";

	/**
	 * 抄送知会某些人："informSb"
	 */
	public static final String INFORM_SB = "informSb";

	public static final String STATE = "State";
	public static final String OPER = "OpUid";
	public static final String NO = "No";

	static final String FLOW_NO = "FlowNo";
	static final String COMP = "Comp";
	static final String PID = "Pid";
	static final String ID = "Id";

	/** 节点样式的6种类型：0.普通 1.串行(子流程) 2.条件 3.会签 5.并行 */
	
	/** 普通简单节点 */
	public static final String STYLE_NORMAL = "0"; // 普通简单节点
	/** 串行节点 */
	public static final String STYLE_SERIAL = "1"; // 串行节点
	/** 条件节点 */
	public static final String STYLE_CONDITION = "2"; // 条件节点
	/** 会签节点 */
	public static final String STYLE_JOINTLY = "3"; // 会签节点
	/** 并行节点 */
	public static final String STYLE_PARALLEL = "5"; // 并行节点

	/** 控制节点的7种状态：0.就绪（草稿） 1.处理中 2.完成 4.驳回 5.取消 */

	/** 就绪"0" */
	public static final String STATE_READY = "0"; // 就绪（草稿）
	/** 处理中"1" */
	public static final String STATE_WAITING = "1"; // 处理中
	/** 完成"2" */
	public static final String STATE_COMPLETE = "2"; // 完成
	/** 跳过"3" */
	public static final String STATE_SKIP = "3"; // 跳过或忽略：IGNORE
	/** 驳回"4" */
	public static final String STATE_REJECT = "4"; // 驳回
	/** 取消"5" */
	public static final String STATE_CANCEL = "5"; // 取消
	/** 删除作废"6" */
	public static final String STATE_DELETE = "6"; // 删除
	/** 空闲"9" */
	public static final String STATE_FUTURE = "9"; // 空闲状态，还没走到的节点状态

	/** 审批节点转移的4种类型 */

	/** 放弃并移交type:0 */
	public static final String OP_FORGO = "0";
	/** 后加签type:1 */
	public static final String OP_ASIGN = "1"; // LATER
	/** 追问及前加签type:3 */
	public static final String OP_PROBE = "3";
	/** 回退type:5 */
	public static final String OP_RETURN = "5";

	/** 签发处理的4种类型：0.发给所有人 1.仅一人 2.多人 3.所有人会签 */

	/** 发给所有人，任一人同意就行 */
	public static final String ISSUE_ANY = "0";
	/** 仅限任选一人 */
	public static final String ISSUE_ONE = "1";
	/** 仅限任选多人 */
	public static final String ISSUE_MORE = "2";
	/** 所有人会签 */
	public static final String ISSUE_FULL = "3"; // 全部同意

	/** 消息提醒的4种类型 */

	/** 不通知 */
	public static final String NOTICE_NONE = "0";
	/** 电子邮件通知 */
	public static final String NOTICE_MAIL = "1"; // 电子邮件通知
	/** 手机短信通知 */
	public static final String NOTICE_SMS = "2"; // 手机短信通知
	/** 微信消息通知 */
	public static final String NOTICE_WECHAT = "3"; // 微信消息

	// 尝试执行两次2次
	public static final int TRY_TIMES = 2; // 固定值
	// 业务模式按2位数一层
	public static final int MODE_TIER_W = 2; // 固定值
	// 流程节点按2位数一层
	public static final int NODE_TIER_W = 2; // 固定值

	// 部门按3位数一层
	static int deptTIERW = 0;

	/** 部门表名称 */
	static String deptTABLEN = null;

	static String preselect = null;

	/** 部门表名称 */
	public static int leafW() {
		if (deptTIERW == 0) {
			String w = ConfUtil.getConf("dept.tier.w", "3");
			deptTIERW = Pattern.matches("[1-9]", w) ? Integer.parseInt(w) : 3;
		}
		return deptTIERW;
	}

	/** 部门表名称 */
	public static String deptTable() {
		if (deptTABLEN == null)
			deptTABLEN = ConfUtil.getConf("dept.table", "FF_DEPT");
		return deptTABLEN;
	}

	/** 允许支持预选 */
	public static boolean canPreSelect() {
		if (preselect == null)
			preselect = ConfUtil.getConf("can.preselect", "");
		return preselect.length() > 0;
	}

	/**
	 * 参数转换
	 */
	public static <T> Map<String, T> putParams(Map<String, T> params,
			String key1, String key2) {
		String[] keys1 = ConfUtil.getValid(key1).split(ConfUtil.COMMA);
		String[] keys2 = ConfUtil.getValid(key2).split(ConfUtil.COMMA);
		for (int i = 0; i < keys2.length && i < keys1.length; i++) {
			if (keys2[i].equals(keys1[1]))
				continue;
			params.put(keys2[i], params.get(keys1[1]));
			params.remove(keys1[1]);
		}
		return params;
	}

	/**
	 * 流程、表单、模板编号转换
	 */
	public static <T> Map<String, Object> modeCond(Map<String, T> mode,
			String src, String key) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, mode.get(Mode.COMP));
		where.put(key + NO, mode.get(Mode.KEY + src + NO));
		return where;
	}

	/**
	 * 工作流编号查询条件转换
	 */
	public static <T> Map<String, Object> flowCond(Map<String, T> cond,
			String src, String key) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(src + COMP));
		where.put(key + FLOW_NO, cond.get(src + FLOW_NO));
		return where;
	}

	/**
	 * 调整like查询条件
	 */
	public static void likeCond(Map<String, Object> cond, String key) {
		if (cond.containsKey(key)) {
			cond.put(pHolder(key, Const.LIKE), "%" + cond.get(key) + "%");
			// 删除冗余的查询条件
			cond.remove(key);
		}
	}

	/**
	 * 因系统包含第三状态（2.系统预置不能禁用），因此需要：<br>
	 * 倒置查询条件，如果 state='1'\'2' >> 变换为 {state}!='0' <br>
	 */
	public static void invertCond(Map<String, Object> cond, String key) {
		Object state = cond.get(key);
		if (state != null && !Const.S_0.equals(state)) {
			// state=1\2
			cond.put(pHolder(key, Const.NEQ), Const.S_0);
			cond.remove(key);
		} else if (Const.ALL.equals(state)) {
			cond.remove(key);
		}
	}

	/**
	 * 同层级内数据的查询条件：brother
	 */
	public static <T> Map<String, Object> brother(String key,
			Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		where.put(key + PID, cond.get(key + PID));
		return where;
	}

	/**
	 * 父层级数据的查询条件：parent
	 */
	public static <T> Map<String, Object> parent(String key, Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		where.put(key + ID, cond.get(key + PID));
		return where;
	}

	/**
	 * 子层级数据的查询条件：child
	 */
	public static <T> Map<String, Object> child(String key, Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		where.put(key + PID, cond.get(key + ID));
		return where;
	}

	/**
	 * 当前级及子层级数据的查询条件：child
	 */
	public static <T> Map<String, Object> family(String key, Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		key += ID;
		where.put(pHolder(key, Const.LIKE), cond.get(key) + "%");
		return where;
	}

	/**
	 * 占位符处理
	 */
	private static String pHolder(Object key, String opr) {
		return "{" + key + "} " + opr;
	}

}
