package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.ZeroService;

/**
 * 共享第三服务接口
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.03.10
 * @since openjdk-1.8
 */
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class ZeroController {

	@Autowired
	private ZeroService zeroSvc;

	/**
	 * 获取枚举信息一览
	 */
	@PostMapping(path = "/addEnumInfo")
	public Object addEnumInfo() {
		return zeroSvc.addEnumInfo();
	}

	/**
	 * 删除一个自定义表单
	 */
	@PostMapping(path = "/delEnumInfo")
	public Object delEnumInfo() {
		return zeroSvc.delEnumInfo();
	}

	/**
	 * 获取枚举（数据分类类型）值
	 */
	@PostMapping(path = "/getEnumType")
	public Object getEnumType() {
		return zeroSvc.getEnumType();
	}

	/**
	 * 获取枚举信息一览
	 */
	@PostMapping(path = "/getEnumList")
	public Object getEnumList() {
		return zeroSvc.getEnumList();
	}

	/**
	 * 获取一条枚举信息
	 */
	@PostMapping(path = "/getEnumInfo")
	public Object getEnumInfo() {
		return zeroSvc.getEnumInfo();
	}

	/**
	 * 同步用户信息
	 */
	@PostMapping(path = "/syncUsers")
	public Object syncUsers() {
		return zeroSvc.syncUsers();
	}

	/**
	 * 同步部门信息
	 */
	@PostMapping(path = "/syncDepts")
	public Object syncDepts() {
		return zeroSvc.syncDepts();
	}

	/**
	 * 仅为了测试用
	 */
	@PostMapping(path = "/testBy")
	public Object testBy() {
		return zeroSvc.testBy();
	}

}
