package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.TaskService;

/**
 * 审批流程（任务）处理，（审批人视角）待办、已办、办结事项
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.02.17
 * @since openjdk-1.8
 */
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class TaskController {

	@Autowired
	private TaskService taskSvc;

	/**
	 * 我的待办（两种视角）、已办（审批人视角）、办结事项（发起人视角）
	 */
	@PostMapping(path = "/getTaskList")
	public Object getTaskList() {
		return taskSvc.getTaskList();
	}

	/**
	 * 获取抄送人员能查看的任务一览
	 */
	@PostMapping(path = "/getInformTasks")
	public Object getInformTasks() {
		return taskSvc.getInformTasks();
	}

	/**
	 * 获取审批流程中的抄送信息一览
	 */
	@PostMapping(path = "/getInformList")
	public Object getInformList() {
		return taskSvc.getInformList();
	}

	/**
	 * 单独获取当前选中任务的表单信息
	 */
	@PostMapping(path = "/getTaskInfo")
	public Object getTaskInfo() {
		return taskSvc.getTaskInfo();
	}

	/**
	 * 删除一个草稿（已撤回）工作任务（流程）
	 * <p>
	 * 限定条件：状态=5.已撤回的\0.草稿中的，才可以删除
	 */
	@PostMapping(path = "/delTask")
	public Object delTask() {
		return taskSvc.delTask();
	}

	/**
	 * 根据taskId取消一个审批中的任务，取消“审批中”的审批流程
	 */
	@PostMapping(path = "/cancelTask")
	public Object cancelTask() {
		return taskSvc.cancelTask();
	}

	/**
	 * 撤销上次执行的审批任务
	 */
	@PostMapping(path = "/undoTask")
	public Object undoTask() {
		return taskSvc.undoTask();
	}

	/**
	 * 获取审批流中的普通审批节点一览，查询条件：workTaskId
	 */
	@PostMapping(path = "/getWorkNodes")
	public Object getWorkNodes() {
		return taskSvc.getWorkNodes();
	}

	/**
	 * 保存预选好全部节点审批人
	 */
/*	@PostMapping(path = "/getNodeApprovers")
	public Object getNodeApprovers() {
		return taskSvc.getNodeApprovers();
	}*/

	/**
	 * 保存预选好全部节点审批人
	 */
	@PostMapping(path = "/choseApprovers")
	public Object choseApprovers() {
		return taskSvc.saveApprovers();
	}

}
