package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.OrgnService;

/**
 * 公司内部组织架构维护管理
 * <p>
 * 组织（Orgn）|部门（Division）|员工（Employee）|职责（Job）|职级（Rank）
 *  
 * @author Aolai
 * @version 1.0 $Date: 2023.12.30
 * @since openjdk-1.8
 */
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class OrgnController {

	@Autowired
	private OrgnService orgnSvc;

	/** 组织 */

	/**
	 * 同一个组织架构下，根据部门（orgnDept）查询所有用户、岗位数据一览
	 */
	@PostMapping(path = "/getEmpOfDept")
	public Object getEmpOfDept() {
		return orgnSvc.getEmpOfDept();
	}

	/**
	 * 同一个组织架构下，查询用户及所在部门数据一览
	 */
	@PostMapping(path = "/getEmpInDept")
	public Object getEmpInDept() {
		return orgnSvc.getEmpInDept();
	}

	/**
	 * 同一个组织架构下，根据岗位（orgnJob）查询用户及所在部门数据
	 */
	@PostMapping(path = "/getEmpByJob")
	public Object getEmpByJob() {
		return orgnSvc.getEmpByJob();
	}

	/**
	 * 增加一条员工的组织数据
	 */
	@PostMapping(path = "/addOrgn")
	public Object addOrgn() {
		return orgnSvc.addOrgn();
	}

	/**
	 * 删除一条员工的组织数据
	 */
	@PostMapping(path = "/delOrgn")
	public Object delOrgn() {
		return orgnSvc.delOrgn();
	}

	/** 部门 */

	/**
	 * 查询部门数据一览
	 */
	@PostMapping(path = "/getDivnList")
	public Object getDeptList() {
		return orgnSvc.getDeptList();
	}

	/**
	 * 新增加一条部门数据
	 */
	@PostMapping(path = "/addDivn")
	public Object addDept() {
		return orgnSvc.addDept();
	}

	/**
	 * 修改一条部门数据
	 */
	@PostMapping(path = "/setDivn")
	public Object setDept() {
		return orgnSvc.setDept();
	}

	/**
	 * 删除一条部门数据
	 */
	@PostMapping(path = "/delDivn")
	public Object delDept() {
		return orgnSvc.delDept();
	}

	/** 员工 */

	/**
	 * 查询员工数据及所在部门的信息一览
	 */
	@PostMapping(path = "/getEmpList")
	public Object getEmpList() {
		return orgnSvc.getEmpList();
	}

	/**
	 * 根据empId查询一个员工及关联部门的信息
	 */
	@PostMapping(path = "/getEmpInfo")
	public Object getEmpInfo() {
		return orgnSvc.getEmpInfo();
	}

	/**
	 * 新增加一条员工数据
	 */
	@PostMapping(path = "/addEmployee")
	public Object addEmployee() {
		return orgnSvc.addEmployee();
	}

	/**
	 * 修改一条员工数据
	 */
	@PostMapping(path = "/setEmployee")
	public Object setEmployee() {
		return orgnSvc.setEmployee();
	}

	/**
	 * 删除一条员工数据
	 */
	@PostMapping(path = "/delEmployee")
	public Object delEmployee() {
		return orgnSvc.delEmployee();
	}

	/** 岗位 */

	/**
	 * 查询岗位数据一览
	 */
	@PostMapping(path = "/getJobList")
	public Object getJobList() {
		return orgnSvc.getJobList();
	}

	/**
	 * 新增加一条岗位数据
	 */
	@PostMapping(path = "/addJob")
	public Object addJob() {
		return orgnSvc.addJob();
	}

	/**
	 * 修改一条岗位数据
	 */
	@PostMapping(path = "/setJob")
	public Object setJob() {
		return orgnSvc.setJob();
	}

	/**
	 * 删除一条岗位数据
	 */
	@PostMapping(path = "/delJob")
	public Object delJob() {
		return orgnSvc.delJob();
	}

	/** 职级 */

	/**
	 * 查询职级数据一览
	 */
	@PostMapping(path = "/getRankList")
	public Object getRankList() {
		return orgnSvc.getRankList();
	}

	/**
	 * 新增加一条职级数据
	 */
	@PostMapping(path = "/addRank")
	public Object addRank() {
		return orgnSvc.addRank();
	}

	/**
	 * 修改一条职级数据
	 */
	@PostMapping(path = "/setRank")
	public Object setRank() {
		return orgnSvc.setRank();
	}

	/**
	 * 删除一条职级数据
	 */
	@PostMapping(path = "/delRank")
	public Object delRank() {
		return orgnSvc.delRank();
	}

}
