package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.EventEmitter;

/**
 * 业务流程的触发事件处理
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.01.20
 * @since openjdk-1.8
 */
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class EventController {

	@Autowired
	private EventEmitter emitSvc;

	/**
	 * 暂存一个初始新任务为“草稿”，“待发起”的审批流程
	 */
	@PostMapping(path = "/saveTask")
	public Object saveTask() {
		return emitSvc.saveTask();
	}

	/**
	 * 初次发起流程时，可以先“保存”一条新“流程”
	 */
	@PostMapping(path = "/newWorkTask")
	public Object newWorkTask() {
		return emitSvc.newWorkTask();
	}

	/**
	 * 提交“新流程”，当选中“审核人”后，“提交”处理并返回结果
	 * <p>
	 * 注意：提交时必须携带candidates参数，否则无效
	 */
	@PostMapping(path = "/submitTask")
	public Object submitTask() {
		return emitSvc.newWorkTask();
	}

	/**
	 * 完成当前节点审批
	 */
	@PostMapping(path = "/approveNode")
	public Object approveNode() {
		return emitSvc.approveNode();
	}

	/**
	 * 完成当前节点审批
	 */
	@PostMapping(path = "/submitNode")
	public Object submitNode() {
		return emitSvc.approveNode();
	}

	/**
	 * 完成当前节点驳回
	 */
	@PostMapping(path = "/rejectNode")
	public Object rejectNode() {
		return emitSvc.rejectNode();
	}

	/**
	 * 在当前节点追问，回到指定的节点
	 */
	@PostMapping(path = "/probeNode")
	public Object probeNode() {
		return emitSvc.probeNode();
	}

	/**
	 * 在节点前驱加签，相当于在前面追加了一个审批人
	 */
	@PostMapping(path = "/frontNode")
	public Object frontNode() {
		return emitSvc.frontNode();
	}

	/**
	 * 在当前节点后加签，相当于在后面追加了一个审批人
	 */
	@PostMapping(path = "/behindNode")
	public Object behindNode() {
		return emitSvc.behindNode();
	}

	/**
	 * 当前节点任务移交给他人处理
	 */
	@PostMapping(path = "/forgoNode")
	public Object forgoNode() {
		return emitSvc.forgoNode();
	}

	/**
	 * 查询当前用户可发起的业务流程一览表
	 */
	@PostMapping(path = "/getBizFlows")
	public Object getBizFlows() {
		return emitSvc.getBizFlows();
	}

	/**
	 * 查询当前用户可发起的业务流程一览表
	 */
	@PostMapping(path = "/getBizModes")
	public Object getBizModes() {
		return emitSvc.getBizModes();
	}

	/**
	 * 发起的流程概览
	 */
	@PostMapping(path = "/flowPreview")
	public Object flowPreview() {
		return emitSvc.flowPreview();
	}

}
