package cn.ps1.soar.controller;

import cn.ps1.soar.service.CFormService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 自定义表单
 */
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class CFormController {

	@Autowired
	private CFormService cformSvc;

	/**
	 * 保存自定义表单数据
	 */
	@PostMapping(path = "/saveCustomForm")
	public Object saveCustomForm() {
		return cformSvc.saveCustomForm();
	}

	/**
	 * 修改一个自定义表单
	 */
	@PostMapping(path = "/setCustomForm")
	public Object setCustomForm() {
		return cformSvc.setCustomForm();
	}

	/**
	 * 删除一个自定义表单
	 */
	@PostMapping(path = "/delCustomForm")
	public Object delCustomForm() {
		return cformSvc.delCustomForm();
	}

	/**
	 * 获取一个自定义表单
	 */
	@PostMapping(path = "/getCustomForm")
	public Object getCustomForm() {
		return cformSvc.getCustomForm();
	}

	/**
	 * 获取自定义表单一览
	 */
	@PostMapping(path = "/getCustomFormList")
	public Object getCustomFormList() {
		return cformSvc.getCustomFormList();
	}

	/**
	 * 新增保存一个自定义表单部件
	 */
	@PostMapping(path = "/saveFormPart")
	public Object saveFormPart() {
		return cformSvc.saveFormPart();
	}

	/**
	 * 获取一个自定义部件组
	 */
	@PostMapping(path = "/getFormPart")
	public Object getFormPart() {
		return cformSvc.getFormPart();
	}

	/**
	 * 删除一个自定义部件组
	 */
	@PostMapping(path = "/delFormPart")
	public Object delFormPart() {
		return cformSvc.delFormPart();
	}

}
