package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.BizService;

/**
 * 业务模式的维护管理
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.01.07
 * @since openjdk-1.8
 */
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class BizController {

	@Autowired
	private BizService bizSvc;

	/** 业务模式 */

	/**
	 * 查询业务模式一览
	 */
	@PostMapping(path = "/getBizList")
	public Object getBizList() {
		return bizSvc.getBizList();
	}

	/**
	 * 新增加一条业务模式
	 */
	@PostMapping(path = "/addBiz")
	public Object addBiz() {
		return bizSvc.addBiz();
	}

	/**
	 * 修改一条业务模式，或关闭触发条件
	 */
	@PostMapping(path = "/setBiz")
	public Object setBiz() {
		return bizSvc.setBiz();
	}

	/**
	 * 删除一条业务模式
	 */
	@PostMapping(path = "/delBiz")
	public Object delBiz() {
		return bizSvc.delBiz();
	}

	/** 业务模式分组 */

	/**
	 * 查询业务模式分组一览
	 */
	@PostMapping(path = "/getModeList")
	public Object getModeList() {
		return bizSvc.getModeList();
	}

	/**
	 * 新增加一条业务模式分组
	 */
	@PostMapping(path = "/addMode")
	public Object addMode() {
		return bizSvc.addMode();
	}

	/**
	 * 移动一条业务模式到另一个分组
	 */
	@PostMapping(path = "/moveMode")
	public Object moveMode() {
		return bizSvc.moveMode();
	}

	/**
	 * 删除一条业务模式分组：modeId
	 */
	@PostMapping(path = "/delMode")
	public Object delMode() {
		return bizSvc.delMode();
	}

	/**
	 * 修改一条业务模式分组
	 */
	@PostMapping(path = "/setMode")
	public Object setMode() {
		return bizSvc.setMode();
	}

	/**
	 * 修改一条业务模式状态
	 */
	@PostMapping(path = "/setModeState")
	public Object setModeState() {
		return bizSvc.setModeState();
	}

	/**
	 * 只有二级、三级才可以开启或关闭继承模式：modeId,modePid
	 */
	@PostMapping(path = "/setInheritMode")
	public Object setInheritMode() {
		return bizSvc.setInheritMode();
	}

}
