package cn.ps1.soar.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.ps1.aolai.entity.Dept;
import cn.ps1.aolai.entity.User;
import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.HttpsService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.aolai.utils.SpringContext;
import cn.ps1.soar.entity.Define;
import cn.ps1.soar.entity.Emp;
import cn.ps1.soar.entity.Rank;
import cn.ps1.soar.entity.Task;
import cn.ps1.soar.utils.FlowUtil;

/**
 * 三方服务调用接口
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.03.10
 * @since openjdk-1.8
 */
@Service
public class ZeroService {

	private static Logger LOG = LoggerFactory.getLogger(ZeroService.class);

	// TODO：考虑与culai的DEPT整合

	/** 同步部门 */
	private static final String SYNCDEPT = "syncDepts";
	/** 同步用户 */
	private static final String SYNCUSER = "syncUsers";
	/** 同步部门、同步用户的最后时间 */
	private static final String LASTTIME = "lastTime";

	private static final String NOTICETYPE = "noticeTypes";

	private static final String FOLLOWPROC = "followProcess";

	@Autowired
	private AolaiService aolai;
	@Autowired
	private HttpsService https;
	@Autowired
	private UtilsService utils;

	@Autowired
	private OrgnService orgnSvc;

	// 三方接口服务映射关系
	Object zeroMix = null;

	/**
	 * 新增保存一条枚举信息，如：全部组织类型（deptTypes，syncUsers等）
	 */
	public Map<String, String> addEnumInfo(HttpServletRequest req) {
		Map<String, Object> data = utils.jsonParams(req);
		utils.setUserComp(req, data, Define.COMP);
		return addEnumInfo(data);
	}

	/**
	 * 新增保存一条枚举信息，如：全部组织类型（deptTypes，syncUsers等）
	 */
	Map<String, String> addEnumInfo(Map<String, Object> data) {
		return aolai.addRecord(null, Define.TABLE, data, true);
	}

	/**
	 * 删除一条枚举信息，如：全部组织类型（deptTypes，syncUsers等）
	 */
	public Map<String, String> delEnumInfo(HttpServletRequest req) {
		Map<String, Object> where = utils.jsonParams(req);
		utils.setUserComp(req, where, Define.COMP);
		return delEnumInfo(where);
	}

	/**
	 * 删除一条枚举信息
	 */
	Map<String, String> delEnumInfo(Map<String, Object> where) {
		return aolai.delete(null, Define.TABLE, where);
	}

	/**
	 * 获取当前应用的枚举参数，如：enumKey=“deptTypes”（全部组织类型）
	 */
	public Map<String, String> getEnumType(HttpServletRequest req) {
		Map<String, Object> where = utils.jsonParams(req);
		utils.setUserComp(req, where, Define.COMP);
		// 直接访问数据库获取：enumKey=“deptTypes”
		Map<String, String> result = getEnumInfo(where);
		if (result.containsKey(Define.VAL))
			return utils.success(result.get(Define.VAL));
		return result;
	}

	/**
	 * 获取枚举信息一览
	 */
	public List<Map<String, String>> getEnumList(HttpServletRequest req) {
		Map<String, Object> where = utils.jsonParams(req);
		utils.setUserComp(req, where, Define.COMP);
		String[] args = { null, Define.TABLE, null, Const.STR_0 };
		return aolai.findAll(where, null, args);
	}

	/**
	 * 从ENUM表中获取枚举信息
	 */
	public Object getEnumInfo(HttpServletRequest req) {
		Map<String, Object> where = utils.jsonParams(req);
		utils.setUserComp(req, where, Define.COMP);
		return utils.result(getEnumInfo(where));
	}

	/**
	 * 从ENUM表中获取枚举信息，如：全部组织类型（deptTypes，syncUsers等）
	 */
	Map<String, String> getEnumInfo(Map<String, Object> where) {
		return aolai.findOne(null, Define.TABLE, where);
	}

	/**
	 * 根据类名称获取当前接口的实例
	 */
	private Object newZeroMix(String name) {
		try {
			if (zeroMix == null)
				zeroMix = SpringContext.getBean(name);
			return zeroMix;
		} catch (Exception e) {
			e.printStackTrace();
			throw new FailedException();
		}
	}

	/**
	 * 发送消息接口
	 */
	public boolean notifyAll(String compId, List<Map<String, String>> empList) {
		/**
		 * 在enumTag中定义了三位二级制的整数，从低到高分别邮件短信微信通知<br>
		 * 可通过enumKey=noticeTypes获取通知参数
		 */
		Map<String, Object> where = new HashMap<>();
		where.put(Define.COMP, compId);
		where.put(Define.KEY, NOTICETYPE);

		// 获取“提醒类型”参数
		Map<String, String> map = getEnumInfo(where);
		// 提醒方式可以同时设置多种方式：
		// {"1":"zeroService;sendMail","2":"zeroService;sendSms","3":"..."}
		if (!map.containsKey(Const.STS)) {
			// 调用自定义服务xxxService:getSyncDatas，返回status状态及数据对象
			Object obj = doInvoke(map.get(Define.TAG), map.get(Define.VAL),
					empList);
			return utils.isSuccess(utils.obj2Map(obj));
		}
		return true;
	}

	/**
	 * 调用基于Aolai平台的服务接口，获取同步数据列表 <br>
	 * 可根据不同配置获取信息：用户ID\姓名\公司\城市\手机\邮箱<br>
	 * 接口名：apiName，如：syncUsers\getOperUsers，以下转换参数可以为空，为空时返回原值
	 * <p>
	 * 传入参数：{empState:"0", empComp:"2"}，userLock='0' userComp='2'<br>
	 * 参数转换：{"userLock":"empState","userComp":"empComp"}<br>
	 * <p>
	 * 响应参数转换：{"empId":"userId","empUid":"userId","empName":"userName","empComp":"userComp", ...}
	 */
	public Map<String, String> syncDatas(String table,
			Map<String, Object> apiCond, Map<String, Object> cond) {
		/**
		 * 根据请求条件中reqCond包含的方法名（enumKey=syncUsers），获取接口参数： <br>
		 * {parser:{A1:B1}, mapper:{}, host:{ticket,spec,url,method}}
		 */
		// 根据条件（ENUM_KEY=“syncUsers”）从ENUM表中获取枚举信息
		// ENUM_VAL={"host": {"url": "http://mytest.ps1.cn:8080/culai/w/getUserList",...
		Map<String, String> map = getEnumInfo(apiCond);
		if (map.containsKey(Const.STS))
			throw new FailedException();

		String lastTime = map.get(Define.NOTE);
		if (utils.isDatetime(lastTime, Const.DTF))
			cond.put(LASTTIME, lastTime);

		/** 调用getSyncDatas()获取（根据参数映射解析的）结果数据 */

		// 调用自定义服务xxxService:getSyncDatas()（内部又调用了getUserList）
		Object obj = doInvoke(map.get(Define.TAG), map.get(Define.VAL), cond);
		// 数据list转换
		List<Map<String, String>> datas = utils.obj2List(obj);

		// 数据无需同步
		if (datas.size() == 0)
			return utils.success();

		// 转换数据格式、并找出最新的时间值
		List<Map<String, Object>> items = new ArrayList<>();
		for (Map<String, String> item : datas) {
			if (!item.containsKey(LASTTIME))
				throw new FailedException();
			// 更新最新时间
			if (item.get(LASTTIME).compareTo(lastTime) > 0)
				lastTime = item.get(LASTTIME);
			items.add(utils.map2Obj(item));
		}

		// 更新数据
		map = aolai.batchAdd(null, table, items, apiCond.get(Const.I18N), true);
		// 更新时间戳
		if (utils.isSuccess(map)) {
			Map<String, Object> fields = new HashMap<>();
			fields.put(Define.NOTE, lastTime);
			return aolai.update(null, Define.TABLE, fields, apiCond);
		}
		return map;
	}

	/**
	 * 同步数据并处理Aolai平台的基础数据（如：getUserList用户、getDeptList部门等）<br>
	 * 获取数据List，并返回解析后的数据List
	 */
	public List<Map<String, String>> getSyncDatas(String jsonStr, Object obj) {
		// 对请求参数jsonStr字符串进行转换
		Map<String, Map<String, String>> args = utils.json2Map(jsonStr);
		obj = remoteInvoke(args, obj).get(Const.INFO);
		// 返回需要同步的数据一览
		return utils.mapParser(args.get("parser"), utils.obj2List(obj));
	}

	/**
	 * 调用本地自定义服务接口
	 */
	private Object doInvoke(String beanName, String args, Object cond) {
		// 调用方法（例如：xxxService:getSyncDatas）
		String[] func = beanName.split(Const.COLON);
		/**
		 * 根据（beanName=“zeroService”）判断内部、外部服务<br>
		 * 默认调用自定义service或aolai平台内部服务：zeroService
		 */
		try {
			/** 调用Aolai标准服务接口：xxxxService */
			// 例如：xxxxService
			zeroMix = newZeroMix(func[0]);
			Class<?>[] cls = { String.class, Object.class };
	
			// 例如调用：getSyncDatas
			Method m = zeroMix.getClass().getMethod(func[1], cls);
	
			// 返回数据一览
			return m.invoke(zeroMix, args, cond);
		} catch (Exception e) {
			LOG.error("doCall...", e);
			if (!utils.isEmpty(e.getMessage())) {
				throw new FailedException(e.getMessage());
			}
			Throwable cause = e.getCause();
			if (cause != null && !utils.isEmpty(cause.getMessage())) {
				throw new FailedException(cause.getMessage());
			}
			throw new FailedException();
		}
	}

	/**
	 * 调用远程第三方服务接口
	 * 
	 * @param args
	 * @param map
	 * @return Map
	 */
	private Map<String, Object> remoteInvoke(
			Map<String, Map<String, String>> args, Object map) {

		// 请求参数映射解析，cond为查询条件
		Map<String, Object> cond = utils.obj2Map(map);
		// newMap.put(e.getKey(), oldMap.get(e.getValue()));
		cond = utils.mapParser(args.get("mapper"), cond);
		LOG.debug("remoteInvoke...{}", cond);

		// 返回数据一览
		// 请求服务的地址如： "http://mytest.ps1.cn:8080/culai/w/getUserList"
		String res = https.httpPost(args.get("host"), cond);

		return utils.json2Map(res);
	}

	/**
	 * 调用远程第三方服务接口
	 * 
	 * @param jsonStr
	 * @param map
	 * @return Map
	 */
	public Map<String, Object> remoteInvoke(String jsonStr, Object map) {
		// 同步数据的请求参数
		return remoteInvoke(utils.json2Map(jsonStr), map);
	}

	/**
	 * 调用远程第三方服务接口
	 * 
	 * @param jsonStr
	 * @param map
	 * @return Map
	 * @deprecated 这个方法已被弃用，使用remoteInvoke()方法替代。
	 */
	public Map<String, Object> remoteInteface(String jsonStr, Object map) {
		// 同步数据的请求参数
		return remoteInvoke(utils.json2Map(jsonStr), map);
	}

	/**
	 * 同步用户信息
	 */
	public Map<String, String> syncUsers(HttpServletRequest req) {
		// 拉取三方用户数据
		// 更新数据后，再保存最新更新时间，并启用redis倒计时至下个时间点
		Map<String, Object> where = utils.jsonParams(req);
		String compId = utils.setUserComp(req, where, User.COMP);
		Map<String, Object> apiCond = new HashMap<>();
		apiCond.put(Define.COMP, compId);
		apiCond.put(Define.KEY, SYNCUSER);
		// 返回结果
		return syncDatas(Emp.TABLE, apiCond, where);
	}

	/**
	 * 同步部门信息
	 */
	public Map<String, String> syncDepts(HttpServletRequest req) {
		Map<String, Object> where = utils.jsonParams(req);
		String compId = utils.setUserComp(req, where, Dept.COMP);
		Map<String, Object> apiCond = new HashMap<>();
		apiCond.put(Define.COMP, compId);
		apiCond.put(Define.KEY, SYNCDEPT);
		// 返回结果
		return syncDatas(FlowUtil.dept(), apiCond, where);
	}

	/**
	 * @deprecated 这个方法仅为了测试用
	 */
	public Map<String, String> testBy(HttpServletRequest req) {
		Map<String, Object> params = utils.jsonParams(req);
		Map<String, String> user = utils.userSelf(req);

		Map<String, Object> where = new HashMap<>();
		where.put(Rank.COMP, user.get(User.COMP));
		int id = aolai.getMaxCode(null, Rank.TABLE, Rank.ID, where);
		System.out.println("------testBy...id=" + id);

		where.put(Rank.ID, "SS");
		List<Map<String, String>> list = aolai.findList(Rank.TABLE, where);
		id = list.size();
System.out.println("------list.size()..." + id);

//		Map<String, Object> apiCond = new HashMap<>();
//		apiCond.put(Define.COMP, params.get(Emp.COMP));
//		apiCond.put(Define.KEY, SYNCUSER); // 同步用户数据"syncUsers"
//		// 返回请求结果
//		return syncDatas(Emp.TABLE, apiCond, params);
		return utils.success(String.valueOf(id));
	}

	/**
	 * 审批完成或驳回后的业务回调
	 */
	boolean followProcess(Map<String, ?> taskInfo) {

		Map<String, Object> where = new HashMap<>();
		where.put(Define.COMP, taskInfo.get(Task.COMP));
		where.put(Define.KEY, FOLLOWPROC);

		// 查询配置的回调方法，一个服务配置一条即可，回调统一的方法
		Map<String, String> map = getEnumInfo(where);

		if (!map.containsKey(Const.STS)) {
			// 调用自定义服务（如xxxService:getSyncDatas），根据返回status状态及数据对象
			Object obj = doInvoke(map.get(Define.TAG), map.get(Define.VAL),
					taskInfo);
			// 后续业务处理失败，流程回滚
			if (!utils.isSuccess(utils.obj2Map(obj))) {
				throw new FailedException(FlowUtil.FOLLOW_FAILED);
			}
		}
		return true;
	}

}
