package cn.ps1.soar.service;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.ps1.aolai.entity.User;
import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.Const;
import cn.ps1.soar.entity.Tmpl;

/**
 * 打印模板管理
 * 
 * @author Yujf
 * @version 1.0 $Date: 2024.05.11
 * @since openjdk-1.8
 */
@Service
public class TmplService {


	@Autowired
	private AolaiService aolai;
	@Autowired
	private UtilsService utils;

	/** 业务模式与流程的关联关系处理 */

	/**
	 * 根据模板id（tempNo）查询打印模板
	 */
	public Object getTmplList(HttpServletRequest req) {
		// 请求参数、当前用户信息
		Map<String, Object> where = utils.jsonParams(req);
		utils.setUserComp(req, where, Tmpl.COMP);
		// 查询条件：bizComp、bizNo
		return utils.success(getTmplList(where));
	}

	/**
	 * 获取当前业务类型的打印模板 <br>
	 * 查询条件：tempComp、tempNo
	 */
	List<Map<String, String>> getTmplList(Map<String, Object> where) {
		String[] args = { null, Tmpl.TABLE, "", Const.STR_0 };
		return aolai.findAll(where, null, args);
	}

	/**
	 * 修改一条触发条件（业务模式关联的流程），或关闭触发条件
	 */
	public Map<String, String> setTmpl(HttpServletRequest req) {
		// 请求参数、当前操作用户
		Map<String, Object> data = utils.jsonParams(req);
		Map<String, String> user = utils.userSelf(req);
		data.put(Tmpl.COMP, user.get(User.COMP));

		// 检查重复数据：排除当前业务流程：bizFlowNo
		Map<String, Object> cond = utils.sameNo(data, Tmpl.KEY);

		// 当前操作用户
		data.put(Tmpl.OPUID, user.get(User.ID));
		// 修改一条业务模式关联的流程
		return aolai.update(null, Tmpl.TABLE, data, cond);
	}

}
