package cn.ps1.soar.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.TmplService;

/**
 * 打印模板的维护管理
 * 
 * @author Yujf
 * @version 1.0 $Date: 2024.05.11
 * @since openjdk-1.8
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class TmplController {

	@Autowired
	private TmplService tmplSvc;

	/** 打印模板 */

	/**
	 * 查询打印模板一览
	 */
	@RequestMapping(value = "/getTmplList", method = RequestMethod.POST)
	public Object getTmplList(HttpServletRequest req) {
		return tmplSvc.getTmplList(req);
	}



	/**
	 * 修改一条打印模板
	 */
	@RequestMapping(value = "/setTmpl", method = RequestMethod.POST)
	public Object setTmpl(HttpServletRequest req) {
		return tmplSvc.setTmpl(req);
	}


}
