package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.TaskService;

import javax.servlet.http.HttpServletRequest;

/**
 * 审批流程（任务）处理，（审批人视角）待办、已办、办结事项
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.02.17
 * @since openjdk-1.8
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class TaskController {

	@Autowired
	private TaskService taskSvc;

	/**
	 * 我的待办（两种视角）、已办（审批人视角）、办结事项（发起人视角）
	 */
	@RequestMapping(value = "/getTaskList", method = RequestMethod.POST)
	public Object getTaskList(HttpServletRequest req) {
		return taskSvc.getTaskList(req);
	}

	/**
	 * 单独获取当前选中任务的表单信息
	 */
	@RequestMapping(value = "/getTaskInfo", method = RequestMethod.POST)
	public Object getTaskInfo(HttpServletRequest req) {
		return taskSvc.getTaskInfo(req);
	}

	/**
	 * 删除一个草稿（已撤回）工作任务（流程）
	 * <p>
	 * 限定条件：状态=5.已撤回的\0.草稿中的，才可以删除
	 */
	@RequestMapping(value = "/delTask", method = RequestMethod.POST)
	public Object delTask(HttpServletRequest req) {
		return taskSvc.delTask(req);
	}

	/**
	 * 获取审批流中的普通审批节点一览，查询条件：workTaskId
	 */
	@RequestMapping(value = "/getWorkNodes", method = RequestMethod.POST)
	public Object getWorkNodes(HttpServletRequest req) {
		return taskSvc.getWorkNodes(req);
	}

}
