package cn.ps1.soar.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.EventEmitter;

import javax.servlet.http.HttpServletRequest;

/**
 * 业务流程的触发事件处理
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.01.20
 * @since openjdk-1.8
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class EventController {

	@Autowired
	private EventEmitter emitSvc;

	/**
	 * 暂存一个初始新任务为“草稿”，“待发起”的审批流程
	 */
	@RequestMapping(value = "/saveTask", method = RequestMethod.POST)
	public Object saveTask(HttpServletRequest req) {
		return emitSvc.saveTask(req);
	}

	/**
	 * 初次发起流程时，可以先“保存”一条新“流程”
	 */
	@RequestMapping(value = "/newWorkTask", method = RequestMethod.POST)
	public Object newWorkTask(HttpServletRequest req) {
		return emitSvc.newWorkTask(req);
	}

	/**
	 * 提交“新流程”，当选中“审核人”后，“提交”处理并返回结果
	 * <p>
	 * 注意：提交时必须携带candidates参数，否则无效
	 */
	@RequestMapping(value = "/submitTask", method = RequestMethod.POST)
	public Object submitTask(HttpServletRequest req) {
		return emitSvc.newWorkTask(req);
	}

	/**
	 * 完成当前节点审批
	 */
	@RequestMapping(value = "/approveNode", method = RequestMethod.POST)
	public Object approveNode(HttpServletRequest req) {
		return emitSvc.approveNode(req);
	}

	/**
	 * 完成当前节点审批
	 */
	@RequestMapping(value = "/submitNode", method = RequestMethod.POST)
	public Object submitNode(HttpServletRequest req) {
		return emitSvc.approveNode(req);
	}

	/**
	 * 在当前节点加签，相当于追加了一个审批人
	 */
	@RequestMapping(value = "/addApprover", method = RequestMethod.POST)
	public Object addApprover(HttpServletRequest req) {
		return emitSvc.addApprover(req);
	}

	/**
	 * 完成当前节点驳回
	 */
	@RequestMapping(value = "/rejectNode", method = RequestMethod.POST)
	public Object rejectNode(HttpServletRequest req) {
		return emitSvc.rejectNode(req);
	}

	/**
	 * 根据taskId撤销一个审批中的任务，取消“审批中”的审批流程
	 */
	@RequestMapping(value = "/cancelTask", method = RequestMethod.POST)
	public Object cancelTask(HttpServletRequest req) {
		return emitSvc.cancelTask(req);
	}

	/**
	 * 查询当前用户可发起的业务流程一览表
	 */
	@RequestMapping(value = "/getBizFlows", method = RequestMethod.POST)
	public Object getBizFlows(HttpServletRequest req) {
		return emitSvc.getBizFlows(req);
	}

	/**
	 * 查询当前用户可发起的业务流程一览表
	 */
	@RequestMapping(value = "/getBizModes", method = RequestMethod.POST)
	public Object getBizModes(HttpServletRequest req) {
		return emitSvc.getBizModes(req);
	}

}
