package cn.ps1.soar.controller;

import cn.ps1.soar.service.CFormService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 自定义表单
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class CFormController {

	@Autowired
	private CFormService cformSvc;

	/**
	 * 保存自定义表单数据
	 */
	@RequestMapping(value = "/saveCustomForm", method = RequestMethod.POST)
	public Object saveCustomForm(HttpServletRequest req) {
		return cformSvc.saveCustomForm(req);
	}

	/**
	 * 修改一个自定义表单
	 */
	@RequestMapping(value = "/setCustomForm", method = RequestMethod.POST)
	public Object setCustomForm(HttpServletRequest req) {
		return cformSvc.setCustomForm(req);
	}

	/**
	 * 删除一个自定义表单
	 */
	@RequestMapping(value = "/delCustomForm", method = RequestMethod.POST)
	public Object delCustomForm(HttpServletRequest req) {
		return cformSvc.delCustomForm(req);
	}

	/**
	 * 获取一个自定义表单
	 */
	@RequestMapping(value = "/getCustomForm", method = RequestMethod.POST)
	public Object getCustomForm(HttpServletRequest req) {
		return cformSvc.getCustomForm(req);
	}

	/**
	 * 获取自定义表单一览
	 */
	@RequestMapping(value = "/getCustomFormList", method = RequestMethod.POST)
	public Object getCustomFormList(HttpServletRequest req) {
		return cformSvc.getCustomFormList();
	}

	/**
	 * 新增保存一个自定义表单部件
	 */
	@RequestMapping(value = "/saveFormPart", method = RequestMethod.POST)
	public Object saveFormPart(HttpServletRequest req) {
		return cformSvc.saveFormPart(req);
	}

	/**
	 * 获取一个自定义部件组
	 */
	@RequestMapping(value = "/getFormPart", method = RequestMethod.POST)
	public Object getFormPart(HttpServletRequest req) {
		return cformSvc.getFormPart(req);
	}

	/**
	 * 删除一个自定义部件组
	 */
	@RequestMapping(value = "/delFormPart", method = RequestMethod.POST)
	public Object delFormPart(HttpServletRequest req) {
		return cformSvc.delFormPart(req);
	}

}
