package cn.ps1.soar.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.BizService;

/**
 * 业务模式的维护管理
 * 
 * @author Aolai
 * @version 1.0 $Date: 2024.01.07
 * @since openjdk-1.8
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class BizController {

	@Autowired
	private BizService bizSvc;

	/** 业务模式 */

	/**
	 * 查询业务模式一览
	 */
	@RequestMapping(value = "/getBizList", method = RequestMethod.POST)
	public Object getBizList(HttpServletRequest req) {
		return bizSvc.getBizList(req);
	}

	/**
	 * 新增加一条业务模式
	 */
	@RequestMapping(value = "/addBiz", method = RequestMethod.POST)
	public Object addBiz(HttpServletRequest req) {
		return bizSvc.addBiz(req);
	}

	/**
	 * 修改一条业务模式，或关闭触发条件
	 */
	@RequestMapping(value = "/setBiz", method = RequestMethod.POST)
	public Object setBiz(HttpServletRequest req) {
		return bizSvc.setBiz(req);
	}

	/**
	 * 删除一条业务模式
	 */
	@RequestMapping(value = "/delBiz", method = RequestMethod.POST)
	public Object delBiz(HttpServletRequest req) {
		return bizSvc.delBiz(req);
	}

	/** 业务模式分组 */

	/**
	 * 查询业务模式分组一览
	 */
	@RequestMapping(value = "/getModeList", method = RequestMethod.POST)
	public Object getModeList(HttpServletRequest req) {
		return bizSvc.getModeList(req);
	}

	/**
	 * 新增加一条业务模式分组
	 */
	@RequestMapping(value = "/addMode", method = RequestMethod.POST)
	public Object addMode(HttpServletRequest req) {
		return bizSvc.addMode(req);
	}

	/**
	 * 移动一条业务模式到另一个分组
	 */
	@RequestMapping(value = "/moveMode", method = RequestMethod.POST)
	public Object moveMode(HttpServletRequest req) {
		return bizSvc.moveMode(req);
	}

	/**
	 * 删除一条业务模式分组：modeId
	 */
	@RequestMapping(value = "/delMode", method = RequestMethod.POST)
	public Object delMode(HttpServletRequest req) {
		return bizSvc.delMode(req);
	}

	/**
	 * 修改一条业务模式分组
	 */
	@RequestMapping(value = "/setMode", method = RequestMethod.POST)
	public Object setMode(HttpServletRequest req) {
		return bizSvc.setMode(req);
	}

	/**
	 * 修改一条业务模式状态
	 */
	@RequestMapping(value = "/setModeState", method = RequestMethod.POST)
	public Object setModeState(HttpServletRequest req) {
		return bizSvc.setModeState(req);
	}

	/**
	 * 只有二级、三级才可以开启或关闭继承模式：modeId,modePid
	 */
	@RequestMapping(value = "/setInheritMode", method = RequestMethod.POST)
	public Object setInheritMode(HttpServletRequest req) {
		return bizSvc.setInheritMode(req);
	}

}
