package cn.ps1.soar.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Const;
import cn.ps1.soar.entity.Mode;

/**
 * 系统配置参数常量
 * 
 * @author fulin
 *
 */
public class FlowUtil {

	/** 重复命名 */
	public static final String DUPL_DATA = "dataDuplicate";
	public static final String IS_LOST_WAY = "isLostWay";
	/** 后续业务处理失败 */
	public static final String FOLLOW_FAILED = "followFailed";

	public static final String FLOWNO = "FlowNo";
	public static final String STATE = "State";
	public static final String OPER = "OpUid";
	public static final String COMP = "Comp";
	public static final String PID = "Pid";
	public static final String ID = "Id";
	public static final String NO = "No";

	/** 节点样式的6种类型：0.普通 1.串行(子流程) 2.条件 3.会签 5.并行 */
	
	/** 普通简单节点 */
	public static final String STYLE_NORMAL = "0"; // 普通简单节点
	/** 串行节点 */
	public static final String STYLE_SERIAL = "1"; // 串行节点
	/** 条件节点 */
	public static final String STYLE_CONDITION = "2"; // 条件节点
	/** 会签节点 */
	public static final String STYLE_JOINTLY = "3"; // 会签节点
	/** 并行节点 */
	public static final String STYLE_PARALLEL = "5"; // 并行节点

	/** 控制节点的7种状态：0.就绪（草稿） 1.处理中 2.完成 4.驳回 5.取消 */

	/** 就绪 */
	public static final String STATE_READY = "0"; // 就绪（草稿）
	/** 处理中 */
	public static final String STATE_WAITING = "1"; // 处理中
	/** 完成 */
	public static final String STATE_COMPLETE = "2"; // 完成
	/** 跳过 */
	public static final String STATE_SKIP = "3"; // 跳过或忽略：IGNORE
	/** 驳回 */
	public static final String STATE_REJECT = "4"; // 驳回
	/** 取消 */
	public static final String STATE_CANCEL = "5"; // 取消
	/** 空闲 */
	public static final String STATE_FUTURE = "9"; // 空闲状态，还没走到的节点状态

	/** 消息提醒的4种类型 */

	/** 不通知 */
	public static final String NOTICE_NONE = "0";
	/** 电子邮件通知 */
	public static final String NOTICE_MAIL = "1"; // 电子邮件通知
	/** 手机短信通知 */
	public static final String NOTICE_SMS = "2"; // 手机短信通知
	/** 微信消息通知 */
	public static final String NOTICE_WECHAT = "3"; // 微信消息

	// 尝试执行两次2次
	public static int TRY_TIMES = 2; // 固定值
	// 业务模式按2位数一层
	public static int MODE_TIER_W = 2; // 固定值
	// 流程节点按2位数一层
	public static int NODE_TIER_W = 2; // 固定值

	// 部门按3位数一层
	static int DEPT_TIER_W = 0;

	/** 部门表名称 */
	static String DEPT_TABLE = null;

	/** 部门表名称 */
	public static int leafW() {
		if (DEPT_TIER_W == 0) {
			String w = ConfUtil.getConf("dept.tier.w", "3");
			DEPT_TIER_W = Pattern.matches("[1-9]", w) ? Integer.parseInt(w) : 3;
		}
		return DEPT_TIER_W;
	}

	/** 部门表名称 */
	public static String dept() {
		if (DEPT_TABLE == null)
			DEPT_TABLE = ConfUtil.getConf("dept.table", "FF_DEPT");
		return DEPT_TABLE;
	}
/*
	static {
		DEPT_TIER_W = Integer.parseInt(ConfUtil.getConf("dept.tier.w", "3"));
		DEPT_TABLE = ConfUtil.getConf("dept.table", DEPT_TABLE);
	}
*/
	/**
	 * 参数转换
	 */
	public static <T> Map<String, T> putParams(Map<String, T> params,
			String key1, String key2) {
		String[] keys1 = ConfUtil.getValid(key1).split(ConfUtil.COMMA);
		String[] keys2 = ConfUtil.getValid(key2).split(ConfUtil.COMMA);
		for (int i = 0; i < keys2.length && i < keys1.length; i++) {
			if (keys2[i].equals(keys1[1]))
				continue;
			params.put(keys2[i], params.get(keys1[1]));
			params.remove(keys1[1]);
		}
		return params;
	}

	/**
	 * 流程、表单、模板编号转换
	 */
	public static <T> Map<String, Object> modeNo(Map<String, T> mode,
			String src, String key) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, mode.get(Mode.COMP));
		where.put(key + NO, mode.get(Mode.KEY + src + NO));
		return where;
	}

	/**
	 * 工作流编号查询条件转换
	 */
	public static <T> Map<String, Object> flowNo(Map<String, T> cond,
			String src, String key) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(src + COMP));
		where.put(key + FLOWNO, cond.get(src + FLOWNO));
		return where;
	}

	/**
	 * 调整like查询条件
	 */
	public static void likeCond(Map<String, Object> cond, String key) {
		if (cond.containsKey(key)) {
			cond.put(pHolder(key, "LIKE"), "%" + cond.get(key) + "%");
			// 删除冗余的查询条件
			cond.remove(key);
		}
	}

	/**
	 * 因系统包含第三状态（2.系统预置不能禁用），因此需要：<br>
	 * 倒置查询条件，如果 state='1'\'2' >> 变换为 {state}!='0' <br>
	 */
	public static void invertCond(Map<String, Object> cond, String key) {
		Object state = cond.get(key);
		if (state != null && !Const.STR_0.equals(state)) {
			// state=1\2
			cond.put(pHolder(key, Const.NEQ), Const.STR_0);
			cond.remove(key);
		} else if (Const.ALL.equals(state)) {
			cond.remove(key);
		}
	}

	/**
	 * 同层级内数据的查询条件：brother
	 */
	public static <T> Map<String, Object> brother(String key,
			Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		where.put(key + PID, cond.get(key + PID));
		return where;
	}

	/**
	 * 父层级数据的查询条件：parent
	 */
	public static <T> Map<String, Object> parent(String key, Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		where.put(key + ID, cond.get(key + PID));
		return where;
	}

	/**
	 * 子层级数据的查询条件：child
	 */
	public static <T> Map<String, Object> child(String key, Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		where.put(key + PID, cond.get(key + ID));
		return where;
	}

	/**
	 * 当前级及子层级数据的查询条件：child
	 */
	public static <T> Map<String, Object> family(String key, Map<String, T> cond) {
		Map<String, Object> where = new HashMap<>();
		where.put(key + COMP, cond.get(key + COMP));
		key += ID;
		where.put(pHolder(key, "LIKE"), cond.get(key) + "%");
		return where;
	}

	/**
	 * 拼接两个“或”条件关系
	 * @param keys
	 * @deprecated 这个方法已被弃用，并且用UtilsService中同名方法替换。
	 */
	public static String sqlOr(String[] keys) {
		return "(" + pHolder(keys[0], "={}") + " or " + pHolder(keys[1], "={}") + ")";
	}

	private static String pHolder(Object key, String opr) {
		return "{" + key + "} " + opr;
	}

}
