package cn.ps1.soar.service;

import cn.ps1.aolai.entity.User;
import cn.ps1.aolai.service.AolaiService;
import cn.ps1.aolai.service.UtilsService;
import cn.ps1.aolai.utils.ConfUtil;
import cn.ps1.aolai.utils.Const;
import cn.ps1.aolai.utils.Digest;
import cn.ps1.aolai.utils.FailedException;
import cn.ps1.soar.entity.Define;
import cn.ps1.soar.entity.Form;
import cn.ps1.soar.entity.Mode;
import cn.ps1.soar.entity.Task;
import cn.ps1.soar.utils.FlowUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 自定义表单的维护管理
 * 
 * @author Fulin
 * @version 1.0 $Date: 2023.06.21
 * @since openjdk-1.8
 */
@Service
public class CFormService {

	private static Logger LOG = LoggerFactory.getLogger(CFormService.class);

	@Autowired
	private AolaiService aolai;
	@Autowired
	private UtilsService utils;

	@Autowired
	private ZeroService zeroSvc;

	/**
	 * 保存自定义表单数据
	 */
	public Map<String, String> saveCustomForm(HttpServletRequest req) {
		List<Map<String, Object>> rows = getFormData(req);
		Map<String, String> user = this.utils.userSelf(req);
		String compId = user.get(User.COMP);
		String formNo = Digest.uuid8();

		return saveCustomForm(compId, formNo, rows);
	}

	/**
	 * 共通处理表单数据
	 */
	private List<Map<String, Object>> getFormData(HttpServletRequest req) {
		Map<String, Object> data = utils.jsonParams(req);
		List<Map<String, Object>> rows = utils.obj2List(data.get("list"));
		if (rows.size() == 0)
			throw new FailedException();
		return rows;
	}

	/**
	 * 保存自定义表单数据
	 */
	private Map<String, String> saveCustomForm(String compId, String formNo,
			List<Map<String, Object>> rows) {
		String[] keys = ConfUtil.getValid("customForm").split(ConfUtil.COMMA);
		int rowIdx = 0;
		for (Map<String, Object> row : rows) {
			row.put(Form.NO, formNo); // 先补充formNo数据
			if (!utils.availParams(row, keys))
				throw new FailedException();
			row.put(Form.COMP, compId);
			row.put(Form.IDX, rowIdx++);
		}
		Map<String, String> result = aolai.batchAdd(null, Form.TABLE, rows, null,
				false);
		if (utils.isSuccess(result))
			return utils.success(formNo);
		return result;
	}

	/**
	 * 修改一个自定义表单
	 */
	@Transactional(rollbackFor = { Throwable.class })
	public Map<String, String> setCustomForm(HttpServletRequest req) {
		List<Map<String, Object>> rows = getFormData(req);
		Map<String, String> user = this.utils.userSelf(req);
		String userComp = user.get(User.COMP);
		String formNo = (String) rows.get(0).get(Form.NO);

		Map<String, Object> where = new HashMap<>();
		where.put(Form.NO, formNo);
		where.put(Form.COMP, userComp);
		aolai.delete(Form.TABLE, where);

		return saveCustomForm(userComp, formNo, rows);
	}

	/**
	 * 删除一个自定义表单：taskMode.modeFormNo
	 */
	public Map<String, String> delCustomForm(HttpServletRequest req) {
		Map<String, Object> params = utils.jsonParams(req);
		Map<String, String> user = this.utils.userSelf(req);
		String compId = user.get(User.COMP);
		String formNo = (String) params.get(Form.NO);

		Map<String, Object> where = new HashMap<>();
		where.put(Task.COMP, compId);
		// TASK_MODE->>'$.modeFormNo'
//		String[] keys = { "{", Task.MODE, "}->>'$.", Mode.FORMNO, "' =" };
//		where.put(utils.arr2Str(keys), formNo);
		where.put(utils.jsonExt(Task.MODE, Mode.FORMNO), formNo);
		if (this.aolai.exists(null, Task.TABLE, where))
			return this.utils.failed(ConfUtil.CANT_REMOVE);

		where = utils.sameNo(params, Form.KEY);
		return aolai.delete(null, Form.TABLE, where);
	}

	/**
	 * 获取一个自定义表单
	 */
	public Map<String, Object> getCustomForm(HttpServletRequest req) {
		Map<String, Object> params = utils.jsonParams(req);
		utils.setUserComp(req, params, Form.COMP);
		LOG.debug("-> getCustomForm...{}", params);
		// 默认排序
		Map<String, String> order = new HashMap<>();
		order.put(Form.IDX, "ASC");

		String[] args = { null, Form.TABLE, "getCustomForm", Const.STR_0 };
		return utils.success(this.aolai.findAll(params, order, args));
	}

	/**
	 * 获取自定义表单一览
	 */
	// formName,formId,formField,formTitle,formType,formComponent,formIdx
	public Map<String, Object> getCustomFormList() {
		Map<String, Object> where = new HashMap<>();
		where.put(Form.STATE, Const.STR_1);
		where.put(Form.IDX, 0); // 仅显示一行数据
		Map<String, String> order = new HashMap<>();
		order.put(Form.CREATE, "DESC");
		String[] args = { null, Form.TABLE, "getCustomFormList", Const.STR_0 };
		return utils.success(aolai.findAll(where, order, args));
	}

	/**
	 * 新增保存一个自定义表单部件
	 */
	public Map<String, String> saveFormPart(HttpServletRequest req) {
		Map<String, Object> data = utils.jsonParams(req);
		// addFormPart\addEnumInfo
		data = FlowUtil.putParams(data, "addFormPart", "addEnumInfo");
		utils.setUserComp(req, data, Define.COMP);
		return zeroSvc.addEnumInfo(data);
	}

	/**
	 * 获取一个自定义部件组
	 */
	public Object getFormPart(HttpServletRequest req) {
		Map<String, Object> where = utils.jsonParams(req);
		where = FlowUtil.putParams(where, "getFormPart", "getEnumType");
		utils.setUserComp(req, where, Define.COMP);
		Map<String, String> result = zeroSvc.getEnumInfo(where);
		if (result.containsKey(Const.STS))
			return result;
		result = FlowUtil.putParams(result, "addEnumInfo", "addFormPart");
		return utils.success(result);
	}

	/**
	 * 删除一个自定义部件组
	 */
	public Map<String, String> delFormPart(HttpServletRequest req) {
		Map<String, Object> where = utils.jsonParams(req);
		where = FlowUtil.putParams(where, "delFormPart", "delEnumInfo");
		utils.setUserComp(req, where, Define.COMP);
		return zeroSvc.delEnumInfo(where);
	}

}
