package cn.ps1.soar.dao;

import java.util.Map;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * Aolai基础框架相关业务，对mybatis进行封装扩展
 * 
 * @author Fulin
 * @since openjdk-1.8
 */
@Repository
public interface FlowDao {

	/** 获取条件顺序 */
	public int getActionIdx(@Param("cond") String cond);

	/** 忽略未完成的就绪的并行子节点 */
	public int skipParallelNodes(@Param("joinTables") String joinTables,
			@Param("map") Map<String, Object> map);

	/** 自动递增审批节点表的审批序号（避免主键冲突：从大到小降序处理） */
	public int incrApproveIdx(@Param("table") String table,
			@Param("map") Map<String, Object> map);

	/** 归集单个岗位职责包含的员工数 */
	public int groupEmpByJob(Map<String, Object> cond);

}
