package cn.ps1.soar.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import cn.ps1.soar.service.ZeroService;

/**
 * 共享第三服务接口
 * 
 * @author Fulin
 * @version 1.0 $Date: 2024.03.10
 * @since openjdk-1.8
 */
@Scope("singleton")
@RestController
@RequestMapping(value = "/w", produces = "application/json;charset=UTF-8")
public class ZeroController {

	@Autowired
	private ZeroService zeroSvc;

	/**
	 * 获取枚举信息一览
	 */
	@RequestMapping(value = "/addEnumInfo", method = RequestMethod.POST)
	public Object addEnumInfo(HttpServletRequest req) {
		return zeroSvc.addEnumInfo(req);
	}

	/**
	 * 删除一个自定义表单
	 */
	@RequestMapping(value = "/delEnumInfo", method = RequestMethod.POST)
	public Object delEnumInfo(HttpServletRequest req) {
		return zeroSvc.delEnumInfo(req);
	}

	/**
	 * 获取枚举（数据分类类型）值
	 */
	@RequestMapping(value = "/getEnumType", method = RequestMethod.POST)
	public Object getEnumType(HttpServletRequest req) {
		return zeroSvc.getEnumType(req);
	}

	/**
	 * 获取枚举信息一览
	 */
	@RequestMapping(value = "/getEnumList", method = RequestMethod.POST)
	public Object getEnumList(HttpServletRequest req) {
		return zeroSvc.getEnumList(req);
	}

	/**
	 * 获取一条枚举信息
	 */
	@RequestMapping(value = "/getEnumInfo", method = RequestMethod.POST)
	public Object getEnumInfo(HttpServletRequest req) {
		return zeroSvc.getEnumInfo(req);
	}

	/**
	 * 同步用户信息
	 */
	@RequestMapping(value = "/syncUsers", method = RequestMethod.POST)
	public Object syncUsers(HttpServletRequest req) {
		return zeroSvc.syncUsers(req);
	}

	/**
	 * 同步部门信息
	 */
	@RequestMapping(value = "/syncDepts", method = RequestMethod.POST)
	public Object syncDepts(HttpServletRequest req) {
		return zeroSvc.syncDepts(req);
	}

	/**
	 * 仅为了测试用
	 */
	@RequestMapping(value = "/testBy", method = RequestMethod.POST)
	public Object testBy(HttpServletRequest req) {
		return zeroSvc.testBy(req);
	}

}
